/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.power;

import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.power.TileCapacitorBank;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.render.BoundingBox;
import crazypants.render.CubeRenderer;
import crazypants.render.IconUtil;
import crazypants.render.RenderUtil;
import crazypants.util.BlockCoord;
import crazypants.vecmath.Vector2f;
import crazypants.vecmath.Vector4d;
import crazypants.vecmath.Vertex;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class CapacitorBankRenderer
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private static final BlockCoord DEFAULT_BC = new BlockCoord(0, 0, 0);
    private static final BlockCoord[] DEFAULT_MB = new BlockCoord[]{DEFAULT_BC};
    private static final double PIXEL_SIZE = 0.0625;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.renderBlock(null, PowerHandlerUtil.getStoredEnergyForItem(item) / TileCapacitorBank.BASE_CAP.getMaxEnergyStored(), item.func_77960_j());
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float f) {
        if (!(te instanceof TileCapacitorBank)) {
            return;
        }
        Minecraft.func_71410_x().field_71460_t.func_78483_a(0.0);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        TileCapacitorBank cb = (TileCapacitorBank)te;
        this.renderBlock(cb, cb.getEnergyStoredRatio(), 0);
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71460_t.func_78463_b(0.0);
    }

    private void renderBlock(TileCapacitorBank te, double filledRatio, int meta) {
        float[] brightness;
        BlockCoord[] mb;
        BlockCoord myBC;
        RenderUtil.bindBlockTexture();
        Tessellator tes = Tessellator.field_78398_a;
        if (te != null && te.isMultiblock()) {
            myBC = new BlockCoord(te);
            mb = te.multiblock;
        } else {
            myBC = DEFAULT_BC;
            mb = DEFAULT_MB;
        }
        List<GaugeBounds> gaugeBounds = this.calculateGaugeBounds(myBC, mb);
        float maxBrightness = 0.0f;
        if (te != null) {
            brightness = new float[6];
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                brightness[dir.ordinal()] = RenderUtil.claculateTotalBrightnessForLocation(te.func_145831_w(), te.field_145851_c + dir.offsetX, te.field_145848_d + dir.offsetY, te.field_145849_e + dir.offsetZ);
                maxBrightness = Math.max(brightness[dir.ordinal()], maxBrightness);
            }
        } else {
            brightness = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
            maxBrightness = 1.0f;
        }
        tes.func_78382_b();
        CubeRenderer.render(BoundingBox.UNIT_CUBE, EnderIO.blockCapacitorBank.func_149691_a(0, 0), null, brightness, true);
        tes.func_78381_a();
        GL11.glEnable((int)32823);
        GL11.glPolygonOffset((float)-1.0f, (float)-1.0f);
        tes.func_78382_b();
        tes.func_78369_a(maxBrightness, maxBrightness, maxBrightness, 1.0f);
        if (te != null) {
            this.renderBorder((IBlockAccess)te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e, meta);
        } else {
            this.renderBorder(null, 0, 0, 0, meta);
        }
        for (GaugeBounds gb : gaugeBounds) {
            this.renderGaugeOnFace(gb, EnderIO.blockCapacitorBank.overlayIcon);
        }
        tes.func_78381_a();
        GL11.glPolygonOffset((float)-3.0f, (float)-3.0f);
        tes.func_78382_b();
        tes.func_78369_a(maxBrightness, maxBrightness, maxBrightness, 1.0f);
        for (GaugeBounds gb : gaugeBounds) {
            this.renderFillBarOnFace(gb, EnderIO.blockCapacitorBank.fillBarIcon, filledRatio);
        }
        tes.func_78381_a();
        GL11.glDisable((int)32823);
    }

    private void renderBorder(IBlockAccess blockAccess, int x, int y, int z, int meta) {
        IIcon texture = meta == 0 ? EnderIO.blockAlloySmelter.func_149733_h(3) : IconUtil.whiteTexture;
        for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
            RenderUtil.renderConnectedTextureFace(blockAccess, EnderIO.blockCapacitorBank, x, y, z, face, texture, blockAccess == null, false, false);
        }
    }

    private List<GaugeBounds> calculateGaugeBounds(BlockCoord me, BlockCoord[] mb) {
        ArrayList<GaugeBounds> res = new ArrayList<GaugeBounds>();
        for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
            boolean isRight;
            if (face == ForgeDirection.UP || face == ForgeDirection.DOWN || !(isRight = this.isRightFace(me, mb, face))) continue;
            res.add(new GaugeBounds(me, mb, face));
        }
        return res;
    }

    private void renderGaugeOnFace(GaugeBounds gb, IIcon icon) {
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78375_b((float)gb.face.offsetX, (float)gb.face.offsetY, (float)gb.face.offsetZ);
        Vector2f u = gb.getMinMaxU(icon);
        List<Vertex> corners = gb.bb.getCornersWithUvForFace(gb.face, u.x, u.y, icon.func_94206_g(), icon.func_94210_h());
        for (Vertex coord : corners) {
            tes.func_78375_b(coord.nx(), coord.ny(), coord.nz());
            if (coord.uv != null) {
                tes.func_78374_a(coord.x(), coord.y(), coord.z(), (double)coord.u(), (double)coord.v());
                continue;
            }
            tes.func_78374_a(coord.x(), coord.y(), coord.z(), 0.0, 0.0);
        }
    }

    private void renderFillBarOnFace(GaugeBounds gb, IIcon icon, double filledRatio) {
        int totalPixels;
        int targetPixelCount;
        int pixelsBellowFace = gb.vInfo.index < 2 ? gb.vInfo.index * VPos.BOTTOM.numFillPixels : VPos.BOTTOM.numFillPixels + VPos.MIDDLE.numFillPixels * (gb.vInfo.index - 1);
        if (pixelsBellowFace >= (targetPixelCount = (int)Math.max(0L, Math.round((double)(totalPixels = gb.vInfo.verticalHeight == 1 ? VPos.SINGLE_BLOCK.numFillPixels : VPos.BOTTOM.numFillPixels + VPos.TOP.numFillPixels + VPos.MIDDLE.numFillPixels * (gb.vInfo.verticalHeight - 2)) * filledRatio)))) {
            return;
        }
        VPos yPos = gb.vInfo.pos;
        int numPixelsLeft = targetPixelCount - pixelsBellowFace;
        int fillPixels = Math.min(numPixelsLeft, yPos.numFillPixels);
        double maxY = (double)yPos.fillOffset * 0.0625 + (double)fillPixels * 0.0625;
        float vWidth = icon.func_94210_h() - icon.func_94206_g();
        float maxV = icon.func_94206_g() + (float)maxY * vWidth;
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78375_b((float)gb.face.offsetX, (float)gb.face.offsetY, (float)gb.face.offsetZ);
        Vector2f u = gb.getMinMaxU(icon);
        List<Vertex> corners = gb.bb.getCornersWithUvForFace(gb.face, u.x, u.y, icon.func_94206_g(), maxV);
        for (Vertex coord : corners) {
            if (coord.uv != null) {
                tes.func_78374_a(coord.x(), Math.min(coord.y(), maxY), coord.z(), (double)coord.u(), (double)coord.v());
                continue;
            }
            tes.func_78374_a(coord.x(), Math.min(coord.y(), maxY), coord.z(), 0.0, 0.0);
        }
    }

    private boolean isRightFace(BlockCoord me, BlockCoord[] mb, ForgeDirection dir) {
        int myRightVal;
        Vector4d uPlane = RenderUtil.getUPlaneForFace(dir);
        int max = myRightVal = (int)uPlane.x * me.x + (int)uPlane.y * me.y + (int)uPlane.z * me.z;
        for (BlockCoord bc : mb) {
            int val = (int)uPlane.x * bc.x + (int)uPlane.y * bc.y + (int)uPlane.z * bc.z;
            if (val <= max) continue;
            max = val;
        }
        return myRightVal == max;
    }

    static class GaugeBounds {
        final BoundingBox bb;
        final VInfo vInfo;
        final ForgeDirection face;

        GaugeBounds(BlockCoord me, BlockCoord[] mb, ForgeDirection face) {
            this.face = face;
            this.vInfo = this.getVPosForFace(me, mb, face);
            Vector4d uPlane = RenderUtil.getUPlaneForFace(face);
            float scaleX = uPlane.x != 0.0 ? 0.25f : 1.0f;
            float scaleY = uPlane.y != 0.0 ? 0.25f : 1.0f;
            float scaleZ = uPlane.z != 0.0 ? 0.25f : 1.0f;
            this.bb = BoundingBox.UNIT_CUBE.scale(scaleX, scaleY, scaleZ);
        }

        Vector2f getMinMaxU(IIcon icon) {
            VPos yPos = this.vInfo.pos;
            float uWidth = icon.func_94212_f() - icon.func_94209_e();
            float uOffset = yPos.uOffset * uWidth;
            float minU = icon.func_94209_e() + uOffset;
            float maxU = minU + uWidth * 0.25f;
            return new Vector2f(minU, maxU);
        }

        private VInfo getVPosForFace(BlockCoord me, BlockCoord[] mb, ForgeDirection face) {
            int maxY = me.y;
            int minY = me.y;
            boolean vHeight = true;
            for (BlockCoord bc : mb) {
                if (bc.x != me.x || bc.z != me.z || this.containsLocaction(mb, bc.getLocation(face))) continue;
                maxY = Math.max(maxY, bc.y);
                minY = Math.min(minY, bc.y);
            }
            if (maxY == me.y && minY == me.y) {
                return new VInfo(VPos.SINGLE_BLOCK, 1, 0);
            }
            int height = maxY - minY + 1;
            if (maxY > me.y) {
                return me.y > minY ? new VInfo(VPos.MIDDLE, height, me.y - minY) : new VInfo(VPos.BOTTOM, height, 0);
            }
            return new VInfo(VPos.TOP, height, height - 1);
        }

        private boolean containsLocaction(BlockCoord[] mb, BlockCoord location) {
            for (BlockCoord bc : mb) {
                if (!location.equals(bc)) continue;
                return true;
            }
            return false;
        }
    }

    static class VInfo {
        VPos pos;
        int verticalHeight;
        int index;

        VInfo(VPos pos, int verticalHeight, int index) {
            this.pos = pos;
            this.verticalHeight = verticalHeight;
            this.index = index;
        }
    }

    static enum VPos {
        SINGLE_BLOCK(0.0f, 10, 3),
        BOTTOM(0.5f, 13, 3),
        MIDDLE(0.75f, 16, 0),
        TOP(0.25f, 13, 0);

        final float uOffset;
        final int numFillPixels;
        final int fillOffset;

        private VPos(float uOffset, int numFillPixels, int fillOffset) {
            this.uOffset = uOffset;
            this.numFillPixels = numFillPixels;
            this.fillOffset = fillOffset;
        }
    }
}

