/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.reservoir;

import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class ReservoirTank
extends FluidTank {
    static final FluidStack WATER = FluidRegistry.getFluidStack((String)"water", (int)0);

    ReservoirTank(int quantity, int capacity) {
        super(WATER.getFluid(), quantity, capacity);
    }

    ReservoirTank(int capacity) {
        this(0, capacity);
    }

    ReservoirTank(FluidStack liquid, int capacity) {
        super(liquid, capacity);
    }

    public int getAmount() {
        return this.getFluid().amount;
    }

    public float getFilledRatio() {
        return (float)this.getAmount() / (float)this.getCapacity();
    }

    public boolean isFull() {
        return this.getAmount() >= this.getCapacity();
    }

    public void setAmount(int amount) {
        FluidStack newLiquid = WATER.copy();
        newLiquid.amount = Math.min(this.getCapacity(), amount);
        this.setFluid(newLiquid);
    }

    public FluidStack getFluid() {
        FluidStack l = super.getFluid();
        if (l == null) {
            l = WATER.copy();
            this.setFluid(l);
        }
        return l;
    }

    public int getAvailableSpace() {
        return this.getCapacity() - this.getAmount();
    }

    public void addAmount(int amount) {
        this.setAmount(this.getAmount() + amount);
    }

    public void setCapacity(int capacity) {
        super.setCapacity(capacity);
        if (this.getAmount() > capacity) {
            this.setAmount(capacity);
        }
    }
}

