/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.asm.module;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.applecore.asm.IClassTransformerModule;
import squeek.asmhelper.ASMHelper;
import squeek.asmhelper.ObfHelper;

public class ModuleFoodEatingSpeed
implements IClassTransformerModule {
    @Override
    public String[] getClassesToTransform() {
        return new String[]{"net.minecraft.entity.player.EntityPlayer", "net.minecraft.client.renderer.ItemRenderer"};
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (ASMHelper.isCauldron()) {
            return basicClass;
        }
        boolean isObfuscated = !name.equals(transformedName);
        ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
        if (transformedName.equals("net.minecraft.entity.player.EntityPlayer")) {
            this.addItemInUseMaxDurationField(classNode);
            MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, isObfuscated ? "a" : "setItemInUse", isObfuscated ? "(Ladd;I)V" : "(Lnet/minecraft/item/ItemStack;I)V");
            if (methodNode == null) {
                throw new RuntimeException(classNode.name + ": setItemInUse method not found");
            }
            this.patchSetItemInUse(classNode, methodNode, isObfuscated);
            methodNode = ASMHelper.findMethodNodeOfClass(classNode, isObfuscated ? "bz" : "getItemInUseDuration", "()I");
            if (methodNode != null) {
                this.patchGetItemInUseDuration(classNode, methodNode, isObfuscated);
            }
        } else if (transformedName.equals("net.minecraft.client.renderer.ItemRenderer")) {
            MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, isObfuscated ? "a" : "renderItemInFirstPerson", "(F)V");
            if (methodNode != null) {
                this.patchRenderItemInFirstPerson(classNode, methodNode, isObfuscated);
            } else {
                throw new RuntimeException(classNode.name + ": setItemInUse method not found");
            }
        }
        return ASMHelper.writeClassToBytes(classNode);
    }

    private void patchRenderItemInFirstPerson(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        AbstractInsnNode targetNode = ASMHelper.findFirstInstructionWithOpcode(method, 182);
        while (!(targetNode == null || ((MethodInsnNode)targetNode).name.equals(isObfuscated ? "n" : "getMaxItemUseDuration") && ((MethodInsnNode)targetNode).desc.equals("()I") && ((MethodInsnNode)targetNode).owner.equals(ObfHelper.getInternalClassName("net.minecraft.item.ItemStack")))) {
            targetNode = ASMHelper.findNextInstructionWithOpcode(targetNode, 182);
        }
        if (targetNode == null) {
            throw new RuntimeException("ItemRenderer.renderItemInFirstPerson: INVOKEVIRTUAL getMaxItemUseDuration instruction not found");
        }
        MethodInsnNode getItemInUseCountNode = (MethodInsnNode)ASMHelper.findPreviousInstructionWithOpcode(targetNode, 182);
        if (getItemInUseCountNode == null) {
            throw new RuntimeException("ItemRenderer.renderItemInFirstPerson: INVOKEVIRTUAL getItemInUseCount instruction not found");
        }
        int entityclientplayermpIndex = ((VarInsnNode)getItemInUseCountNode.getPrevious()).var;
        String entityclientplayermpInternalName = getItemInUseCountNode.owner;
        ((VarInsnNode)targetNode.getPrevious()).var = entityclientplayermpIndex;
        FieldInsnNode getFieldNode = new FieldInsnNode(180, entityclientplayermpInternalName, "itemInUseMaxDuration", "I");
        method.instructions.insert(targetNode, (AbstractInsnNode)getFieldNode);
        ASMHelper.removeFromInsnListUntil(method.instructions, targetNode, (AbstractInsnNode)getFieldNode);
    }

    private void patchGetItemInUseDuration(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        InsnList needle = new InsnList();
        needle.add((AbstractInsnNode)new VarInsnNode(25, 0));
        needle.add((AbstractInsnNode)new FieldInsnNode(180, ObfHelper.getInternalClassName("net.minecraft.entity.player.EntityPlayer"), isObfuscated ? "f" : "itemInUse", ObfHelper.getDescriptor("net.minecraft.item.ItemStack")));
        needle.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.item.ItemStack"), isObfuscated ? "n" : "getMaxItemUseDuration", "()I"));
        InsnList replacement = new InsnList();
        replacement.add((AbstractInsnNode)new VarInsnNode(25, 0));
        replacement.add((AbstractInsnNode)new VarInsnNode(25, 0));
        replacement.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name.replace('.', '/'), "itemInUseMaxDuration", "I"));
        replacement.add((AbstractInsnNode)new MethodInsnNode(184, "squeek/applecore/asm/Hooks", "getItemInUseMaxDuration", "(Lnet/minecraft/entity/player/EntityPlayer;I)I"));
        int numReplacementsMade = ASMHelper.findAndReplaceAll(method.instructions, needle, replacement);
        if (numReplacementsMade == 0) {
            throw new RuntimeException("EntityPlayer.getItemInUseDuration: no replacements made");
        }
    }

    private void patchSetItemInUse(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        AbstractInsnNode targetNode = ASMHelper.findFirstInstructionWithOpcode(method, 181);
        while (targetNode != null && !((FieldInsnNode)targetNode).name.equals(isObfuscated ? "g" : "itemInUseCount")) {
            targetNode = ASMHelper.findNextInstructionWithOpcode(targetNode, 181);
        }
        if (targetNode == null) {
            throw new RuntimeException("EntityPlayer.setItemInUse: PUTFIELD itemInUseCount instruction not found");
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 2));
        toInject.add((AbstractInsnNode)new FieldInsnNode(181, classNode.name.replace(".", "/"), "itemInUseMaxDuration", "I"));
        method.instructions.insert(targetNode, toInject);
    }

    private void addItemInUseMaxDurationField(ClassNode classNode) {
        classNode.fields.add(new FieldNode(1, "itemInUseMaxDuration", "I", null, null));
    }
}

