/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.asm.module;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.applecore.api.hunger.HealthRegenEvent;
import squeek.applecore.asm.Hooks;
import squeek.applecore.asm.IClassTransformerModule;
import squeek.asmhelper.ASMHelper;

public class ModulePeacefulRegen
implements IClassTransformerModule {
    @Override
    public String[] getClassesToTransform() {
        return new String[]{"net.minecraft.entity.player.EntityPlayer"};
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.entity.player.EntityPlayer")) {
            boolean isObfuscated = !name.equals(transformedName);
            ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
            MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, isObfuscated ? "e" : "onLivingUpdate", "()V");
            if (methodNode != null) {
                this.addPeacefulRegenHook(classNode, methodNode, isObfuscated);
                if (!ASMHelper.isCauldron()) {
                    return ASMHelper.writeClassToBytes(classNode);
                }
                return ASMHelper.writeClassToBytesNoDeobfSkipFrames(classNode);
            }
            throw new RuntimeException("EntityPlayer: onLivingUpdate method not found");
        }
        return basicClass;
    }

    public void addPeacefulRegenHook(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        AbstractInsnNode relevantConditional = ASMHelper.find(method.instructions, (AbstractInsnNode)new LdcInsnNode((Object)"naturalRegeneration"));
        JumpInsnNode ifNode = (JumpInsnNode)ASMHelper.find(relevantConditional, (AbstractInsnNode)new JumpInsnNode(153, new LabelNode()));
        LabelNode ifBlockEndLabel = ifNode.label;
        AbstractInsnNode targetNode = ASMHelper.find((AbstractInsnNode)ifNode, (AbstractInsnNode)new InsnNode(12)).getPrevious();
        int peacefulRegenEventIndex = this.firePeacefulRegenEventAndStoreEventBefore(method, targetNode, ifBlockEndLabel);
        InsnList healAmountNeedle = new InsnList();
        healAmountNeedle.add((AbstractInsnNode)new InsnNode(12));
        InsnList healAmountReplacement = new InsnList();
        healAmountReplacement.add((AbstractInsnNode)new VarInsnNode(25, peacefulRegenEventIndex));
        healAmountReplacement.add((AbstractInsnNode)new FieldInsnNode(180, Type.getInternalName(HealthRegenEvent.PeacefulRegen.class), "deltaHealth", "F"));
        ASMHelper.findAndReplace(method.instructions, healAmountNeedle, healAmountReplacement, targetNode);
        InsnList ifNotCanceledBlock = new InsnList();
        LabelNode ifNotCanceled = new LabelNode();
        ifNotCanceledBlock.add((AbstractInsnNode)new VarInsnNode(25, peacefulRegenEventIndex));
        ifNotCanceledBlock.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(HealthRegenEvent.PeacefulRegen.class), "isCanceled", "()Z"));
        ifNotCanceledBlock.add((AbstractInsnNode)new JumpInsnNode(154, ifNotCanceled));
        method.instructions.insertBefore(targetNode, ifNotCanceledBlock);
        method.instructions.insertBefore((AbstractInsnNode)ifBlockEndLabel, (AbstractInsnNode)ifNotCanceled);
    }

    private int firePeacefulRegenEventAndStoreEventBefore(MethodNode method, AbstractInsnNode injectPoint, LabelNode endLabel) {
        LabelNode peacefulRegenEventStart = new LabelNode();
        LocalVariableNode peacefulRegenEvent = new LocalVariableNode("peacefulRegenEvent", Type.getDescriptor(HealthRegenEvent.PeacefulRegen.class), null, peacefulRegenEventStart, endLabel, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(peacefulRegenEvent);
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "firePeacefulRegenEvent", "(Lnet/minecraft/entity/player/EntityPlayer;)Lsqueek/applecore/api/hunger/HealthRegenEvent$PeacefulRegen;"));
        toInject.add((AbstractInsnNode)new VarInsnNode(58, peacefulRegenEvent.index));
        toInject.add((AbstractInsnNode)peacefulRegenEventStart);
        method.instructions.insertBefore(injectPoint, toInject);
        return peacefulRegenEvent.index;
    }
}

