/*
 * Decompiled with CFR 0.152.
 */
package squeek.asmhelper;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;
import squeek.asmhelper.InsnComparator;
import squeek.asmhelper.ObfRemappingClassWriter;

public class ASMHelper {
    private static Boolean isCauldron = null;
    public static InsnComparator insnComparator = new InsnComparator();
    private static Printer printer = new Textifier();
    private static TraceMethodVisitor methodprinter = new TraceMethodVisitor(printer);

    public static boolean isCauldron() {
        if (isCauldron == null) {
            try {
                byte[] bytes = ((LaunchClassLoader)ASMHelper.class.getClassLoader()).getClassBytes("net.minecraftforge.cauldron.api.Cauldron");
                isCauldron = bytes != null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return isCauldron;
    }

    public static ClassNode readClassFromBytes(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    public static byte[] writeClassToBytes(ClassNode classNode) {
        ObfRemappingClassWriter writer = new ObfRemappingClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static byte[] writeClassToBytesNoDeobf(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static byte[] writeClassToBytesNoDeobfSkipFrames(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static boolean isLabelOrLineNumber(AbstractInsnNode insn) {
        return insn.getType() == 8 || insn.getType() == 15;
    }

    public static AbstractInsnNode getOrFindInstructionOfType(AbstractInsnNode firstInsnToCheck, int type) {
        return ASMHelper.getOrFindInstructionWithOpcode(firstInsnToCheck, type, false);
    }

    public static AbstractInsnNode getOrFindInstructionOfType(AbstractInsnNode firstInsnToCheck, int type, boolean reverseDirection) {
        AbstractInsnNode instruction = firstInsnToCheck;
        while (instruction != null) {
            if (instruction.getType() == type) {
                return instruction;
            }
            instruction = reverseDirection ? instruction.getPrevious() : instruction.getNext();
        }
        return null;
    }

    public static AbstractInsnNode getOrFindInstructionWithOpcode(AbstractInsnNode firstInsnToCheck, int opcode) {
        return ASMHelper.getOrFindInstructionWithOpcode(firstInsnToCheck, opcode, false);
    }

    public static AbstractInsnNode getOrFindInstructionWithOpcode(AbstractInsnNode firstInsnToCheck, int opcode, boolean reverseDirection) {
        AbstractInsnNode instruction = firstInsnToCheck;
        while (instruction != null) {
            if (instruction.getOpcode() == opcode) {
                return instruction;
            }
            instruction = reverseDirection ? instruction.getPrevious() : instruction.getNext();
        }
        return null;
    }

    public static AbstractInsnNode getOrFindLabelOrLineNumber(AbstractInsnNode firstInsnToCheck) {
        return ASMHelper.getOrFindInstruction(firstInsnToCheck, false);
    }

    public static AbstractInsnNode getOrFindLabelOrLineNumber(AbstractInsnNode firstInsnToCheck, boolean reverseDirection) {
        AbstractInsnNode instruction = firstInsnToCheck;
        while (instruction != null) {
            if (ASMHelper.isLabelOrLineNumber(instruction)) {
                return instruction;
            }
            instruction = reverseDirection ? instruction.getPrevious() : instruction.getNext();
        }
        return null;
    }

    public static AbstractInsnNode getOrFindInstruction(AbstractInsnNode firstInsnToCheck) {
        return ASMHelper.getOrFindInstruction(firstInsnToCheck, false);
    }

    public static AbstractInsnNode getOrFindInstruction(AbstractInsnNode firstInsnToCheck, boolean reverseDirection) {
        AbstractInsnNode instruction = firstInsnToCheck;
        while (instruction != null) {
            if (!ASMHelper.isLabelOrLineNumber(instruction)) {
                return instruction;
            }
            instruction = reverseDirection ? instruction.getPrevious() : instruction.getNext();
        }
        return null;
    }

    public static AbstractInsnNode findFirstInstruction(MethodNode method) {
        return ASMHelper.getOrFindInstruction(method.instructions.getFirst());
    }

    public static AbstractInsnNode findFirstInstructionWithOpcode(MethodNode method, int opcode) {
        return ASMHelper.getOrFindInstructionWithOpcode(method.instructions.getFirst(), opcode);
    }

    public static AbstractInsnNode findLastInstructionWithOpcode(MethodNode method, int opcode) {
        return ASMHelper.getOrFindInstructionWithOpcode(method.instructions.getLast(), opcode, true);
    }

    public static AbstractInsnNode findNextInstruction(AbstractInsnNode instruction) {
        return ASMHelper.getOrFindInstruction(instruction.getNext());
    }

    public static AbstractInsnNode findNextInstructionWithOpcode(AbstractInsnNode instruction, int opcode) {
        return ASMHelper.getOrFindInstructionWithOpcode(instruction.getNext(), opcode);
    }

    public static AbstractInsnNode findNextLabelOrLineNumber(AbstractInsnNode instruction) {
        return ASMHelper.getOrFindLabelOrLineNumber(instruction.getNext());
    }

    public static AbstractInsnNode findPreviousInstruction(AbstractInsnNode instruction) {
        return ASMHelper.getOrFindInstruction(instruction.getPrevious(), true);
    }

    public static AbstractInsnNode findPreviousInstructionWithOpcode(AbstractInsnNode instruction, int opcode) {
        return ASMHelper.getOrFindInstructionWithOpcode(instruction.getPrevious(), opcode, true);
    }

    public static AbstractInsnNode findPreviousLabelOrLineNumber(AbstractInsnNode instruction) {
        return ASMHelper.getOrFindLabelOrLineNumber(instruction.getPrevious(), true);
    }

    public static MethodNode findMethodNodeOfClass(ClassNode classNode, String methodName, String methodDesc) {
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(methodName) || methodDesc != null && !method.desc.equals(methodDesc)) continue;
            return method;
        }
        return null;
    }

    public static LabelNode findEndLabel(MethodNode method) {
        for (AbstractInsnNode instruction = method.instructions.getLast(); instruction != null; instruction = instruction.getPrevious()) {
            if (!(instruction instanceof LabelNode)) continue;
            return (LabelNode)instruction;
        }
        return null;
    }

    public static int removeFromInsnListUntil(InsnList insnList, AbstractInsnNode startInclusive, AbstractInsnNode endNotInclusive) {
        int numDeleted = 0;
        for (AbstractInsnNode insnToRemove = startInclusive; insnToRemove != null && insnToRemove != endNotInclusive; insnToRemove = insnToRemove.getNext()) {
            ++numDeleted;
            insnList.remove(insnToRemove.getPrevious());
        }
        return numDeleted;
    }

    public static AbstractInsnNode move(AbstractInsnNode start, int distance) {
        AbstractInsnNode movedTo = start;
        for (int i = 0; i < Math.abs(distance) && movedTo != null; ++i) {
            movedTo = distance > 0 ? movedTo.getNext() : movedTo.getPrevious();
        }
        return movedTo;
    }

    public static boolean instructionsMatch(AbstractInsnNode first, AbstractInsnNode second) {
        return insnComparator.areInsnsEqual(first, second);
    }

    public static boolean patternMatches(InsnList checkFor, AbstractInsnNode checkAgainst) {
        AbstractInsnNode instruction = checkFor.getFirst();
        while (instruction != null) {
            if (checkAgainst == null) {
                return false;
            }
            if (ASMHelper.isLabelOrLineNumber(instruction)) {
                instruction = instruction.getNext();
                continue;
            }
            if (ASMHelper.isLabelOrLineNumber(checkAgainst)) {
                checkAgainst = checkAgainst.getNext();
                continue;
            }
            if (!ASMHelper.instructionsMatch(instruction, checkAgainst)) {
                return false;
            }
            instruction = instruction.getNext();
            checkAgainst = checkAgainst.getNext();
        }
        return true;
    }

    public static AbstractInsnNode find(InsnList haystack, InsnList needle) {
        return ASMHelper.find(haystack.getFirst(), needle);
    }

    public static AbstractInsnNode find(AbstractInsnNode haystackStart, InsnList needle) {
        if (needle.getFirst() == null) {
            return null;
        }
        int needleStartOpcode = needle.getFirst().getOpcode();
        AbstractInsnNode checkAgainstStart = ASMHelper.getOrFindInstructionWithOpcode(haystackStart, needleStartOpcode);
        while (checkAgainstStart != null) {
            if (ASMHelper.patternMatches(needle, checkAgainstStart)) {
                return checkAgainstStart;
            }
            checkAgainstStart = ASMHelper.findNextInstructionWithOpcode(checkAgainstStart, needleStartOpcode);
        }
        return null;
    }

    public static AbstractInsnNode find(InsnList haystack, AbstractInsnNode needle) {
        return ASMHelper.find(haystack.getFirst(), needle);
    }

    public static AbstractInsnNode find(AbstractInsnNode haystackStart, AbstractInsnNode needle) {
        InsnList insnList = new InsnList();
        insnList.add(needle);
        return ASMHelper.find(haystackStart, insnList);
    }

    public static AbstractInsnNode findAndReplace(InsnList haystack, InsnList needle, InsnList replacement) {
        return ASMHelper.findAndReplace(haystack, needle, replacement, haystack.getFirst());
    }

    public static AbstractInsnNode findAndReplace(InsnList haystack, InsnList needle, InsnList replacement, AbstractInsnNode haystackStart) {
        AbstractInsnNode foundStart = ASMHelper.find(haystackStart, needle);
        if (foundStart != null) {
            haystack.insertBefore(foundStart, ASMHelper.cloneInsnList(replacement));
            AbstractInsnNode afterNeedle = ASMHelper.move(foundStart, needle.size());
            ASMHelper.removeFromInsnListUntil(haystack, foundStart, afterNeedle);
            return afterNeedle;
        }
        return null;
    }

    public static int findAndReplaceAll(InsnList haystack, InsnList needle, InsnList replacement) {
        return ASMHelper.findAndReplaceAll(haystack, needle, replacement, haystack.getFirst());
    }

    public static int findAndReplaceAll(InsnList haystack, InsnList needle, InsnList replacement, AbstractInsnNode haystackStart) {
        int numReplaced = 0;
        while ((haystackStart = ASMHelper.findAndReplace(haystack, needle, replacement, haystackStart)) != null) {
            ++numReplaced;
        }
        return numReplaced;
    }

    public static InsnList cloneInsnList(InsnList source) {
        AbstractInsnNode instruction;
        InsnList clone = new InsnList();
        HashMap<LabelNode, LabelNode> labelMap = new HashMap<LabelNode, LabelNode>();
        for (instruction = source.getFirst(); instruction != null; instruction = instruction.getNext()) {
            if (!(instruction instanceof LabelNode)) continue;
            labelMap.put((LabelNode)instruction, new LabelNode());
        }
        for (instruction = source.getFirst(); instruction != null; instruction = instruction.getNext()) {
            clone.add(instruction.clone(labelMap));
        }
        return clone;
    }

    public static LocalVariableNode findLocalVariableOfMethod(MethodNode method, String varName, String varDesc) {
        for (LocalVariableNode localVar : method.localVariables) {
            if (!localVar.name.equals(varName) || !localVar.desc.equals(varDesc)) continue;
            return localVar;
        }
        return null;
    }

    public static String getInsnListAsString(InsnList insnList) {
        insnList.accept((MethodVisitor)methodprinter);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        return sw.toString();
    }

    public static String getMethodAsString(MethodNode method) {
        method.accept((MethodVisitor)methodprinter);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        return sw.toString();
    }
}

