/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.skeleton;

import java.util.Random;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.Properties;
import toast.specialMobs.entity.ISpecialMob;
import toast.specialMobs.entity.SpecialMobData;

public class Entity_SpecialSkeleton
extends EntitySkeleton
implements ISpecialMob {
    private static final double BABY_CHANCE = Properties.getDouble("_mob_stats", "baby_skeleton_chance");
    private static final double BOW_CHANCE = Properties.getDouble("_mob_stats", "bow_chance_skeleton");
    private static final double BOW_CHANCE_WITHER = Properties.getDouble("_mob_stats", "bow_chance_wither");
    private static final UUID babySpeedBoostUUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier babySpeedBoostModifier = new AttributeModifier(babySpeedBoostUUID, "Baby speed boost", 0.5, 1);
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/skeleton/skeleton.png"), new ResourceLocation("textures/entity/skeleton/wither_skeleton.png")};
    public EntityAIArrowAttack field_85037_d;
    public EntityAIAttackOnCollide field_85038_e;
    private final SpecialMobData specialData = new SpecialMobData((EntityLiving)this, TEXTURES);

    public Entity_SpecialSkeleton(World world) {
        super(world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(12, (Object)0);
        this.initTypeAI();
    }

    protected void initTypeAI() {
        this.setRangedAI(1.0, 20, 60, 15.0f);
        this.setMeleeAI(1.2);
    }

    protected void setRangedAI(double moveSpeed, int minDelay, int maxDelay, float range) {
        this.field_85037_d = new EntityAIArrowAttack((IRangedAttackMob)this, moveSpeed, minDelay, maxDelay, range);
    }

    protected void setMeleeAI(double moveSpeed) {
        this.field_85038_e = new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, moveSpeed, false);
    }

    @Override
    public SpecialMobData getSpecialData() {
        return this.specialData;
    }

    @Override
    public void adjustEntityAttributes() {
        ItemStack itemStack;
        if (this.field_70146_Z.nextDouble() < BABY_CHANCE) {
            this.setChild(true);
        }
        if (this.func_82202_m() == 1) {
            if (this.field_70146_Z.nextDouble() < BOW_CHANCE_WITHER) {
                itemStack = new ItemStack((Item)Items.field_151031_f);
                float tension = this.field_70170_p.func_147462_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70146_Z.nextFloat() < 0.25f * tension) {
                    EnchantmentHelper.func_77504_a((Random)this.field_70146_Z, (ItemStack)itemStack, (int)((int)(5.0f + tension * (float)this.field_70146_Z.nextInt(18))));
                }
                this.func_70062_b(0, itemStack);
            }
        } else if (this.field_70146_Z.nextDouble() >= BOW_CHANCE) {
            itemStack = new ItemStack(Items.field_151052_q);
            float tension = this.field_70170_p.func_147462_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (this.field_70146_Z.nextFloat() < 0.25f * tension) {
                EnchantmentHelper.func_77504_a((Random)this.field_70146_Z, (ItemStack)itemStack, (int)((int)(5.0f + tension * (float)this.field_70146_Z.nextInt(18))));
            }
            this.func_70062_b(0, itemStack);
        }
        float prevMax = this.func_110138_aP();
        this.adjustTypeAttributes();
        this.func_70606_j(this.func_110138_aP() + this.func_110143_aJ() - prevMax);
    }

    protected void adjustTypeAttributes() {
    }

    public void func_82196_d(EntityLivingBase target, float range) {
        EntityArrow arrow = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, target, 1.6f, this.getTypeArrowSpread());
        arrow.func_70239_b((double)(range * this.getTypeArrowDamage()) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.field_73013_u.func_151525_a() * 0.11f));
        int power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)this.func_70694_bm());
        int punch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)this.func_70694_bm());
        if (power > 0) {
            arrow.func_70239_b(arrow.func_70242_d() + (double)power * 0.5 + 0.5);
        }
        if (punch > 0) {
            arrow.func_70240_a(punch);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)this.func_70694_bm()) > 0 || this.func_82202_m() == 1) {
            arrow.func_70015_d(100);
        }
        this.func_85030_a("random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow);
    }

    protected float getTypeArrowSpread() {
        return 14 - this.field_70170_p.field_73013_u.func_151525_a() * 4;
    }

    protected float getTypeArrowDamage() {
        return 2.0f;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().onUpdate();
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        return this.getSpecialData().onSpawnWithEgg(data, (EntityLiving)new EntitySkeleton(this.field_70170_p));
    }

    public boolean func_70631_g_() {
        if (this.field_70729_aU && !this.field_70170_p.field_72995_K) {
            return false;
        }
        return this.getChild();
    }

    public boolean getChild() {
        return this.field_70180_af.func_75683_a(12) == 1;
    }

    public void setChild(boolean value) {
        this.field_70180_af.func_75692_b(12, (Object)((byte)(value ? 1 : 0)));
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance attribute = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            attribute.func_111124_b(babySpeedBoostModifier);
            if (value) {
                attribute.func_111121_a(babySpeedBoostModifier);
            }
        }
    }

    public boolean func_70652_k(Entity target) {
        this.func_71038_i();
        if (super.func_70652_k(target)) {
            this.onTypeAttack(target);
            return true;
        }
        return false;
    }

    protected void onTypeAttack(Entity target) {
    }

    public void func_85036_m() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.field_85038_e);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.field_85037_d);
        ItemStack itemStack = this.func_70694_bm();
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemBow) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.field_85037_d);
        } else {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.field_85038_e);
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        if (this.getChild()) {
            tag.func_74757_a("IsBaby", true);
        }
        this.getSpecialData().writeToNBT(tag);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
        this.getSpecialData().readFromNBT(tag);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        super.func_70628_a(recentlyHit, looting);
    }
}

