/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.spider;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.EffectHelper;
import toast.specialMobs.entity.spider.EntityBabySpider;
import toast.specialMobs.entity.spider.Entity_SpecialSpider;

public class EntityMotherSpider
extends Entity_SpecialSpider {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("SpecialMobs:textures/models/spider/mother.png"), new ResourceLocation("SpecialMobs:textures/models/spider/mother_eyes.png")};

    public EntityMotherSpider(World world) {
        super(world);
        this.func_70105_a(1.8f, 1.2f);
        this.getSpecialData().setTextures(TEXTURES);
        this.getSpecialData().resetRenderScale(1.4f);
        this.field_70728_aV += 2;
    }

    @Override
    public void adjustTypeAttributes() {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 16.0);
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111264_e, 3.0);
        this.getSpecialData().setHealTime(20);
    }

    public int func_70658_aO() {
        return Math.min(20, super.func_70658_aO() + 6);
    }

    @Override
    protected void func_70628_a(boolean recentlyHit, int looting) {
        super.func_70628_a(recentlyHit, looting);
        if (recentlyHit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_70099_a(new ItemStack(Items.field_151063_bx, 1, EntityList.func_75619_a((Entity)new EntitySpider(this.field_70170_p))), 0.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityBabySpider baby = null;
            int i = this.field_70146_Z.nextInt(4) + 3;
            while (i-- > 0) {
                baby = new EntityBabySpider(this.field_70170_p);
                baby.func_82149_j((Entity)this);
                baby.func_70784_b(this.func_70777_m());
                baby.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)baby);
            }
            this.field_70170_p.func_72956_a((Entity)baby, "random.pop", 1.0f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            if (baby != null) {
                baby.func_70656_aK();
            }
        }
    }

    protected void func_70600_l(int superRare) {
        String name;
        ItemStack itemStack;
        if (this.field_70146_Z.nextBoolean()) {
            Item[] armor = new Item[]{Items.field_151020_U, Items.field_151023_V, Items.field_151022_W, Items.field_151029_X};
            String[] armorNames = new String[]{"Helmet", "Chestplate", "Leggings", "Boots"};
            int choice = this.field_70146_Z.nextInt(armor.length);
            itemStack = new ItemStack(armor[choice]);
            name = armorNames[choice];
        } else {
            Item[] tools = new Item[]{Items.field_151052_q, Items.field_151031_f, Items.field_151050_s, Items.field_151049_t, Items.field_151051_r};
            String[] toolNames = new String[]{"Sword", "Bow", "Pickaxe", "Axe", "Shovel"};
            int choice = this.field_70146_Z.nextInt(tools.length);
            itemStack = new ItemStack(tools[choice]);
            name = toolNames[choice];
        }
        int maxDamage = Math.max(itemStack.func_77958_k() - 25, 1);
        int damage = itemStack.func_77958_k() - this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(maxDamage) + 1);
        if (damage > maxDamage) {
            damage = maxDamage;
        } else if (damage < 1) {
            damage = 1;
        }
        itemStack.func_77964_b(damage);
        EffectHelper.setItemName(itemStack, "Partially Digested " + name, 10);
        EffectHelper.addItemText(itemStack, "\u00a77\u00a7oIt's a bit slimy...");
        EffectHelper.enchantItem(this.field_70146_Z, itemStack, 30);
        EffectHelper.overrideEnchantment(itemStack, Enchantment.field_77347_r, 10);
        this.func_70099_a(itemStack, 0.0f);
    }
}

