/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.endercollector;

import com.rwtema.extrautils.helper.XUHelper;
import com.rwtema.extrautils.helper.XURandom;
import com.rwtema.extrautils.item.ItemNodeUpgrade;
import com.rwtema.extrautils.network.NetworkHandler;
import com.rwtema.extrautils.network.packets.PacketParticleCurve;
import com.rwtema.extrautils.network.packets.PacketParticleLine;
import com.rwtema.extrautils.network.packets.PacketTempChat;
import com.rwtema.extrautils.tileentity.endercollector.CollectorHandler;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.Facing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnderCollector
extends TileEntity {
    int range = 8;
    AxisAlignedBB bounds;
    boolean isStuffed = false;
    boolean init = false;
    LinkedList<ItemStack> items = new LinkedList();
    private static final Vec3[] sides = new Vec3[]{Vec3.func_72443_a((double)0.0, (double)-1.0, (double)0.0), Vec3.func_72443_a((double)0.0, (double)1.0, (double)0.0), Vec3.func_72443_a((double)0.0, (double)0.0, (double)-1.0), Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0), Vec3.func_72443_a((double)-1.0, (double)0.0, (double)0.0), Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0)};
    ItemStack filter;
    private Random rand = XURandom.getInstance();

    public void setRange(int r) {
        this.range = r;
        this.bounds = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - (float)r / 2.0f), (double)((float)this.field_145848_d - (float)r / 2.0f), (double)((float)this.field_145849_e - (float)r / 2.0f), (double)((float)this.field_145851_c + (float)r / 2.0f + 1.0f), (double)((float)this.field_145848_d + (float)r / 2.0f + 1.0f), (double)((float)this.field_145849_e + (float)r / 2.0f + 1.0f));
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.init = true;
        if (!this.isStuffed && this.field_145850_b.func_82737_E() % 40L == 0L) {
            if (this.bounds == null) {
                this.setRange(this.range);
            }
            List entitiesWithinAABB = this.field_145850_b.func_72872_a(EntityItem.class, this.bounds);
            for (EntityItem entityItem : entitiesWithinAABB) {
                this.grabEntity(entityItem);
            }
        }
        if (!this.items.isEmpty()) {
            if (this.isStuffed && this.field_145850_b.func_82737_E() % 10L != 0L) {
                return;
            }
            int side = this.func_145832_p() % 6;
            ListIterator<ItemStack> iter = this.items.listIterator();
            TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + Facing.field_71586_b[side], this.field_145848_d + Facing.field_71587_c[side], this.field_145849_e + Facing.field_71585_d[side]);
            if (tileEntity instanceof IInventory) {
                IInventory inventory = (IInventory)tileEntity;
                while (iter.hasNext()) {
                    ItemStack next = (ItemStack)iter.next();
                    if ((next = XUHelper.invInsert(inventory, next.func_77946_l(), side ^ 1)) != null) {
                        iter.set(next);
                        continue;
                    }
                    iter.remove();
                }
            }
        }
        this.isStuffed = !this.items.isEmpty();
        this.updateMeta();
    }

    public void updateMeta() {
        int oldMeta = this.func_145832_p();
        int newMeta = oldMeta % 6 + (this.isStuffed ? 6 : 0);
        if (newMeta != oldMeta) {
            this.changeMeta(newMeta);
        }
    }

    public void changeMeta(int newMeta) {
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, newMeta, 2);
    }

    public boolean inRange(Entity entity) {
        if (this.isStuffed || !this.init || this.field_145846_f) {
            return false;
        }
        if (this.bounds == null) {
            this.setRange(this.range);
        }
        return this.bounds.func_72326_a(entity.field_70121_D);
    }

    public void func_145843_s() {
        super.func_145843_s();
        CollectorHandler.unregister(this);
    }

    public void onChunkUnload() {
        CollectorHandler.unregister(this);
    }

    public void func_145834_a(World p_145834_1_) {
        super.func_145834_a(p_145834_1_);
        if (!this.field_145850_b.field_72995_K) {
            CollectorHandler.register(this);
        }
    }

    public void grabEntity(EntityItem entity) {
        if (entity.field_70128_L) {
            return;
        }
        int side = this.func_145832_p() % 6;
        if (this.field_145850_b.func_147437_c(this.field_145851_c + Facing.field_71586_b[side], this.field_145848_d + Facing.field_71587_c[side], this.field_145849_e + Facing.field_71585_d[side])) {
            return;
        }
        TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + Facing.field_71586_b[side], this.field_145848_d + Facing.field_71587_c[side], this.field_145849_e + Facing.field_71585_d[side]);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inv = (IInventory)tileEntity;
        ItemStack stack = entity.func_70096_w().func_82710_f(10);
        if (stack == null) {
            return;
        }
        if (this.filter != null && !ItemNodeUpgrade.matchesFilterItem(stack, this.filter)) {
            return;
        }
        ItemStack itemStack = XUHelper.simInvInsert(inv, stack, side ^ 1);
        if (itemStack != null && itemStack.field_77994_a == stack.field_77994_a) {
            return;
        }
        this.items.add(stack);
        this.signalChange(entity);
        entity.func_92058_a(null);
        entity.func_70106_y();
    }

    public void signalChange(EntityItem item) {
        int side = this.func_145832_p() % 6;
        NetworkHandler.sendToAllAround(new PacketParticleCurve(item, Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5 - (double)ForgeDirection.getOrientation((int)side).offsetX * 0.4), (double)((double)this.field_145848_d + 0.5 - (double)ForgeDirection.getOrientation((int)side).offsetY * 0.4), (double)((double)this.field_145849_e + 0.5 - (double)ForgeDirection.getOrientation((int)side).offsetZ * 0.4)), sides[side]), this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, 32.0);
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return newBlock != oldBlock;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.range = tag.func_74771_c("Range");
        NBTTagList tagList = tag.func_150295_c("Items", XUHelper.NBTIds.NBT.id);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(i));
            if (itemStack == null) continue;
            this.items.add(itemStack);
        }
        if (tag.func_74764_b("Filter")) {
            this.filter = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Filter"));
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList list = new NBTTagList();
        for (ItemStack item : this.items) {
            list.func_74742_a((NBTBase)item.func_77955_b(new NBTTagCompound()));
        }
        tag.func_74782_a("Items", (NBTBase)list);
        tag.func_74774_a("Range", (byte)this.range);
        if (this.filter != null) {
            tag.func_74782_a("Filter", (NBTBase)this.filter.func_77955_b(new NBTTagCompound()));
        }
    }

    public void onNeighbourChange() {
    }

    public void drawLine(Vec3 a, Vec3 b) {
        NetworkHandler.sendToAllAround(new PacketParticleLine(a, b), this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, 32.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (this.isStuffed) {
            this.dropItems();
            return true;
        }
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem != null) {
            if (this.filter == null && ItemNodeUpgrade.isFilter(heldItem)) {
                this.filter = heldItem.func_77946_l();
                heldItem.field_77994_a = 0;
                this.field_145850_b.func_147471_g(x, y, z);
                return true;
            }
            if (this.filter != null && XUHelper.isWrench(heldItem)) {
                try {
                    CollectorHandler.dontCollect = true;
                    this.dropItem(this.filter.func_77946_l());
                }
                finally {
                    CollectorHandler.dontCollect = false;
                }
                this.filter = null;
                this.field_145850_b.func_147471_g(x, y, z);
                return true;
            }
        }
        if (!player.func_70093_af()) {
            ++this.range;
            if (this.range > 8) {
                this.range = 1;
            }
        } else {
            --this.range;
            if (this.range < 1) {
                this.range = 8;
            }
        }
        this.setRange(this.range);
        this.drawCube(this.bounds);
        PacketTempChat.sendChat(player, (IChatComponent)new ChatComponentText(String.format("Range: %s  (%s, %s, %s -> %s, %s, %s)", Float.valueOf((float)this.range / 2.0f), this.bounds.field_72340_a, this.bounds.field_72338_b, this.bounds.field_72339_c, this.bounds.field_72336_d, this.bounds.field_72337_e, this.bounds.field_72334_f)));
        return true;
    }

    public void drawCube(AxisAlignedBB b) {
        double x0 = b.field_72340_a;
        double x1 = b.field_72336_d;
        double y0 = b.field_72338_b;
        double y1 = b.field_72337_e;
        double z0 = b.field_72339_c;
        double z1 = b.field_72334_f;
        Vec3 p000 = Vec3.func_72443_a((double)x0, (double)y0, (double)z0);
        Vec3 p001 = Vec3.func_72443_a((double)x0, (double)y0, (double)z1);
        Vec3 p010 = Vec3.func_72443_a((double)x0, (double)y1, (double)z0);
        Vec3 p011 = Vec3.func_72443_a((double)x0, (double)y1, (double)z1);
        Vec3 p100 = Vec3.func_72443_a((double)x1, (double)y0, (double)z0);
        Vec3 p101 = Vec3.func_72443_a((double)x1, (double)y0, (double)z1);
        Vec3 p110 = Vec3.func_72443_a((double)x1, (double)y1, (double)z0);
        Vec3 p111 = Vec3.func_72443_a((double)x1, (double)y1, (double)z1);
        Vec3 center = Vec3.func_72443_a((double)((x0 + x1) / 2.0), (double)((y0 + y1) / 2.0), (double)((z0 + z1) / 2.0));
        this.drawLine(p000, p001);
        this.drawLine(p000, p010);
        this.drawLine(p000, p100);
        this.drawLine(p001, p011);
        this.drawLine(p001, p101);
        this.drawLine(p010, p011);
        this.drawLine(p010, p110);
        this.drawLine(p100, p101);
        this.drawLine(p100, p110);
        this.drawLine(p011, p111);
        this.drawLine(p101, p111);
        this.drawLine(p110, p111);
        this.drawLine(center, p000);
        this.drawLine(center, p001);
        this.drawLine(center, p010);
        this.drawLine(center, p011);
        this.drawLine(center, p100);
        this.drawLine(center, p101);
        this.drawLine(center, p110);
        this.drawLine(center, p111);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropItems() {
        try {
            CollectorHandler.dontCollect = true;
            for (ItemStack itemstack : this.items) {
                this.dropItem(itemstack);
            }
        }
        finally {
            CollectorHandler.dontCollect = false;
        }
        this.items.clear();
        this.isStuffed = false;
    }

    public void dropItem(ItemStack itemstack) {
        float dx = this.rand.nextFloat() * 0.8f + 0.1f;
        float dy = this.rand.nextFloat() * 0.8f + 0.1f;
        float dz = this.rand.nextFloat() * 0.8f + 0.1f;
        while (itemstack.field_77994_a > 0) {
            int j1 = this.rand.nextInt(21) + 10;
            if (j1 > itemstack.field_77994_a) {
                j1 = itemstack.field_77994_a;
            }
            itemstack.field_77994_a -= j1;
            EntityItem entityitem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + dx), (double)((float)this.field_145848_d + dy), (double)((float)this.field_145849_e + dz), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
            if (itemstack.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
            }
            entityitem.field_70159_w = this.rand.nextGaussian() * (double)0.05f;
            entityitem.field_70181_x = this.rand.nextGaussian() * (double)0.05f + (double)0.2f;
            entityitem.field_70179_y = this.rand.nextGaussian() * (double)0.05f;
            this.field_145850_b.func_72838_d((Entity)entityitem);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound t = new NBTTagCompound();
        if (this.filter != null) {
            t.func_74782_a("Filter", (NBTBase)this.filter.func_77955_b(new NBTTagCompound()));
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 4, t);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound tag = pkt.func_148857_g();
        this.filter = tag.func_74764_b("Filter") ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Filter")) : null;
    }
}

