/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.entities.StructureEntityInfo;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.schematics.SchematicFile;
import ivorius.reccomplex.structures.schematics.SchematicLoader;
import ivorius.reccomplex.utils.ServerTranslations;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class CommandExportSchematic
extends CommandBase {
    public String func_71517_b() {
        return RCConfig.commandPrefix + "exportschematic";
    }

    public String func_71518_a(ICommandSender var1) {
        return ServerTranslations.usage("commands.strucExportSchematic.usage");
    }

    public void func_71515_b(ICommandSender commandSender, String[] args) {
        EntityPlayerMP player = CommandExportSchematic.func_71521_c((ICommandSender)commandSender);
        StructureEntityInfo structureEntityInfo = RCCommands.getStructureEntityInfo((Entity)player);
        if (!structureEntityInfo.hasValidSelection()) {
            throw ServerTranslations.commandException("commands.selectModify.noSelection", new Object[0]);
        }
        BlockCoord smaller = structureEntityInfo.selectedPoint1.getLowerCorner(structureEntityInfo.selectedPoint2);
        BlockCoord bigger = structureEntityInfo.selectedPoint1.getHigherCorner(structureEntityInfo.selectedPoint2);
        int x = smaller.x;
        int y = smaller.y;
        int z = smaller.z;
        int width = bigger.x - smaller.x + 1;
        int height = bigger.y - smaller.y + 1;
        int length = bigger.z - smaller.z + 1;
        String structureName = args.length >= 1 ? args[0] : "NewStructure_" + commandSender.func_130014_f_().field_73012_v.nextInt(1000);
        BlockCoord lowerCoord = new BlockCoord(x, y, z);
        BlockCoord higherCoord = new BlockCoord(x + width - 1, y + height - 1, z + length - 1);
        IvWorldData data = new IvWorldData(player.func_130014_f_(), new BlockArea(lowerCoord, higherCoord), true);
        SchematicFile schematicFile = CommandExportSchematic.convert(data, lowerCoord);
        SchematicLoader.writeSchematicByName(schematicFile, structureName);
        commandSender.func_145747_a(ServerTranslations.format("commands.strucExportSchematic.success", structureName));
    }

    public static SchematicFile convert(IvWorldData worldData, BlockCoord referenceCoord) {
        SchematicFile schematicFile = new SchematicFile((short)worldData.blockCollection.width, (short)worldData.blockCollection.height, (short)worldData.blockCollection.length);
        for (BlockCoord coord : worldData.blockCollection) {
            int index = schematicFile.getBlockIndex(coord.x, coord.y, coord.z);
            schematicFile.blocks[index] = worldData.blockCollection.getBlock(coord);
            schematicFile.metadatas[index] = worldData.blockCollection.getMetadata(coord);
        }
        for (TileEntity tileEntity : worldData.tileEntities) {
            NBTTagCompound teCompound = new NBTTagCompound();
            IvWorldData.moveTileEntityForGeneration((TileEntity)tileEntity, (BlockCoord)referenceCoord.invert());
            tileEntity.func_145841_b(teCompound);
            IvWorldData.moveTileEntityForGeneration((TileEntity)tileEntity, (BlockCoord)referenceCoord);
            schematicFile.tileEntityCompounds.add(teCompound);
        }
        for (Entity entity : worldData.entities) {
            NBTTagCompound entityCompound = new NBTTagCompound();
            IvWorldData.moveEntityForGeneration((Entity)entity, (BlockCoord)referenceCoord.invert());
            entity.func_70039_c(entityCompound);
            IvWorldData.moveEntityForGeneration((Entity)entity, (BlockCoord)referenceCoord);
            schematicFile.entityCompounds.add(entityCompound);
        }
        return schematicFile;
    }

    public List func_71516_a(ICommandSender commandSender, String[] args) {
        if (args.length == 1) {
            return CommandExportSchematic.func_71531_a((String[])args, StructureRegistry.allStructureIDs());
        }
        return null;
    }
}

