/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.operation.OperationRegistry;
import ivorius.reccomplex.structures.OperationGenerateStructure;
import ivorius.reccomplex.structures.StructureInfo;
import ivorius.reccomplex.structures.StructureInfos;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.generic.GenericStructureInfo;
import ivorius.reccomplex.structures.generic.gentypes.NaturalGenerationInfo;
import ivorius.reccomplex.utils.ServerTranslations;
import ivorius.reccomplex.worldgen.StructureGenerator;
import java.util.List;
import java.util.Random;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class CommandGenerateStructure
extends CommandBase {
    public String func_71517_b() {
        return RCConfig.commandPrefix + "gen";
    }

    public String func_71518_a(ICommandSender var1) {
        return ServerTranslations.usage("commands.strucGen.usage");
    }

    public void func_71515_b(ICommandSender commandSender, String[] args) {
        if (args.length <= 0) {
            throw ServerTranslations.wrongUsageException("commands.strucGen.usage", new Object[0]);
        }
        String structureName = args[0];
        StructureInfo structureInfo = StructureRegistry.getStructure(structureName);
        World world = commandSender.func_130014_f_();
        if (structureInfo == null) {
            throw ServerTranslations.commandException("commands.strucGen.noStructure", structureName);
        }
        int x = commandSender.func_82114_b().field_71574_a;
        int z = commandSender.func_82114_b().field_71573_c;
        if (args.length >= 3) {
            x = MathHelper.func_76128_c((double)CommandGenerateStructure.func_110666_a((ICommandSender)commandSender, (double)x, (String)args[1]));
            z = MathHelper.func_76128_c((double)CommandGenerateStructure.func_110666_a((ICommandSender)commandSender, (double)z, (String)args[2]));
        }
        if (structureInfo instanceof GenericStructureInfo) {
            Random random = world.field_73012_v;
            AxisAlignedTransform2D transform = AxisAlignedTransform2D.transform((int)(structureInfo.isRotatable() ? random.nextInt(4) : 0), (structureInfo.isMirrorable() && random.nextBoolean() ? 1 : 0) != 0);
            int[] size = StructureInfos.structureSize(structureInfo, transform);
            int genX = x - size[0] / 2;
            int genZ = z - size[2] / 2;
            List<NaturalGenerationInfo> naturalGenerationInfos = structureInfo.generationInfos(NaturalGenerationInfo.class);
            int genY = naturalGenerationInfos.size() > 0 ? naturalGenerationInfos.get((int)0).ySelector.selectY(world, random, StructureInfos.structureBoundingBox(new BlockCoord(genX, 0, genZ), size)) : world.func_72976_f(x, z);
            BlockCoord coord = new BlockCoord(genX, genY, genZ);
            OperationRegistry.queueOperation(new OperationGenerateStructure((GenericStructureInfo)structureInfo, transform, coord, false, structureName), commandSender);
        } else {
            StructureGenerator.randomInstantly(world, world.field_73012_v, structureInfo, null, x, z, false, structureName);
        }
    }

    public List func_71516_a(ICommandSender commandSender, String[] args) {
        if (args.length == 1) {
            return CommandGenerateStructure.func_71531_a((String[])args, StructureRegistry.allStructureIDs());
        }
        if (args.length == 2 || args.length == 3) {
            return CommandGenerateStructure.func_71530_a((String[])args, (String[])new String[]{"~"});
        }
        return null;
    }
}

