/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.events;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ivorius.ivtoolkit.rendering.grid.GridRenderer;
import ivorius.reccomplex.client.rendering.SelectionRenderer;
import ivorius.reccomplex.entities.StructureEntityInfo;
import ivorius.reccomplex.items.ItemInputHandler;
import ivorius.reccomplex.worldgen.WorldGenStructures;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import org.lwjgl.opengl.GL11;

public class RCForgeEventHandler {
    private WorldGenStructures worldGenStructures;
    public final Set<StructureBoundingBox> disabledTileDropAreas = new HashSet<StructureBoundingBox>();

    public RCForgeEventHandler() {
        this.worldGenStructures = new WorldGenStructures();
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPreChunkDecoration(PopulateChunkEvent.Pre event) {
        this.worldGenStructures.generate(event.rand, event.chunkX, event.chunkZ, event.world, event.chunkProvider, event.chunkProvider);
    }

    @SubscribeEvent
    public void onEntityConstruction(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer) {
            StructureEntityInfo.initInEntity(event.entity);
        }
    }

    @SubscribeEvent
    public void onEntityDrop(EntityJoinWorldEvent event) {
        int entityZ;
        int entityY;
        int entityX;
        if (event.entity instanceof EntityItem && Iterables.any(this.disabledTileDropAreas, (Predicate)new Predicate<StructureBoundingBox>(entityX = MathHelper.func_76128_c((double)event.entity.field_70165_t), entityY = MathHelper.func_76128_c((double)event.entity.field_70163_u), entityZ = MathHelper.func_76128_c((double)event.entity.field_70161_v)){
            final /* synthetic */ int val$entityX;
            final /* synthetic */ int val$entityY;
            final /* synthetic */ int val$entityZ;
            {
                this.val$entityX = n;
                this.val$entityY = n2;
                this.val$entityZ = n3;
            }

            public boolean apply(StructureBoundingBox input) {
                return input.func_78890_b(this.val$entityX, this.val$entityY, this.val$entityZ);
            }
        })) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onDrawWorld(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        int ticks = mc.field_71439_g.field_70173_aa;
        EntityLivingBase renderEntity = mc.field_71451_h;
        StructureEntityInfo info = StructureEntityInfo.getStructureEntityInfo((Entity)mc.field_71439_g);
        double entityX = renderEntity.field_70142_S + (renderEntity.field_70165_t - renderEntity.field_70142_S) * (double)event.partialTicks;
        double entityY = renderEntity.field_70137_T + (renderEntity.field_70163_u - renderEntity.field_70137_T) * (double)event.partialTicks;
        double entityZ = renderEntity.field_70136_U + (renderEntity.field_70161_v - renderEntity.field_70136_U) * (double)event.partialTicks;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-entityX), (double)(-entityY), (double)(-entityZ));
        if (info != null && info.showGrid) {
            int spacing = 10;
            GL11.glDisable((int)3553);
            GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(MathHelper.func_76128_c((double)(entityX / (double)spacing)) * spacing), (float)(MathHelper.func_76128_c((double)(entityY / (double)spacing)) * spacing), (float)(MathHelper.func_76128_c((double)(entityZ / (double)spacing)) * spacing));
            GridRenderer.renderGrid((int)8, (float)spacing, (float)100.0f, (float)0.05f);
            GL11.glPopMatrix();
            GL11.glEnable((int)3553);
        }
        SelectionRenderer.renderSelection((EntityLivingBase)mc.field_71439_g, ticks, event.partialTicks);
        if (info != null && info.danglingOperation != null) {
            info.danglingOperation.renderPreview(info.getPreviewType(), (World)mc.field_71441_e, ticks, event.partialTicks);
        }
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onMouseInput(MouseEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem != null && heldItem.func_77973_b() instanceof ItemInputHandler && ((ItemInputHandler)heldItem.func_77973_b()).onMouseInput((EntityPlayer)player, heldItem, event.button, event.buttonstate, event.dwheel)) {
            event.setCanceled(true);
        }
    }
}

