/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editmazeblock;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.reccomplex.blocks.TileEntityMazeGenerator;
import ivorius.reccomplex.gui.editmazeblock.TableDataSourceMazePathList;
import ivorius.reccomplex.gui.editmazeblock.TableDataSourceSelection;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCell;
import ivorius.reccomplex.gui.table.TableCellActionListener;
import ivorius.reccomplex.gui.table.TableCellButton;
import ivorius.reccomplex.gui.table.TableCellInteger;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableCellString;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableNavigator;

public class TableDataSourceMazeBlock
extends TableDataSourceSegmented
implements TableCellPropertyListener,
TableCellActionListener {
    public static final int[] DIMENSIONS = new int[]{100, 100, 100};
    private TileEntityMazeGenerator mazeGenerator;
    private TableDelegate tableDelegate;
    private TableNavigator tableNavigator;

    public TableDataSourceMazeBlock(TileEntityMazeGenerator mazeGenerator, TableDelegate tableDelegate, TableNavigator tableNavigator) {
        this.mazeGenerator = mazeGenerator;
        this.tableDelegate = tableDelegate;
        this.tableNavigator = tableNavigator;
    }

    public TileEntityMazeGenerator getMazeGenerator() {
        return this.mazeGenerator;
    }

    public void setMazeGenerator(TileEntityMazeGenerator mazeGenerator) {
        this.mazeGenerator = mazeGenerator;
    }

    public TableDelegate getTableDelegate() {
        return this.tableDelegate;
    }

    public void setTableDelegate(TableDelegate tableDelegate) {
        this.tableDelegate = tableDelegate;
    }

    public TableNavigator getTableNavigator() {
        return this.tableNavigator;
    }

    public void setTableNavigator(TableNavigator tableNavigator) {
        this.tableNavigator = tableNavigator;
    }

    @Override
    public int numberOfSegments() {
        return 4;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return segment == 0 ? 1 : (segment == 1 ? 2 : 3);
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 0) {
            TableCellString cell = new TableCellString("mazeID", this.mazeGenerator.getMazeID());
            cell.addPropertyListener(this);
            return new TableElementCell("Maze ID", cell);
        }
        if (segment == 1) {
            if (index == 0) {
                TableCellButton cell = new TableCellButton("rooms", new TableCellButton.Action("edit", "Edit"));
                cell.addListener(this);
                return new TableElementCell("Rooms", cell);
            }
            if (index == 1) {
                TableCellButton cell = new TableCellButton("exits", new TableCellButton.Action("edit", "Edit"));
                cell.addListener(this);
                return new TableElementCell("Exits", cell);
            }
        } else if (segment == 2) {
            if (index == 0) {
                TableCellInteger cell = new TableCellInteger("xShift", this.mazeGenerator.getStructureShift().x, -50, 50);
                cell.addPropertyListener(this);
                return new TableElementCell("Shift: X", cell);
            }
            if (index == 1) {
                TableCellInteger cell = new TableCellInteger("yShift", this.mazeGenerator.getStructureShift().y, -50, 50);
                cell.addPropertyListener(this);
                return new TableElementCell("Shift: Y", cell);
            }
            if (index == 2) {
                TableCellInteger cell = new TableCellInteger("zShift", this.mazeGenerator.getStructureShift().z, -50, 50);
                cell.addPropertyListener(this);
                return new TableElementCell("Shift: Z", cell);
            }
        } else if (segment == 3) {
            if (index == 0) {
                TableCellInteger cell = new TableCellInteger("roomSizeX", this.mazeGenerator.getRoomSize()[0], 1, 64);
                cell.addPropertyListener(this);
                return new TableElementCell("Room Size: X", cell);
            }
            if (index == 1) {
                TableCellInteger cell = new TableCellInteger("roomSizeY", this.mazeGenerator.getRoomSize()[1], 1, 64);
                cell.addPropertyListener(this);
                return new TableElementCell("Room Size: Y", cell);
            }
            if (index == 2) {
                TableCellInteger cell = new TableCellInteger("roomSizeZ", this.mazeGenerator.getRoomSize()[2], 1, 64);
                cell.addPropertyListener(this);
                return new TableElementCell("Room Size: Z", cell);
            }
        }
        return null;
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if ("mazeID".equals(cell.getID())) {
            this.mazeGenerator.setMazeID((String)cell.getPropertyValue());
        } else if ("xShift".equals(cell.getID())) {
            BlockCoord shift = this.mazeGenerator.getStructureShift();
            this.mazeGenerator.setStructureShift(new BlockCoord(((Integer)cell.getPropertyValue()).intValue(), shift.y, shift.z));
        } else if ("yShift".equals(cell.getID())) {
            BlockCoord shift = this.mazeGenerator.getStructureShift();
            this.mazeGenerator.setStructureShift(new BlockCoord(shift.x, ((Integer)cell.getPropertyValue()).intValue(), shift.z));
        } else if ("zShift".equals(cell.getID())) {
            BlockCoord shift = this.mazeGenerator.getStructureShift();
            this.mazeGenerator.setStructureShift(new BlockCoord(shift.x, shift.y, ((Integer)cell.getPropertyValue()).intValue()));
        } else if ("roomSizeX".equals(cell.getID())) {
            int[] size = this.mazeGenerator.getRoomSize();
            size[0] = (Integer)cell.getPropertyValue();
            this.mazeGenerator.setRoomSize(size);
        } else if ("roomSizeY".equals(cell.getID())) {
            int[] size = this.mazeGenerator.getRoomSize();
            size[1] = (Integer)cell.getPropertyValue();
            this.mazeGenerator.setRoomSize(size);
        } else if ("roomSizeZ".equals(cell.getID())) {
            int[] size = this.mazeGenerator.getRoomSize();
            size[2] = (Integer)cell.getPropertyValue();
            this.mazeGenerator.setRoomSize(size);
        }
    }

    @Override
    public void actionPerformed(TableCell tableElementButton, String actionID) {
        if ("exits".equals(tableElementButton.getID())) {
            this.tableNavigator.pushTable(new GuiTable(this.tableDelegate, new TableDataSourceMazePathList(this.mazeGenerator.mazeExits, this.tableDelegate, this.tableNavigator, this.mazeGenerator.mazeRooms.boundsLower(), this.mazeGenerator.mazeRooms.boundsHigher())));
        } else if ("rooms".equals(tableElementButton.getID())) {
            this.tableNavigator.pushTable(new GuiTable(this.tableDelegate, new TableDataSourceSelection(this.mazeGenerator.mazeRooms, DIMENSIONS, this.tableDelegate, this.tableNavigator)));
        }
    }
}

