/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editmazeblock;

import ivorius.reccomplex.gui.editmazeblock.TableDataSourceConnector;
import ivorius.reccomplex.gui.editmazeblock.TableDataSourceMazePathList;
import ivorius.reccomplex.gui.editmazeblock.TableDataSourceSelection;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCell;
import ivorius.reccomplex.gui.table.TableCellActionListener;
import ivorius.reccomplex.gui.table.TableCellButton;
import ivorius.reccomplex.gui.table.TableCellFloatNullable;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableElements;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.structures.generic.maze.SavedMazeComponent;
import ivorius.reccomplex.utils.IvTranslations;

public class TableDataSourceMazeComponent
extends TableDataSourceSegmented
implements TableCellPropertyListener,
TableCellActionListener {
    public static final int[] DEFAULT_MAX_COMPONENT_SIZE = new int[]{100, 100, 100};
    private SavedMazeComponent component;
    private TableNavigator navigator;
    private TableDelegate tableDelegate;

    public TableDataSourceMazeComponent(SavedMazeComponent component, TableNavigator navigator, TableDelegate tableDelegate) {
        this.component = component;
        this.navigator = navigator;
        this.tableDelegate = tableDelegate;
        this.addManagedSection(0, new TableDataSourceConnector(component.defaultConnector, IvTranslations.get("reccomplex.maze.connector.default")));
    }

    @Override
    public int numberOfSegments() {
        return 4;
    }

    @Override
    public int sizeOfSegment(int segment) {
        switch (segment) {
            case 1: 
            case 2: 
            case 3: {
                return 1;
            }
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        switch (segment) {
            case 1: {
                TableCellFloatNullable cell = new TableCellFloatNullable("weight", TableElements.toFloat(this.component.weight), 1.0f, 0.0f, 10.0f, "D", "C");
                cell.addPropertyListener(this);
                cell.setTooltip(IvTranslations.formatLines("structures.gui.random.weight.tooltip", new Object[0]));
                return new TableElementCell(IvTranslations.get("structures.gui.random.weight"), cell);
            }
            case 2: {
                TableCellButton cell = new TableCellButton("rooms", new TableCellButton.Action("edit", "Edit"));
                cell.addListener(this);
                return new TableElementCell("Rooms", cell);
            }
            case 3: {
                TableCellButton cell = new TableCellButton("exits", new TableCellButton.Action("edit", "Edit"));
                cell.addListener(this);
                return new TableElementCell("Exits", cell);
            }
        }
        return super.elementForIndexInSegment(table, index, segment);
    }

    @Override
    public void actionPerformed(TableCell cell, String actionID) {
        if ("rooms".equals(cell.getID())) {
            this.navigator.pushTable(new GuiTable(this.tableDelegate, new TableDataSourceSelection(this.component.rooms, DEFAULT_MAX_COMPONENT_SIZE, this.tableDelegate, this.navigator)));
        } else if ("exits".equals(cell.getID())) {
            this.navigator.pushTable(new GuiTable(this.tableDelegate, new TableDataSourceMazePathList(this.component.exitPaths, this.tableDelegate, this.navigator, this.component.rooms.boundsLower(), this.component.rooms.boundsHigher())));
        }
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if ("weight".equals(cell.getID())) {
            this.component.weight = TableElements.toDouble((Float)cell.getPropertyValue());
        }
    }
}

