/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import ivorius.ivtoolkit.gui.FloatRange;
import ivorius.ivtoolkit.gui.GuiControlListener;
import ivorius.ivtoolkit.gui.GuiSliderMultivalue;
import ivorius.ivtoolkit.gui.GuiSliderRange;
import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.utils.RangeHelper;
import net.minecraft.client.gui.GuiButton;

public class TableCellIntegerRange
extends TableCellPropertyDefault<IntegerRange>
implements GuiControlListener<GuiSliderMultivalue> {
    private GuiSliderRange slider;
    private boolean enabled = true;
    private int min;
    private int max;

    public TableCellIntegerRange(String id, IntegerRange value, int min, int max) {
        super(id, value);
        this.min = min;
        this.max = max;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.slider != null) {
            this.slider.field_146124_l = enabled;
        }
    }

    @Override
    public void initGui(GuiTable screen) {
        super.initGui(screen);
        Bounds bounds = this.bounds();
        this.slider = new GuiSliderRange(-1, bounds.getMinX(), bounds.getMinY() + (bounds.getHeight() - 20) / 2, bounds.getWidth(), 20, ((IntegerRange)this.property).getMin() + " - " + ((IntegerRange)this.property).getMax());
        this.slider.setMinValue((float)this.min);
        this.slider.setMaxValue((float)this.max);
        this.slider.field_146124_l = this.enabled;
        this.slider.addListener((GuiControlListener)this);
        this.slider.setRange(new FloatRange((IntegerRange)this.property));
        this.slider.field_146125_m = !this.isHidden();
        screen.addButton(this, 0, (GuiButton)this.slider);
    }

    @Override
    public void setHidden(boolean hidden) {
        super.setHidden(hidden);
        if (this.slider != null) {
            this.slider.field_146125_m = !hidden;
        }
    }

    public void valueChanged(GuiSliderMultivalue gui) {
        this.property = RangeHelper.roundedIntRange(this.slider.getRange());
        this.slider.setRange(new FloatRange((IntegerRange)this.property));
        this.slider.field_146126_j = ((IntegerRange)this.property).getMin() + " - " + ((IntegerRange)this.property).getMax();
        this.alertListenersOfChange();
    }

    @Override
    public void setPropertyValue(IntegerRange value) {
        super.setPropertyValue(value);
        if (this.slider != null) {
            this.slider.setRange(new FloatRange(value));
            this.slider.field_146126_j = ((IntegerRange)this.property).getMin() + " - " + ((IntegerRange)this.property).getMax();
        }
    }
}

