/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.BiMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.VillagerRegistry;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.events.RCEventBus;
import ivorius.reccomplex.events.StructureRegistrationEvent;
import ivorius.reccomplex.json.NbtToJson;
import ivorius.reccomplex.json.SerializableStringTypeRegistry;
import ivorius.reccomplex.structures.StructureInfo;
import ivorius.reccomplex.structures.generic.GenericStructureInfo;
import ivorius.reccomplex.structures.generic.StructureSaveHandler;
import ivorius.reccomplex.structures.generic.gentypes.MazeGenerationInfo;
import ivorius.reccomplex.structures.generic.gentypes.StaticGenerationInfo;
import ivorius.reccomplex.structures.generic.gentypes.StructureGenerationInfo;
import ivorius.reccomplex.structures.generic.gentypes.StructureListGenerationInfo;
import ivorius.reccomplex.structures.generic.gentypes.VanillaStructureGenerationInfo;
import ivorius.reccomplex.structures.generic.transformers.Transformer;
import ivorius.reccomplex.worldgen.StructureSelector;
import ivorius.reccomplex.worldgen.villages.GenericVillageCreationHandler;
import ivorius.reccomplex.worldgen.villages.GenericVillagePiece;
import ivorius.reccomplex.worldgen.villages.TemporaryVillagerRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class StructureRegistry {
    private static BiMap<String, StructureInfo> allStructures = HashBiMap.create();
    private static Map<String, String> structureDomains = Maps.newHashMap();
    private static boolean needsGenerationCacheUpdate = true;
    private static Set<String> persistentlyDisabledStructures = new HashSet<String>();
    private static Set<String> generatingStructures = new HashSet<String>();
    private static Map<Class<? extends StructureGenerationInfo>, Collection<Pair<StructureInfo, ? extends StructureGenerationInfo>>> cachedGeneration = new HashMap<Class<? extends StructureGenerationInfo>, Collection<Pair<StructureInfo, ? extends StructureGenerationInfo>>>();
    private static Map<Pair<Integer, String>, StructureSelector> structureSelectors = new HashMap<Pair<Integer, String>, StructureSelector>();
    private static SerializableStringTypeRegistry<Transformer> transformerRegistry = new SerializableStringTypeRegistry<Transformer>("transformer", "type", Transformer.class);
    private static SerializableStringTypeRegistry<StructureGenerationInfo> structureGenerationInfoRegistry = new SerializableStringTypeRegistry<StructureGenerationInfo>("generationInfo", "type", StructureGenerationInfo.class);
    private static Gson gson = StructureRegistry.createGson();

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(GenericStructureInfo.class, (Object)new GenericStructureInfo.Serializer());
        transformerRegistry.constructGson(builder);
        structureGenerationInfoRegistry.constructGson(builder);
        NbtToJson.registerSafeNBTSerializer(builder);
        return builder.create();
    }

    public static boolean registerStructure(StructureInfo info, String key, String domain, boolean generates) {
        StructureRegistrationEvent.Pre event = new StructureRegistrationEvent.Pre(key, info, generates);
        RCEventBus.INSTANCE.post((Event)event);
        if (event.getResult() != Event.Result.DENY && RCConfig.shouldStructureLoad(key, domain)) {
            if (!event.shouldGenerate) {
                persistentlyDisabledStructures.add(key);
            } else {
                persistentlyDisabledStructures.remove(key);
            }
            String baseString = allStructures.containsKey((Object)key) ? "Replaced structure '%s'" : "Registered structure '%s'";
            RecurrentComplex.logger.info(String.format(baseString, key));
            allStructures.put((Object)key, (Object)info);
            structureDomains.put(key, domain);
            StructureRegistry.clearCaches();
            RCEventBus.INSTANCE.post((Event)new StructureRegistrationEvent.Post(key, info, generates));
            return true;
        }
        return false;
    }

    public static boolean registerStructure(ResourceLocation resourceLocation, String key, boolean generates) {
        GenericStructureInfo structureInfo = StructureSaveHandler.structureInfoFromResource(resourceLocation);
        return structureInfo != null && StructureRegistry.registerStructure(structureInfo, key, resourceLocation.func_110624_b(), generates);
    }

    public static boolean hasStructure(String key) {
        return allStructures.containsKey((Object)key);
    }

    public static StructureInfo getStructure(String key) {
        return (StructureInfo)allStructures.get((Object)key);
    }

    @Deprecated
    public static String getName(StructureInfo structureInfo) {
        return StructureRegistry.structureID(structureInfo);
    }

    public static String structureID(StructureInfo structureInfo) {
        return (String)allStructures.inverse().get((Object)structureInfo);
    }

    public static void removeStructure(String key) {
        StructureInfo info = (StructureInfo)allStructures.remove((Object)key);
        persistentlyDisabledStructures.remove(key);
        if (info != null) {
            generatingStructures.remove(info);
        }
        StructureRegistry.clearCaches();
    }

    public static GenericStructureInfo createStructureFromJSON(String jsonData) throws JsonSyntaxException {
        return (GenericStructureInfo)gson.fromJson(jsonData, GenericStructureInfo.class);
    }

    public static String createJSONFromStructure(GenericStructureInfo structureInfo) {
        return gson.toJson((Object)structureInfo, GenericStructureInfo.class);
    }

    public static Set<StructureInfo> getAllStructures() {
        return Collections.unmodifiableSet(allStructures.values());
    }

    private static void ensureGenerationCache() {
        if (needsGenerationCacheUpdate) {
            needsGenerationCacheUpdate = false;
            generatingStructures.clear();
            for (Map.Entry entry : allStructures.entrySet()) {
                StructureInfo info = (StructureInfo)entry.getValue();
                String key = (String)entry.getKey();
                if (persistentlyDisabledStructures.contains(key) || !RCConfig.shouldStructureGenerate(key, structureDomains.get(key)) || !info.areDependenciesResolved()) continue;
                generatingStructures.add(key);
            }
        }
    }

    public static Set<StructureInfo> getAllGeneratingStructures() {
        StructureRegistry.ensureGenerationCache();
        return Collections.unmodifiableSet(Maps.filterKeys(allStructures, (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                return generatingStructures.contains(input);
            }
        }).values());
    }

    public static Set<String> getAllGeneratingStructureKeys() {
        return Collections.unmodifiableSet(generatingStructures);
    }

    public static boolean isStructureGenerating(String key) {
        StructureRegistry.ensureGenerationCache();
        return generatingStructures.contains(key);
    }

    public static Map<String, StructureInfo> structureMap() {
        return Collections.unmodifiableMap(allStructures);
    }

    @Deprecated
    public static Set<String> getAllStructureNames() {
        return StructureRegistry.allStructureIDs();
    }

    public static Set<String> allStructureIDs() {
        return Collections.unmodifiableSet(allStructures.keySet());
    }

    protected static <T extends StructureGenerationInfo> Collection<Pair<StructureInfo, T>> getCachedGeneration(Class<T> clazz) {
        return cachedGeneration.get(clazz);
    }

    public static <T extends StructureGenerationInfo> Collection<Pair<StructureInfo, T>> getStructureGenerations(Class<T> clazz) {
        Collection<Pair<StructureInfo, T>> pairs = StructureRegistry.getCachedGeneration(clazz);
        if (pairs != null) {
            return pairs;
        }
        pairs = new ArrayList<Pair<StructureInfo, T>>();
        for (StructureInfo info : StructureRegistry.getAllGeneratingStructures()) {
            List<T> generationInfos = info.generationInfos(clazz);
            for (StructureGenerationInfo t : generationInfos) {
                pairs.add(Pair.of((Object)info, (Object)t));
            }
        }
        ((ArrayList)pairs).trimToSize();
        cachedGeneration.put(clazz, pairs);
        return pairs;
    }

    public static <T extends StructureGenerationInfo> Collection<Pair<StructureInfo, T>> getStructureGenerations(Class<T> clazz, Predicate<Pair<StructureInfo, T>> predicate) {
        return Collections2.filter(StructureRegistry.getStructureGenerations(clazz), predicate);
    }

    public static StructureSelector getStructureSelector(BiomeGenBase biome, WorldProvider provider) {
        ImmutablePair pair = new ImmutablePair((Object)provider.field_76574_g, (Object)biome.field_76791_y);
        StructureSelector structureSelector = structureSelectors.get(pair);
        if (structureSelector == null || !structureSelector.isValid(biome, provider)) {
            structureSelector = new StructureSelector(StructureRegistry.getAllGeneratingStructures(), biome, provider);
            structureSelectors.put((Pair<Integer, String>)pair, structureSelector);
        }
        return structureSelector;
    }

    public static Collection<Pair<StructureInfo, StructureListGenerationInfo>> getStructuresInList(final String listID, final ForgeDirection front) {
        return StructureRegistry.getStructureGenerations(StructureListGenerationInfo.class, new Predicate<Pair<StructureInfo, StructureListGenerationInfo>>(){

            public boolean apply(Pair<StructureInfo, StructureListGenerationInfo> input) {
                return listID.equals(((StructureListGenerationInfo)input.getRight()).listID) && (front == null || ((StructureInfo)input.getLeft()).isRotatable() || ((StructureListGenerationInfo)input.getRight()).front == front);
            }
        });
    }

    public static Collection<Pair<StructureInfo, MazeGenerationInfo>> getStructuresInMaze(final String mazeID) {
        return StructureRegistry.getStructureGenerations(MazeGenerationInfo.class, new Predicate<Pair<StructureInfo, MazeGenerationInfo>>(){

            public boolean apply(Pair<StructureInfo, MazeGenerationInfo> input) {
                MazeGenerationInfo info = (MazeGenerationInfo)input.getRight();
                return mazeID.equals(info.mazeID) && info.mazeComponent.isValid();
            }
        });
    }

    private static boolean chunkContains(int chunkX, int chunkZ, int x, int z) {
        return x >> 4 == chunkX && z >> 4 == chunkZ;
    }

    public static Collection<Pair<StructureInfo, StaticGenerationInfo>> getStaticStructuresAt(final int chunkX, final int chunkZ, final World world, final ChunkCoordinates spawnPos) {
        return StructureRegistry.getStructureGenerations(StaticGenerationInfo.class, new Predicate<Pair<StructureInfo, StaticGenerationInfo>>(){

            public boolean apply(@Nullable Pair<StructureInfo, StaticGenerationInfo> input) {
                StaticGenerationInfo info = (StaticGenerationInfo)input.getRight();
                return info.dimensionMatcher.apply(world.field_73011_w) && StructureRegistry.chunkContains(chunkX, chunkZ, info.getPositionX(spawnPos), info.getPositionZ(spawnPos));
            }
        });
    }

    public static SerializableStringTypeRegistry<Transformer> getTransformerRegistry() {
        return transformerRegistry;
    }

    public static SerializableStringTypeRegistry<StructureGenerationInfo> getStructureGenerationInfoRegistry() {
        return structureGenerationInfoRegistry;
    }

    private static void clearCaches() {
        structureSelectors.clear();
        cachedGeneration.clear();
        needsGenerationCacheUpdate = true;
        StructureRegistry.updateVanillaGenerations();
        for (Pair<StructureInfo, VanillaStructureGenerationInfo> pair : StructureRegistry.getStructureGenerations(VanillaStructureGenerationInfo.class)) {
            String generationID;
            String structureID = StructureRegistry.structureID((StructureInfo)pair.getLeft());
            Class<? extends GenericVillagePiece> clazz = GenericVillageCreationHandler.getPieceClass(structureID, generationID = ((VanillaStructureGenerationInfo)pair.getRight()).id());
            if (clazz == null) continue;
            MapGenStructureIO.func_143031_a(clazz, (String)("Rc:" + structureID + "_" + generationID));
        }
    }

    private static void updateVanillaGenerations() {
        TemporaryVillagerRegistry.instance().setHandlers(Sets.newHashSet((Iterable)Iterables.filter((Iterable)Collections2.transform(StructureRegistry.getStructureGenerations(VanillaStructureGenerationInfo.class), (Function)new Function<Pair<StructureInfo, VanillaStructureGenerationInfo>, VillagerRegistry.IVillageCreationHandler>(){

            @Nullable
            public VillagerRegistry.IVillageCreationHandler apply(@Nullable Pair<StructureInfo, VanillaStructureGenerationInfo> input) {
                return GenericVillageCreationHandler.forGeneration(StructureRegistry.structureID((StructureInfo)input.getLeft()), ((VanillaStructureGenerationInfo)input.getRight()).id());
            }
        }), (Predicate)Predicates.notNull())));
    }
}

