/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.reccomplex.structures.StructureInfo;
import ivorius.reccomplex.structures.StructureInfos;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class StructureSpawnContext {
    @Nonnull
    public final World world;
    @Nonnull
    public final Random random;
    @Nonnull
    public final AxisAlignedTransform2D transform;
    @Nonnull
    public final StructureBoundingBox boundingBox;
    @Nullable
    public final StructureBoundingBox generationBB;
    public final int generationLayer;
    public final boolean generateAsSource;
    public final boolean isFirstTime;

    public StructureSpawnContext(@Nonnull World world, @Nonnull Random random, @Nonnull StructureBoundingBox boundingBox, int generationLayer, boolean generateAsSource, @Nonnull AxisAlignedTransform2D transform) {
        this.world = world;
        this.random = random;
        this.transform = transform;
        this.boundingBox = boundingBox;
        this.generationBB = null;
        this.generationLayer = generationLayer;
        this.generateAsSource = generateAsSource;
        this.isFirstTime = true;
    }

    public StructureSpawnContext(@Nonnull World world, @Nonnull Random random, @Nonnull StructureBoundingBox boundingBox, StructureBoundingBox generationBB, int generationLayer, boolean generateAsSource, @Nonnull AxisAlignedTransform2D transform, boolean isFirstTime) {
        this.world = world;
        this.random = random;
        this.transform = transform;
        this.boundingBox = boundingBox;
        this.generationBB = generationBB;
        this.generationLayer = generationLayer;
        this.generateAsSource = generateAsSource;
        this.isFirstTime = isFirstTime;
    }

    public StructureSpawnContext(@Nonnull World world, @Nonnull Random random, BlockCoord coord, @Nonnull AxisAlignedTransform2D transform, int generationLayer, boolean generateAsSource, StructureInfo structureInfo) {
        this.world = world;
        this.random = random;
        this.boundingBox = StructureInfos.structureBoundingBox(coord, StructureInfos.structureSize(structureInfo, transform));
        this.generationBB = null;
        this.transform = transform;
        this.generationLayer = generationLayer;
        this.generateAsSource = generateAsSource;
        this.isFirstTime = true;
    }

    public boolean includes(BlockCoord coord) {
        return this.generationBB == null || this.generationBB.func_78890_b(coord.x, coord.y, coord.z);
    }

    public boolean includes(int x, int y, int z) {
        return this.generationBB == null || this.generationBB.func_78890_b(x, y, z);
    }

    public boolean includes(double x, double y, double z) {
        return this.generationBB == null || this.generationBB.func_78890_b(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
    }

    public int[] boundingBoxSize() {
        return new int[]{this.boundingBox.func_78883_b(), this.boundingBox.func_78882_c(), this.boundingBox.func_78880_d()};
    }

    public BlockCoord lowerCoord() {
        return new BlockCoord(this.boundingBox.field_78897_a, this.boundingBox.field_78895_b, this.boundingBox.field_78896_c);
    }

    public boolean setBlock(BlockCoord coord, Block block, int meta) {
        if (this.includes(coord.x, coord.y, coord.z)) {
            this.world.func_147465_d(coord.x, coord.y, coord.z, block, meta, 2);
            return true;
        }
        return false;
    }

    public boolean setBlock(int x, int y, int z, Block block, int meta) {
        if (this.includes(x, y, z)) {
            this.world.func_147465_d(x, y, z, block, meta, 2);
            return true;
        }
        return false;
    }
}

