/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.structures.generic.matchers.BiomeMatcher;
import java.lang.reflect.Type;
import java.util.regex.Matcher;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeGenerationInfo {
    private BiomeMatcher biomeMatcher;
    private Double generationWeight;

    public BiomeGenerationInfo(String expression, Double generationWeight) {
        this.biomeMatcher = new BiomeMatcher(expression);
        this.generationWeight = generationWeight;
    }

    public Double getGenerationWeight() {
        return this.generationWeight;
    }

    public void setGenerationWeight(Double generationWeight) {
        this.generationWeight = generationWeight;
    }

    public double getActiveGenerationWeight() {
        return this.generationWeight != null ? this.generationWeight : 1.0;
    }

    public boolean hasDefaultWeight() {
        return this.generationWeight == null;
    }

    public boolean matches(BiomeGenBase biome) {
        return this.biomeMatcher.apply(biome);
    }

    public BiomeMatcher getBiomeMatcher() {
        return this.biomeMatcher;
    }

    public String getDisplayString() {
        return this.biomeMatcher.getDisplayString();
    }

    public static class Serializer
    implements JsonDeserializer<BiomeGenerationInfo>,
    JsonSerializer<BiomeGenerationInfo> {
        public BiomeGenerationInfo deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            String expression;
            JsonObject jsonobject = JsonUtils.getJsonElementAsJsonObject(jsonElement, "generationInfo");
            if (jsonobject.has("biome")) {
                expression = JsonUtils.getJsonObjectStringFieldValue(jsonobject, "biome");
                if (expression.startsWith("Type:")) {
                    expression = "$" + expression.substring(5).replaceAll(",", Matcher.quoteReplacement(" & $"));
                }
            } else {
                expression = JsonUtils.getJsonObjectStringFieldValue(jsonobject, "biomes");
            }
            Double weight = jsonobject.has("weight") ? Double.valueOf(JsonUtils.getJsonObjectDoubleFieldValue(jsonobject, "weight")) : null;
            return new BiomeGenerationInfo(expression, weight);
        }

        public JsonElement serialize(BiomeGenerationInfo generationInfo, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("biomes", generationInfo.getBiomeMatcher().getExpression());
            if (generationInfo.generationWeight != null) {
                jsonobject.addProperty("weight", (Number)generationInfo.generationWeight);
            }
            return jsonobject;
        }
    }
}

