/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.ivtoolkit.tools.NBTTagLists;
import ivorius.ivtoolkit.tools.Pairs;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.blocks.GeneratingTileEntity;
import ivorius.reccomplex.blocks.RCBlocks;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.json.NbtToJson;
import ivorius.reccomplex.structures.MCRegistrySpecial;
import ivorius.reccomplex.structures.StructureInfo;
import ivorius.reccomplex.structures.StructureLoadContext;
import ivorius.reccomplex.structures.StructurePrepareContext;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.StructureSpawnContext;
import ivorius.reccomplex.structures.generic.Metadata;
import ivorius.reccomplex.structures.generic.WeightedBlockState;
import ivorius.reccomplex.structures.generic.gentypes.MazeGenerationInfo;
import ivorius.reccomplex.structures.generic.gentypes.NaturalGenerationInfo;
import ivorius.reccomplex.structures.generic.gentypes.StructureGenerationInfo;
import ivorius.reccomplex.structures.generic.matchers.BlockMatcher;
import ivorius.reccomplex.structures.generic.matchers.DependencyMatcher;
import ivorius.reccomplex.structures.generic.transformers.Transformer;
import ivorius.reccomplex.structures.generic.transformers.TransformerNatural;
import ivorius.reccomplex.structures.generic.transformers.TransformerNaturalAir;
import ivorius.reccomplex.structures.generic.transformers.TransformerNegativeSpace;
import ivorius.reccomplex.structures.generic.transformers.TransformerReplace;
import ivorius.reccomplex.utils.NBTStorable;
import ivorius.reccomplex.utils.RCAccessorEntity;
import ivorius.reccomplex.utils.RCAccessorWorldServer;
import ivorius.reccomplex.worldgen.inventory.InventoryGenerationHandler;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class GenericStructureInfo
implements StructureInfo<InstanceData>,
Cloneable {
    public static final int LATEST_VERSION = 3;
    public static final int MAX_GENERATING_LAYERS = 30;
    public final List<StructureGenerationInfo> generationInfos = new ArrayList<StructureGenerationInfo>();
    public final List<Transformer> transformers = new ArrayList<Transformer>();
    public final DependencyMatcher dependencies = new DependencyMatcher("");
    public NBTTagCompound worldDataCompound;
    public boolean rotatable;
    public boolean mirrorable;
    public Metadata metadata = new Metadata();
    public JsonObject customData;

    public static GenericStructureInfo createDefaultStructure() {
        GenericStructureInfo genericStructureInfo = new GenericStructureInfo();
        genericStructureInfo.rotatable = false;
        genericStructureInfo.mirrorable = false;
        genericStructureInfo.transformers.add(new TransformerNaturalAir(BlockMatcher.of((MCRegistry)MCRegistrySpecial.INSTANCE, RCBlocks.negativeSpace, 1), 4.0, 10.0));
        genericStructureInfo.transformers.add(new TransformerNegativeSpace(BlockMatcher.of((MCRegistry)MCRegistrySpecial.INSTANCE, RCBlocks.negativeSpace, 0)));
        genericStructureInfo.transformers.add(new TransformerNatural(BlockMatcher.of((MCRegistry)MCRegistrySpecial.INSTANCE, RCBlocks.naturalFloor, 0), 4.0, 6.0));
        genericStructureInfo.transformers.add(new TransformerReplace(BlockMatcher.of((MCRegistry)MCRegistrySpecial.INSTANCE, RCBlocks.naturalFloor, 1)).replaceWith(new WeightedBlockState(null, Blocks.field_150350_a, 0, "")));
        genericStructureInfo.generationInfos.add(new NaturalGenerationInfo());
        return genericStructureInfo;
    }

    private static boolean isBiomeAllTypes(BiomeGenBase biomeGenBase, List<BiomeDictionary.Type> types) {
        for (BiomeDictionary.Type type : types) {
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomeGenBase, (BiomeDictionary.Type)type)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int[] structureBoundingBox() {
        if (this.worldDataCompound == null) {
            return new int[]{0, 0, 0};
        }
        NBTTagCompound compound = this.worldDataCompound.func_74775_l("blockCollection");
        return new int[]{compound.func_74762_e("width"), compound.func_74762_e("height"), compound.func_74762_e("length")};
    }

    @Override
    public boolean isRotatable() {
        return this.rotatable;
    }

    @Override
    public boolean isMirrorable() {
        return this.mirrorable;
    }

    @Override
    public void generate(StructureSpawnContext context, InstanceData instanceData) {
        NBTStorable transformerData;
        Transformer transformer;
        World world = context.world;
        Random random = context.random;
        IvWorldData worldData = this.constructWorldData(world);
        if (world instanceof WorldServer) {
            RCAccessorWorldServer.ensureBlockEventArray((WorldServer)world);
        }
        IvBlockCollection blockCollection = worldData.blockCollection;
        int[] areaSize = new int[]{blockCollection.width, blockCollection.height, blockCollection.length};
        BlockCoord origin = context.lowerCoord();
        HashMap<BlockCoord, TileEntity> tileEntities = new HashMap<BlockCoord, TileEntity>();
        for (TileEntity tileEntity : worldData.tileEntities) {
            BlockCoord blockCoord = new BlockCoord(tileEntity);
            tileEntities.put(blockCoord, tileEntity);
            IvWorldData.setTileEntityPosForGeneration((TileEntity)tileEntity, (BlockCoord)context.transform.apply(blockCoord, areaSize).add(origin));
        }
        List transformers = Pairs.of(this.transformers, instanceData.transformers);
        if (!context.generateAsSource) {
            for (Pair pair : transformers) {
                transformer = (Transformer)pair.getLeft();
                if (!transformer.generatesInPhase(transformerData = (NBTStorable)pair.getRight(), Transformer.Phase.BEFORE)) continue;
                transformer.transform(transformerData, Transformer.Phase.BEFORE, context, worldData, transformers);
            }
        }
        for (int pass = 0; pass < 2; ++pass) {
            for (BlockCoord sourceCoord : blockCollection) {
                Block block = blockCollection.getBlock(sourceCoord);
                byte meta = blockCollection.getMetadata(sourceCoord);
                BlockCoord worldPos = context.transform.apply(sourceCoord, areaSize).add(origin);
                if (!context.includes(worldPos) || !MCRegistrySpecial.INSTANCE.isSafe(block)) continue;
                TileEntity tileEntity = (TileEntity)tileEntities.get(sourceCoord);
                if (pass != this.getPass(block, meta) || !context.generateAsSource && this.skips(transformers, block, meta)) continue;
                if (context.generateAsSource || !(tileEntity instanceof GeneratingTileEntity) || ((GeneratingTileEntity)tileEntity).shouldPlaceInWorld(context, instanceData.tileEntities.get(sourceCoord))) {
                    if (!context.setBlock(worldPos, block, meta)) continue;
                    if (tileEntity != null && MCRegistrySpecial.INSTANCE.isSafe(tileEntity)) {
                        world.func_72921_c(worldPos.x, worldPos.y, worldPos.z, (int)meta, 2);
                        world.func_147455_a(worldPos.x, worldPos.y, worldPos.z, tileEntity);
                        tileEntity.func_145836_u();
                        if (!context.generateAsSource && tileEntity instanceof IInventory) {
                            IInventory inventory = (IInventory)tileEntity;
                            InventoryGenerationHandler.generateAllTags(inventory, MCRegistrySpecial.INSTANCE.itemHidingMode(), random);
                        }
                    }
                    context.transform.rotateBlock(world, worldPos, block);
                    continue;
                }
                context.setBlock(worldPos, Blocks.field_150350_a, 0);
            }
        }
        if (!context.generateAsSource) {
            for (Pair pair : transformers) {
                transformer = (Transformer)pair.getLeft();
                if (!transformer.generatesInPhase(transformerData = (NBTStorable)pair.getRight(), Transformer.Phase.AFTER)) continue;
                transformer.transform(transformerData, Transformer.Phase.AFTER, context, worldData, transformers);
            }
        }
        for (Entity entity : worldData.entities) {
            IvWorldData.transformEntityPosForGeneration((Entity)entity, (AxisAlignedTransform2D)context.transform, (int[])areaSize);
            IvWorldData.moveEntityForGeneration((Entity)entity, (BlockCoord)origin);
            if (!context.includes(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)) continue;
            RCAccessorEntity.setEntityUniqueID(entity, UUID.randomUUID());
            world.func_72838_d(entity);
        }
        if (!context.generateAsSource && context.generationLayer < 30) {
            for (Map.Entry entry : tileEntities.entrySet()) {
                if (!(entry.getValue() instanceof GeneratingTileEntity)) continue;
                ((GeneratingTileEntity)entry.getValue()).generate(context, instanceData.tileEntities.get(entry.getKey()));
            }
        } else {
            RecurrentComplex.logger.warn("Structure generated with over 30 layers; most likely infinite loop!");
        }
    }

    @Override
    public InstanceData prepareInstanceData(StructurePrepareContext context) {
        InstanceData instanceData = new InstanceData();
        if (!context.generateAsSource) {
            IvWorldData worldData = this.constructWorldData(null);
            IvBlockCollection blockCollection = worldData.blockCollection;
            int[] areaSize = new int[]{blockCollection.width, blockCollection.height, blockCollection.length};
            BlockCoord origin = context.lowerCoord();
            for (Transformer transformer : this.transformers) {
                instanceData.transformers.add((NBTStorable)transformer.prepareInstanceData(context));
            }
            for (TileEntity tileEntity : worldData.tileEntities) {
                if (!(tileEntity instanceof GeneratingTileEntity)) continue;
                BlockCoord key = new BlockCoord(tileEntity);
                IvWorldData.setTileEntityPosForGeneration((TileEntity)tileEntity, (BlockCoord)context.transform.apply(key, areaSize).add(origin));
                instanceData.tileEntities.put(key, (NBTStorable)((GeneratingTileEntity)tileEntity).prepareInstanceData(context));
            }
        }
        return instanceData;
    }

    @Override
    public InstanceData loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        InstanceData instanceData = new InstanceData();
        instanceData.readFromNBT(context, nbt, this.transformers, this.constructWorldData(null));
        return instanceData;
    }

    private boolean skips(List<Pair<Transformer, NBTStorable>> transformers, final Block block, final int metadata) {
        return Iterables.any(transformers, (Predicate)new Predicate<Pair<Transformer, NBTStorable>>(){

            public boolean apply(@Nullable Pair<Transformer, NBTStorable> input) {
                return ((Transformer)input.getLeft()).skipGeneration((NBTStorable)input.getRight(), block, metadata);
            }
        });
    }

    public IvWorldData constructWorldData(World world) {
        return new IvWorldData(this.worldDataCompound, world, (MCRegistry)MCRegistrySpecial.INSTANCE.itemHidingMode());
    }

    @Override
    public <I extends StructureGenerationInfo> List<I> generationInfos(Class<I> clazz) {
        ArrayList<StructureGenerationInfo> list = new ArrayList<StructureGenerationInfo>();
        for (StructureGenerationInfo info : this.generationInfos) {
            if (!clazz.isAssignableFrom(info.getClass())) continue;
            list.add(info);
        }
        return list;
    }

    @Override
    public StructureGenerationInfo generationInfo(String id) {
        for (StructureGenerationInfo info : this.generationInfos) {
            if (!Objects.equals(info.id(), id)) continue;
            return info;
        }
        return null;
    }

    private int getPass(Block block, int metadata) {
        return block.func_149721_r() || block.func_149688_o() == Material.field_151579_a ? 0 : 1;
    }

    @Override
    public GenericStructureInfo copyAsGenericStructureInfo() {
        return (GenericStructureInfo)this.clone();
    }

    @Override
    public boolean areDependenciesResolved() {
        return this.dependencies.apply();
    }

    public Object clone() {
        GenericStructureInfo genericStructureInfo = StructureRegistry.createStructureFromJSON(StructureRegistry.createJSONFromStructure(this));
        genericStructureInfo.worldDataCompound = (NBTTagCompound)this.worldDataCompound.func_74737_b();
        return genericStructureInfo;
    }

    public static class InstanceData
    implements NBTStorable {
        public static final String KEY_TRANSFORMERS = "transformers";
        public static final String KEY_TILE_ENTITIES = "tileEntities";
        public final List<NBTStorable> transformers = new ArrayList<NBTStorable>();
        public final Map<BlockCoord, NBTStorable> tileEntities = new HashMap<BlockCoord, NBTStorable>();

        protected static NBTBase getTileEntityTag(NBTTagCompound tileEntityCompound, BlockCoord coord) {
            return tileEntityCompound.func_74781_a(InstanceData.getTileEntityKey(coord));
        }

        private static String getTileEntityKey(BlockCoord coord) {
            return String.format("%d,%d,%d", coord.x, coord.y, coord.z);
        }

        public void readFromNBT(StructureLoadContext context, NBTBase nbt, List<Transformer> transformers, IvWorldData worldData) {
            IvBlockCollection blockCollection = worldData.blockCollection;
            NBTTagCompound compound = nbt instanceof NBTTagCompound ? (NBTTagCompound)nbt : new NBTTagCompound();
            List transformerCompounds = NBTTagLists.compoundsFrom((NBTTagCompound)compound, (String)KEY_TRANSFORMERS);
            for (int i = 0; i < transformerCompounds.size(); ++i) {
                NBTTagCompound transformerCompound = (NBTTagCompound)transformerCompounds.get(i);
                this.transformers.add((NBTStorable)transformers.get(i).loadInstanceData(context, transformerCompound.func_74781_a("data")));
            }
            int[] areaSize = new int[]{blockCollection.width, blockCollection.height, blockCollection.length};
            BlockCoord origin = context.lowerCoord();
            NBTTagCompound tileEntityCompound = compound.func_74775_l(KEY_TILE_ENTITIES);
            for (TileEntity tileEntity : worldData.tileEntities) {
                if (!(tileEntity instanceof GeneratingTileEntity)) continue;
                BlockCoord key = new BlockCoord(tileEntity);
                IvWorldData.setTileEntityPosForGeneration((TileEntity)tileEntity, (BlockCoord)context.transform.apply(key, areaSize).add(origin));
                this.tileEntities.put(key, (NBTStorable)((GeneratingTileEntity)tileEntity).loadInstanceData(context, InstanceData.getTileEntityTag(tileEntityCompound, key)));
            }
        }

        @Override
        public NBTBase writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            NBTTagList transformerDatas = new NBTTagList();
            for (NBTStorable transformerData : this.transformers) {
                NBTTagCompound transformerCompound = new NBTTagCompound();
                transformerCompound.func_74782_a("data", transformerData.writeToNBT());
                transformerDatas.func_74742_a((NBTBase)transformerCompound);
            }
            compound.func_74782_a(KEY_TRANSFORMERS, (NBTBase)transformerDatas);
            NBTTagCompound tileEntityCompound = new NBTTagCompound();
            for (Map.Entry<BlockCoord, NBTStorable> entry : this.tileEntities.entrySet()) {
                tileEntityCompound.func_74782_a(InstanceData.getTileEntityKey(entry.getKey()), entry.getValue().writeToNBT());
            }
            compound.func_74782_a(KEY_TILE_ENTITIES, (NBTBase)tileEntityCompound);
            return compound;
        }
    }

    public static class Serializer
    implements JsonDeserializer<GenericStructureInfo>,
    JsonSerializer<GenericStructureInfo> {
        public GenericStructureInfo deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            Integer version;
            JsonObject jsonobject = JsonUtils.getJsonElementAsJsonObject(jsonElement, "status");
            GenericStructureInfo structureInfo = new GenericStructureInfo();
            if (jsonobject.has("version")) {
                version = JsonUtils.getJsonObjectIntegerFieldValue(jsonobject, "version");
            } else {
                version = 3;
                RecurrentComplex.logger.warn("Structure JSON missing 'version', using latest (3)");
            }
            if (jsonobject.has("generationInfos")) {
                Collections.addAll(structureInfo.generationInfos, (Object[])context.deserialize(jsonobject.get("generationInfos"), StructureGenerationInfo[].class));
            }
            if (version == 1) {
                structureInfo.generationInfos.add(NaturalGenerationInfo.deserializeFromVersion1(jsonobject, context));
            }
            if (jsonobject.has("naturalGenerationInfo")) {
                structureInfo.generationInfos.add((StructureGenerationInfo)NaturalGenerationInfo.getGson().fromJson(jsonobject.get("naturalGenerationInfo"), NaturalGenerationInfo.class));
            }
            if (jsonobject.has("mazeGenerationInfo")) {
                structureInfo.generationInfos.add((StructureGenerationInfo)MazeGenerationInfo.getGson().fromJson(jsonobject.get("mazeGenerationInfo"), MazeGenerationInfo.class));
            }
            if (jsonobject.has("transformers")) {
                Collections.addAll(structureInfo.transformers, (Object[])context.deserialize(jsonobject.get("transformers"), Transformer[].class));
            }
            if (jsonobject.has("blockTransformers")) {
                Collections.addAll(structureInfo.transformers, (Object[])context.deserialize(jsonobject.get("blockTransformers"), Transformer[].class));
            }
            structureInfo.rotatable = JsonUtils.getJsonObjectBooleanFieldValueOrDefault(jsonobject, "rotatable", false);
            structureInfo.mirrorable = JsonUtils.getJsonObjectBooleanFieldValueOrDefault(jsonobject, "mirrorable", false);
            if (jsonobject.has("dependencyExpression")) {
                structureInfo.dependencies.setExpression(JsonUtils.getJsonObjectStringFieldValue(jsonobject, "dependencyExpression"));
            } else if (jsonobject.has("dependencies")) {
                structureInfo.dependencies.setExpression(DependencyMatcher.ofMods((String[])context.deserialize(jsonobject.get("dependencies"), String[].class)));
            }
            if (jsonobject.has("worldData")) {
                structureInfo.worldDataCompound = (NBTTagCompound)context.deserialize(jsonobject.get("worldData"), NBTTagCompound.class);
            } else if (jsonobject.has("worldDataBase64")) {
                structureInfo.worldDataCompound = NbtToJson.getNBTFromBase64(JsonUtils.getJsonObjectStringFieldValue(jsonobject, "worldDataBase64"));
            }
            if (jsonobject.has("metadata")) {
                structureInfo.metadata = (Metadata)context.deserialize(jsonobject.get("metadata"), Metadata.class);
            }
            structureInfo.customData = JsonUtils.getJsonObjectFieldOrDefault(jsonobject, "customData", new JsonObject());
            return structureInfo;
        }

        public JsonElement serialize(GenericStructureInfo structureInfo, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("version", (Number)3);
            jsonobject.add("generationInfos", context.serialize(structureInfo.generationInfos));
            jsonobject.add("transformers", context.serialize(structureInfo.transformers));
            jsonobject.addProperty("rotatable", Boolean.valueOf(structureInfo.rotatable));
            jsonobject.addProperty("mirrorable", Boolean.valueOf(structureInfo.mirrorable));
            jsonobject.add("dependencyExpression", context.serialize((Object)structureInfo.dependencies.getExpression()));
            jsonobject.add("metadata", context.serialize((Object)structureInfo.metadata));
            jsonobject.add("customData", (JsonElement)structureInfo.customData);
            return jsonobject;
        }
    }
}

