/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic;

import ivorius.ivtoolkit.tools.IvFileHelper;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.files.FileSuffixFilter;
import ivorius.reccomplex.files.RCFileHelper;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.generic.GenericStructureInfo;
import ivorius.reccomplex.structures.generic.StructureInvalidZipException;
import ivorius.reccomplex.structures.generic.StructureLoadException;
import ivorius.reccomplex.structures.schematics.SchematicLoader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;

public class StructureSaveHandler {
    public static final String FILE_SUFFIX = "rcst";
    public static final String STRUCTURE_INFO_JSON_FILENAME = "structure.json";
    public static final String WORLD_DATA_NBT_FILENAME = "worldData.nbt";
    public static final String ACTIVE_DIR_NAME = "active";
    public static final String INACTIVE_DIR_NAME = "inactive";
    private static List<String> importedGenerators = new ArrayList<String>();

    public static String getStructuresDirectoryName(boolean activeFolder) {
        return activeFolder ? ACTIVE_DIR_NAME : INACTIVE_DIR_NAME;
    }

    public static File getStructuresDirectory(boolean activeFolder) {
        File structuresFolder = RecurrentComplex.proxy.getBaseFolderFile("structures");
        return RCFileHelper.getValidatedFolder(structuresFolder, StructureSaveHandler.getStructuresDirectoryName(activeFolder), true);
    }

    public static void reloadAllCustomStructures() {
        while (!importedGenerators.isEmpty()) {
            StructureRegistry.removeStructure(importedGenerators.remove(0));
        }
        File structuresFile = IvFileHelper.getValidatedFolder((File)RecurrentComplex.proxy.getBaseFolderFile("structures"));
        if (structuresFile != null) {
            StructureSaveHandler.tryAddAllStructuresInDirectory(RCFileHelper.getValidatedFolder(structuresFile, ACTIVE_DIR_NAME, true), "", true, true);
            StructureSaveHandler.tryAddAllStructuresInDirectory(RCFileHelper.getValidatedFolder(structuresFile, INACTIVE_DIR_NAME, true), "", false, true);
            StructureSaveHandler.tryAddAllStructuresInDirectory(RCFileHelper.getValidatedFolder(structuresFile, "genericStructures", false), "", true, true);
            StructureSaveHandler.tryAddAllStructuresInDirectory(RCFileHelper.getValidatedFolder(structuresFile, "silentStructures", false), "", false, true);
        }
        SchematicLoader.initializeFolder();
    }

    public static void loadStructuresFromMod(String modid) {
        modid = modid.toLowerCase();
        StructureSaveHandler.tryAddAllStructuresInResourceLocation(new ResourceLocation(modid, "structures/active"), true, false);
        StructureSaveHandler.tryAddAllStructuresInResourceLocation(new ResourceLocation(modid, "structures/inactive"), false, false);
        StructureSaveHandler.tryAddAllStructuresInResourceLocation(new ResourceLocation(modid, "structures/genericStructures"), true, false);
        StructureSaveHandler.tryAddAllStructuresInResourceLocation(new ResourceLocation(modid, "structures/silentStructures"), false, false);
    }

    public static int tryAddAllStructuresInResourceLocation(ResourceLocation resourceLocation, boolean generating, boolean imported) {
        try {
            Path path = RCFileHelper.pathFromResourceLocation(resourceLocation);
            if (path != null) {
                return StructureSaveHandler.addAllStructuresInDirectory(path, resourceLocation.func_110624_b(), generating, imported);
            }
        }
        catch (Throwable e) {
            RecurrentComplex.logger.error("Error reading from resource location '" + resourceLocation + "'", e);
        }
        return 0;
    }

    public static int tryAddAllStructuresInDirectory(File file, String domain, boolean generating, boolean imported) {
        if (file != null) {
            try {
                return StructureSaveHandler.addAllStructuresInDirectory(file.toPath(), domain, generating, imported);
            }
            catch (Throwable e) {
                RecurrentComplex.logger.error("Error reading from directory '" + file + "'", e);
            }
        }
        return 0;
    }

    public static int addAllStructuresInDirectory(Path directory, String domain, boolean generating, boolean imported) throws IOException {
        List<Path> paths = RCFileHelper.listFilesRecursively(directory, new FileSuffixFilter(FILE_SUFFIX, "zip"), true);
        int added = 0;
        for (Path file : paths) {
            try {
                String structureID;
                GenericStructureInfo genericStructureInfo = StructureSaveHandler.readGenericStructure(file);
                if (!StructureRegistry.registerStructure(genericStructureInfo, structureID = FilenameUtils.getBaseName((String)file.getFileName().toString()), domain, generating)) continue;
                if (imported) {
                    importedGenerators.add(structureID);
                }
                ++added;
            }
            catch (StructureLoadException | IOException e) {
                e.printStackTrace();
            }
        }
        return added;
    }

    public static boolean saveGenericStructure(GenericStructureInfo info, String structureName, boolean activeFolder) {
        File parent = StructureSaveHandler.getStructuresDirectory(activeFolder);
        if (parent != null) {
            String json = StructureRegistry.createJSONFromStructure(info);
            File newFile = new File(parent, structureName + "." + FILE_SUFFIX);
            boolean failed = false;
            try {
                ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(newFile));
                ZipEntry jsonEntry = new ZipEntry(STRUCTURE_INFO_JSON_FILENAME);
                zipOutputStream.putNextEntry(jsonEntry);
                byte[] jsonBytes = json.getBytes();
                jsonEntry.setSize(jsonBytes.length);
                zipOutputStream.write(jsonBytes);
                zipOutputStream.closeEntry();
                ZipEntry worldDataEntry = new ZipEntry(WORLD_DATA_NBT_FILENAME);
                zipOutputStream.putNextEntry(worldDataEntry);
                byte[] worldDataBytes = CompressedStreamTools.func_74798_a((NBTTagCompound)info.worldDataCompound);
                worldDataEntry.setSize(worldDataBytes.length);
                zipOutputStream.write(worldDataBytes);
                zipOutputStream.closeEntry();
                zipOutputStream.close();
            }
            catch (Exception ex) {
                RecurrentComplex.logger.error("Could not write structure to zip file", (Throwable)ex);
                failed = true;
            }
            return !failed && newFile.exists();
        }
        return false;
    }

    public static boolean hasGenericStructure(String structureName, boolean activeFolder) {
        try {
            File parent = StructureSaveHandler.getStructuresDirectory(activeFolder);
            return parent != null && (new File(parent, structureName + "." + FILE_SUFFIX).exists() || new File(parent, structureName + ".zip").exists());
        }
        catch (Throwable e) {
            RecurrentComplex.logger.error("Error when looking up structure", e);
            return false;
        }
    }

    public static boolean deleteGenericStructure(String structureName, boolean activeFolder) {
        try {
            File parent = StructureSaveHandler.getStructuresDirectory(activeFolder);
            return parent != null && (new File(parent, structureName + "." + FILE_SUFFIX).delete() || new File(parent, structureName + ".zip").delete());
        }
        catch (Throwable e) {
            RecurrentComplex.logger.error("Error when deleting structure", e);
            return false;
        }
    }

    public static GenericStructureInfo readGenericStructure(Path file) throws StructureLoadException, IOException {
        try (ZipInputStream zip = new ZipInputStream(Files.newInputStream(file, new OpenOption[0]));){
            GenericStructureInfo genericStructureInfo = StructureSaveHandler.structureInfoFromZip(zip);
            return genericStructureInfo;
        }
    }

    public static GenericStructureInfo structureInfoFromResource(ResourceLocation resourceLocation) {
        try {
            return StructureSaveHandler.structureInfoFromZip(new ZipInputStream(IvFileHelper.inputStreamFromResourceLocation((ResourceLocation)resourceLocation)));
        }
        catch (Exception ex) {
            RecurrentComplex.logger.error("Could not read generic structure " + resourceLocation.toString(), (Throwable)ex);
            return null;
        }
    }

    public static GenericStructureInfo structureInfoFromZip(ZipInputStream zipInputStream) throws StructureLoadException {
        try {
            ZipEntry zipEntry;
            String json = null;
            NBTTagCompound worldData = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                byte[] bytes = StructureSaveHandler.completeByteArray(zipInputStream);
                if (bytes != null) {
                    if (STRUCTURE_INFO_JSON_FILENAME.equals(zipEntry.getName())) {
                        json = new String(bytes);
                    } else if (WORLD_DATA_NBT_FILENAME.equals(zipEntry.getName())) {
                        worldData = CompressedStreamTools.func_152457_a((byte[])bytes, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
                    }
                }
                zipInputStream.closeEntry();
            }
            zipInputStream.close();
            if (json == null || worldData == null) {
                throw new StructureInvalidZipException(json != null, worldData != null);
            }
            GenericStructureInfo genericStructureInfo = StructureRegistry.createStructureFromJSON(json);
            genericStructureInfo.worldDataCompound = worldData;
            return genericStructureInfo;
        }
        catch (IOException e) {
            throw new StructureLoadException(e);
        }
    }

    public static byte[] completeByteArray(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int aByte;
            while ((aByte = inputStream.read()) >= 0) {
                byteArrayOutputStream.write(aByte);
            }
        }
        catch (Exception ignored) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }
}

