/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.gentypes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.reccomplex.gui.editstructure.gentypes.TableDataSourceStaticGenerationInfo;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.structures.generic.GenericYSelector;
import ivorius.reccomplex.structures.generic.gentypes.StructureGenerationInfo;
import ivorius.reccomplex.structures.generic.matchers.DimensionMatcher;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StatCollector;

public class StaticGenerationInfo
extends StructureGenerationInfo {
    private static Gson gson = StaticGenerationInfo.createGson();
    public String id = "";
    public GenericYSelector ySelector;
    public DimensionMatcher dimensionMatcher;
    public boolean relativeToSpawn;
    public int positionX;
    public int positionZ;

    public StaticGenerationInfo() {
        this("StaticGen1", new GenericYSelector(GenericYSelector.SelectionMode.SURFACE, 0, 0), new DimensionMatcher("0"), true, 0, 0);
    }

    public StaticGenerationInfo(String id, GenericYSelector ySelector, DimensionMatcher dimensionMatcher, boolean relativeToSpawn, int positionX, int positionZ) {
        this.id = id;
        this.ySelector = ySelector;
        this.dimensionMatcher = dimensionMatcher;
        this.relativeToSpawn = relativeToSpawn;
        this.positionX = positionX;
        this.positionZ = positionZ;
    }

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(StaticGenerationInfo.class, (Object)new Serializer());
        builder.registerTypeAdapter(GenericYSelector.class, (Object)new GenericYSelector.Serializer());
        return builder.create();
    }

    public static Gson getGson() {
        return gson;
    }

    @Override
    @Nonnull
    public String id() {
        return this.id;
    }

    @Override
    public void setID(@Nonnull String id) {
        this.id = id;
    }

    @Override
    public String displayString() {
        if (this.relativeToSpawn) {
            return StatCollector.func_74837_a((String)"reccomplex.generationInfo.static.spawn", (Object[])new Object[]{String.valueOf(this.positionX), String.valueOf(this.positionZ)});
        }
        return StatCollector.func_74837_a((String)"reccomplex.generationInfo.static.nospawn", (Object[])new Object[]{String.valueOf(this.positionX), String.valueOf(this.positionZ)});
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceStaticGenerationInfo(navigator, delegate, this);
    }

    public int getPositionX(ChunkCoordinates spawnPos) {
        return this.relativeToSpawn ? spawnPos.field_71574_a + this.positionX : this.positionX;
    }

    public int getPositionZ(ChunkCoordinates spawnPos) {
        return this.relativeToSpawn ? spawnPos.field_71573_c + this.positionZ : this.positionZ;
    }

    public static class Serializer
    implements JsonSerializer<StaticGenerationInfo>,
    JsonDeserializer<StaticGenerationInfo> {
        public StaticGenerationInfo deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(json, "vanillaStructureSpawnInfo");
            String id = JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "id", "");
            GenericYSelector ySelector = (GenericYSelector)gson.fromJson(jsonObject.get("generationY"), GenericYSelector.class);
            String dimension = JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "dimensions", "");
            boolean relativeToSpawn = JsonUtils.getJsonObjectBooleanFieldValueOrDefault(jsonObject, "relativeToSpawn", false);
            int positionX = JsonUtils.getJsonObjectIntegerFieldValueOrDefault(jsonObject, "positionX", 0);
            int positionZ = JsonUtils.getJsonObjectIntegerFieldValueOrDefault(jsonObject, "positionZ", 0);
            return new StaticGenerationInfo(id, ySelector, new DimensionMatcher(dimension), relativeToSpawn, positionX, positionZ);
        }

        public JsonElement serialize(StaticGenerationInfo src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", src.id);
            jsonObject.add("generationY", gson.toJsonTree((Object)src.ySelector));
            jsonObject.addProperty("dimensions", src.dimensionMatcher.getExpression());
            jsonObject.addProperty("relativeToSpawn", Boolean.valueOf(src.relativeToSpawn));
            jsonObject.addProperty("positionX", (Number)src.positionX);
            jsonObject.addProperty("positionZ", (Number)src.positionZ);
            return jsonObject;
        }
    }
}

