/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.gentypes;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.Directions;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.gui.editstructure.gentypes.TableDataSourceVanillaStructureGenerationInfo;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.structures.generic.gentypes.StructureGenerationInfo;
import ivorius.reccomplex.structures.generic.matchers.BiomeMatcher;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class VanillaStructureGenerationInfo
extends StructureGenerationInfo {
    public String id = "";
    public Double generationWeight;
    public double minBaseLimit;
    public double maxBaseLimit;
    public double minScaledLimit;
    public double maxScaledLimit;
    public ForgeDirection front;
    public BlockCoord spawnShift;
    public BiomeMatcher biomeMatcher;

    public VanillaStructureGenerationInfo() {
        this("VanillaGen1", null, 2.0, 5.0, 3.0, 3.0, ForgeDirection.NORTH, new BlockCoord(0, 0, 0), "");
    }

    public VanillaStructureGenerationInfo(String id, Double generationWeight, double minBaseLimit, double maxBaseLimit, double minScaledLimit, double maxScaledLimit, ForgeDirection front, BlockCoord spawnShift, String biomeExpression) {
        this.id = id;
        this.generationWeight = generationWeight;
        this.minBaseLimit = minBaseLimit;
        this.maxBaseLimit = maxBaseLimit;
        this.minScaledLimit = minScaledLimit;
        this.maxScaledLimit = maxScaledLimit;
        this.front = front;
        this.spawnShift = spawnShift;
        this.biomeMatcher = new BiomeMatcher(biomeExpression);
    }

    @Override
    @Nonnull
    public String id() {
        return this.id;
    }

    @Override
    public void setID(@Nonnull String id) {
        this.id = id;
    }

    @Override
    public String displayString() {
        return StatCollector.func_74838_a((String)"reccomplex.generationInfo.vanilla.title");
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceVanillaStructureGenerationInfo(navigator, delegate, this);
    }

    public boolean generatesIn(BiomeGenBase biome) {
        return this.biomeMatcher.apply(biome);
    }

    public double getActiveWeight() {
        return this.generationWeight != null ? this.generationWeight : 1.0;
    }

    public int getVanillaWeight() {
        return MathHelper.func_76128_c((double)(this.getActiveWeight() * (double)RCConfig.baseVillageSpawnWeight + 0.5));
    }

    public static class Serializer
    implements JsonSerializer<VanillaStructureGenerationInfo>,
    JsonDeserializer<VanillaStructureGenerationInfo> {
        public VanillaStructureGenerationInfo deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(json, "vanillaStructureSpawnInfo");
            String id = JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "id", "");
            Double spawnWeight = jsonObject.has("generationWeight") ? Double.valueOf(JsonUtils.getJsonObjectDoubleFieldValue(jsonObject, "generationWeight")) : null;
            double minBaseLimit = JsonUtils.getJsonObjectDoubleFieldValueOrDefault(jsonObject, "minBaseLimit", 0.0);
            double maxBaseLimit = JsonUtils.getJsonObjectDoubleFieldValueOrDefault(jsonObject, "maxBaseLimit", 0.0);
            double minScaledLimit = JsonUtils.getJsonObjectDoubleFieldValueOrDefault(jsonObject, "minScaledLimit", 0.0);
            double maxScaledLimit = JsonUtils.getJsonObjectDoubleFieldValueOrDefault(jsonObject, "maxScaledLimit", 0.0);
            int spawnX = JsonUtils.getJsonObjectIntegerFieldValueOrDefault(jsonObject, "spawnShiftX", 0);
            int spawnY = JsonUtils.getJsonObjectIntegerFieldValueOrDefault(jsonObject, "spawnShiftY", 0);
            int spawnZ = JsonUtils.getJsonObjectIntegerFieldValueOrDefault(jsonObject, "spawnShiftZ", 0);
            ForgeDirection front = Directions.deserialize((String)JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "front", "NORTH"));
            String biomeExpression = JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "biomeExpression", "");
            return new VanillaStructureGenerationInfo(id, spawnWeight, minBaseLimit, maxBaseLimit, minScaledLimit, maxScaledLimit, front, new BlockCoord(spawnX, spawnY, spawnZ), biomeExpression);
        }

        public JsonElement serialize(VanillaStructureGenerationInfo src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", src.id);
            if (src.generationWeight != null) {
                jsonObject.addProperty("generationWeight", (Number)src.generationWeight);
            }
            jsonObject.addProperty("minBaseLimit", (Number)src.minBaseLimit);
            jsonObject.addProperty("maxBaseLimit", (Number)src.maxBaseLimit);
            jsonObject.addProperty("minScaledLimit", (Number)src.minScaledLimit);
            jsonObject.addProperty("maxScaledLimit", (Number)src.maxScaledLimit);
            jsonObject.addProperty("spawnShiftX", (Number)src.spawnShift.x);
            jsonObject.addProperty("spawnShiftY", (Number)src.spawnShift.y);
            jsonObject.addProperty("spawnShiftZ", (Number)src.spawnShift.z);
            jsonObject.addProperty("front", Directions.serialize((ForgeDirection)src.front));
            jsonObject.addProperty("biomeExpression", src.biomeMatcher.getExpression());
            return jsonObject;
        }
    }
}

