/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.matchers;

import cpw.mods.fml.common.Loader;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.utils.ExpressionCaches;
import ivorius.reccomplex.utils.PrefixedTypeExpressionCache;
import ivorius.reccomplex.utils.RCBoolAlgebra;
import java.util.Arrays;
import joptsimple.internal.Strings;
import net.minecraft.util.EnumChatFormatting;

public class DependencyMatcher
extends PrefixedTypeExpressionCache<Boolean> {
    public static final String MOD_PREFIX = "$";
    public static final String STRUCTURE_PREFIX = "#";

    public DependencyMatcher(String expression) {
        super(RCBoolAlgebra.algebra(), true, EnumChatFormatting.GREEN + "No Dependencies", expression);
        this.addType(new ModVariableType(MOD_PREFIX));
        this.addType(new StructureVariableType(STRUCTURE_PREFIX));
    }

    public static String ofMods(String ... ids) {
        return ids.length > 0 ? MOD_PREFIX + Strings.join(Arrays.asList(ids), (String)" & $") : "";
    }

    public boolean apply() {
        return (Boolean)this.evaluate(new Object[0]);
    }

    protected static class StructureVariableType
    extends ExpressionCaches.SimpleVariableType<Boolean> {
        public StructureVariableType(String prefix) {
            super(prefix);
        }

        @Override
        public Boolean evaluate(String var, Object ... args) {
            return StructureRegistry.hasStructure(var);
        }

        @Override
        public boolean isKnown(String var, Object ... args) {
            return this.evaluate(var, args);
        }
    }

    protected static class ModVariableType
    extends ExpressionCaches.SimpleVariableType<Boolean> {
        public ModVariableType(String prefix) {
            super(prefix);
        }

        @Override
        public Boolean evaluate(String var, Object ... args) {
            return Loader.isModLoaded((String)var);
        }

        @Override
        public boolean isKnown(String var, Object ... args) {
            return this.evaluate(var, args);
        }
    }
}

