/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.matchers;

import com.google.common.base.Predicate;
import com.google.common.primitives.Ints;
import ivorius.reccomplex.dimensions.DimensionDictionary;
import ivorius.reccomplex.utils.ExpressionCaches;
import ivorius.reccomplex.utils.PrefixedTypeExpressionCache;
import ivorius.reccomplex.utils.RCBoolAlgebra;
import joptsimple.internal.Strings;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.ArrayUtils;

public class DimensionMatcher
extends PrefixedTypeExpressionCache<Boolean>
implements Predicate<WorldProvider> {
    public static final String DIMENSION_TYPE_PREFIX = "$";

    public DimensionMatcher(String expression) {
        super(RCBoolAlgebra.algebra(), true, EnumChatFormatting.GREEN + "Any Dimension", expression);
        this.addType(new DimensionVariableType(""));
        this.addType(new DimensionDictVariableType(DIMENSION_TYPE_PREFIX));
    }

    public static String ofTypes(String ... dimensionTypes) {
        return DIMENSION_TYPE_PREFIX + Strings.join((String[])dimensionTypes, (String)" & $");
    }

    public boolean apply(WorldProvider input) {
        return (Boolean)this.evaluate(input);
    }

    protected static class DimensionDictVariableType
    extends ExpressionCaches.SimpleVariableType<Boolean> {
        public DimensionDictVariableType(String prefix) {
            super(prefix);
        }

        @Override
        public Boolean evaluate(String var, Object ... args) {
            return DimensionDictionary.dimensionMatchesType((WorldProvider)args[0], var);
        }

        @Override
        public boolean isKnown(String var, Object ... args) {
            return DimensionDictionary.allRegisteredTypes().contains(var);
        }
    }

    protected static class DimensionVariableType
    extends ExpressionCaches.SimpleVariableType<Boolean> {
        public DimensionVariableType(String prefix) {
            super(prefix);
        }

        @Override
        public Boolean evaluate(String var, Object ... args) {
            Integer dimID = Ints.tryParse((String)var);
            return dimID != null && ((WorldProvider)args[0]).field_76574_g == dimID;
        }

        @Override
        public boolean isKnown(String var, Object ... args) {
            Integer dimID = Ints.tryParse((String)var);
            return dimID != null && ArrayUtils.contains((Object[])DimensionManager.getIDs(), (Object)dimID);
        }
    }
}

