/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.matchers;

import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.utils.ExpressionCaches;
import ivorius.reccomplex.utils.PrefixedTypeExpressionCache;
import ivorius.reccomplex.utils.RCBoolAlgebra;
import net.minecraft.util.EnumChatFormatting;

public class ResourceMatcher
extends PrefixedTypeExpressionCache<Boolean> {
    public static final String DOMAIN_PREFIX = "$";

    public ResourceMatcher(String expression) {
        super(RCBoolAlgebra.algebra(), true, EnumChatFormatting.GREEN + "Any Resource", expression);
        this.addType(new ResourceIDType(""));
        this.addType(new DomainType(DOMAIN_PREFIX));
    }

    public boolean apply(String resourceID, String domain) {
        return (Boolean)this.evaluate(resourceID, domain);
    }

    protected static class DomainType
    extends ExpressionCaches.SimpleVariableType<Boolean> {
        public DomainType(String prefix) {
            super(prefix);
        }

        @Override
        public Boolean evaluate(String var, Object ... args) {
            return args[1].equals(var);
        }

        @Override
        public boolean isKnown(String var, Object ... args) {
            return true;
        }
    }

    protected static class ResourceIDType
    extends ExpressionCaches.SimpleVariableType<Boolean> {
        public ResourceIDType(String prefix) {
            super(prefix);
        }

        @Override
        public Boolean evaluate(String var, Object ... args) {
            return args[0].equals(var);
        }

        @Override
        public boolean isKnown(String var, Object ... args) {
            return StructureRegistry.hasStructure(var);
        }
    }
}

