/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.transformers;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockAreas;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.Directions;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import ivorius.ivtoolkit.tools.NBTCompoundObjects;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.gui.editstructure.transformers.TableDataSourceBTRuins;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.random.BlurredValueField;
import ivorius.reccomplex.structures.StructureLoadContext;
import ivorius.reccomplex.structures.StructurePrepareContext;
import ivorius.reccomplex.structures.StructureSpawnContext;
import ivorius.reccomplex.structures.generic.transformers.Transformer;
import ivorius.reccomplex.utils.BlockAreas2;
import ivorius.reccomplex.utils.NBTStorable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;

public class TransformerRuins
implements Transformer<InstanceData> {
    public ForgeDirection decayDirection;
    public float minDecay;
    public float maxDecay;
    public float decayChaos;
    public float decayValueDensity;
    public float blockErosion;
    public float vineGrowth;

    public TransformerRuins() {
        this(ForgeDirection.DOWN, 0.0f, 0.9f, 0.3f, 0.04f, 0.3f, 0.1f);
    }

    public TransformerRuins(ForgeDirection decayDirection, float minDecay, float maxDecay, float decayChaos, float decayValueDensity, float blockErosion, float vineGrowth) {
        this.decayDirection = decayDirection;
        this.minDecay = minDecay;
        this.maxDecay = maxDecay;
        this.decayChaos = decayChaos;
        this.decayValueDensity = decayValueDensity;
        this.blockErosion = blockErosion;
        this.vineGrowth = vineGrowth;
    }

    private static boolean skipBlock(Collection<Pair<Transformer, NBTStorable>> transformers, final Block block, final int meta) {
        return Iterables.any(transformers, (Predicate)new Predicate<Pair<Transformer, NBTStorable>>(){

            public boolean apply(Pair<Transformer, NBTStorable> input) {
                return ((Transformer)input.getLeft()).skipGeneration((NBTStorable)input.getRight(), block, meta);
            }
        });
    }

    private static int getPass(Block block, int metadata) {
        return block.func_149721_r() || block.func_149688_o() == Material.field_151579_a ? 0 : 1;
    }

    public static void setBlockToAirClean(World world, BlockCoord blockCoord) {
        TileEntity tileEntity = world.func_147438_o(blockCoord.x, blockCoord.y, blockCoord.z);
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                inventory.func_70299_a(i, null);
            }
        }
        world.func_147468_f(blockCoord.x, blockCoord.y, blockCoord.z);
    }

    public static void shuffleArray(Object[] ar, Random rand) {
        for (int i = ar.length - 1; i > 0; --i) {
            int index = rand.nextInt(i + 1);
            Object a = ar[index];
            ar[index] = ar[i];
            ar[i] = a;
        }
    }

    public static int vineMetadata(ForgeDirection direction) {
        switch (direction) {
            case NORTH: {
                return 1;
            }
            case SOUTH: {
                return 4;
            }
            case WEST: {
                return 8;
            }
            case EAST: {
                return 2;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean skipGeneration(InstanceData instanceData, Block block, int metadata) {
        return false;
    }

    @Override
    public void transform(InstanceData instanceData, Transformer.Phase phase, StructureSpawnContext context, IvWorldData worldData, List<Pair<Transformer, NBTStorable>> transformers) {
        IvBlockCollection blockCollection = worldData.blockCollection;
        int[] size = context.boundingBoxSize();
        StructureBoundingBox dropAreaBB = context.boundingBox;
        RecurrentComplex.forgeEventHandler.disabledTileDropAreas.add(dropAreaBB);
        BlurredValueField field = instanceData.blurredValueField;
        if (field != null && field.getSize().length == 3) {
            BlockArea sourceArea = new BlockArea(new BlockCoord(0, 0, 0), new BlockCoord(blockCollection.width, blockCollection.height, blockCollection.length));
            BlockArea decaySideArea = BlockAreas.side((BlockArea)sourceArea, (ForgeDirection)this.decayDirection.getOpposite());
            BlockCoord decaySideAreaPos = decaySideArea.getLowerCorner();
            int decaySideLength = BlockAreas2.sideLength(sourceArea, this.decayDirection.getOpposite());
            for (int pass = 1; pass >= 0; --pass) {
                for (BlockCoord surfaceSourceCoord : decaySideArea) {
                    float decay = field.getValue(surfaceSourceCoord.x - decaySideAreaPos.x, surfaceSourceCoord.y - decaySideAreaPos.y, surfaceSourceCoord.z - decaySideAreaPos.z);
                    int removedBlocks = MathHelper.func_76141_d((float)(decay * (float)decaySideLength + 0.5f));
                    for (int decayPos = 0; decayPos < removedBlocks && decayPos < decaySideLength; ++decayPos) {
                        byte meta;
                        Block block;
                        BlockCoord sourceCoord = surfaceSourceCoord.add(this.decayDirection.offsetX * decayPos, this.decayDirection.offsetY * decayPos, this.decayDirection.offsetZ * decayPos);
                        BlockCoord worldCoord = context.transform.apply(sourceCoord, size).add(context.lowerCoord());
                        if (!context.includes(worldCoord) || TransformerRuins.getPass(block = blockCollection.getBlock(sourceCoord), meta = blockCollection.getMetadata(sourceCoord)) != pass || TransformerRuins.skipBlock(transformers, block, meta)) continue;
                        TransformerRuins.setBlockToAirClean(context.world, worldCoord);
                    }
                }
            }
        }
        int[] areaSize = new int[]{blockCollection.width, blockCollection.height, blockCollection.length};
        if (this.blockErosion > 0.0f || this.vineGrowth > 0.0f) {
            for (BlockCoord sourceCoord : blockCollection) {
                int meta;
                Block block;
                BlockCoord worldCoord = context.transform.apply(sourceCoord, areaSize).add(context.lowerCoord());
                if (!context.includes(worldCoord) || TransformerRuins.skipBlock(transformers, block = worldCoord.getBlock(context.world), meta = worldCoord.getMetadata(context.world))) continue;
                this.decayBlock(context.world, context.random, block, meta, worldCoord);
            }
        }
        RecurrentComplex.forgeEventHandler.disabledTileDropAreas.remove(dropAreaBB);
    }

    public void decayBlock(World world, Random random, Block block, int meta, BlockCoord coord) {
        Block newBlock = block;
        int newMeta = meta;
        if (random.nextFloat() < this.blockErosion) {
            if (newBlock == Blocks.field_150417_aV && newMeta == 0) {
                newMeta = 2;
            } else if (newBlock == Blocks.field_150322_A && (newMeta == 1 || newMeta == 2)) {
                newMeta = 0;
            }
        }
        if (random.nextFloat() < this.vineGrowth) {
            if (newBlock == Blocks.field_150417_aV && (newMeta == 2 || newMeta == 0)) {
                newMeta = 1;
            } else if (newBlock == Blocks.field_150347_e) {
                newBlock = Blocks.field_150341_Y;
                newMeta = 0;
            } else if (newBlock == Blocks.field_150463_bK && newMeta == 0) {
                newMeta = 1;
            } else if (newBlock == Blocks.field_150350_a) {
                Object[] directions = (ForgeDirection[])Directions.HORIZONTAL.clone();
                TransformerRuins.shuffleArray(directions, random);
                for (Object direction : directions) {
                    if (!Blocks.field_150395_bd.func_149707_d(world, coord.x, coord.y, coord.z, direction.ordinal())) continue;
                    newBlock = Blocks.field_150395_bd;
                    newMeta = TransformerRuins.vineMetadata((ForgeDirection)direction);
                    int length = 1 + random.nextInt(MathHelper.func_76141_d((float)(this.vineGrowth * 10.0f + 3.0f)));
                    for (int y = 0; y < length && world.func_147439_a(coord.x, coord.y - y, coord.z) == Blocks.field_150350_a; ++y) {
                        world.func_147465_d(coord.x, coord.y - y, coord.z, Blocks.field_150395_bd, newMeta, 3);
                    }
                    break;
                }
            }
        }
        if (block != newBlock || meta != newMeta) {
            world.func_147465_d(coord.x, coord.y, coord.z, newBlock, newMeta, 3);
        }
    }

    @Override
    public String getDisplayString() {
        return StatCollector.func_74838_a((String)"reccomplex.transformer.ruins");
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceBTRuins(this);
    }

    @Override
    public InstanceData prepareInstanceData(StructurePrepareContext context) {
        InstanceData instanceData = new InstanceData();
        if (this.minDecay > 0.0f || this.maxDecay > 0.0f) {
            int[] size = context.boundingBoxSize();
            BlockArea sourceArea = new BlockArea(new BlockCoord(0, 0, 0), new BlockCoord(size[0], size[1], size[2]));
            float decayChaos = context.random.nextFloat() * this.decayChaos;
            if (this.maxDecay - this.minDecay > decayChaos) {
                decayChaos = this.maxDecay - this.minDecay;
            }
            float decayCenter = context.random.nextFloat() * (this.maxDecay - this.minDecay) + this.minDecay;
            int[] blurredFieldSize = BlockAreas.side((BlockArea)sourceArea, (ForgeDirection)this.decayDirection).areaSize();
            instanceData.blurredValueField = new BlurredValueField(blurredFieldSize);
            int gridCoords = 1;
            for (int d : blurredFieldSize) {
                gridCoords *= d;
            }
            int values = MathHelper.func_76141_d((float)((float)gridCoords * this.decayValueDensity + 0.5f));
            for (int i = 0; i < values; ++i) {
                instanceData.blurredValueField.addValue(decayCenter + (context.random.nextFloat() - context.random.nextFloat()) * decayChaos * 2.0f, context.random);
            }
        }
        return instanceData;
    }

    @Override
    public InstanceData loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new InstanceData(nbt instanceof NBTTagCompound ? (NBTTagCompound)nbt : new NBTTagCompound());
    }

    @Override
    public boolean generatesInPhase(InstanceData instanceData, Transformer.Phase phase) {
        return phase == Transformer.Phase.AFTER;
    }

    public static class Serializer
    implements JsonDeserializer<TransformerRuins>,
    JsonSerializer<TransformerRuins> {
        private MCRegistry registry;

        public Serializer(MCRegistry registry) {
            this.registry = registry;
        }

        public TransformerRuins deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(jsonElement, "transformerRuins");
            ForgeDirection decayDirection = Directions.deserialize((String)JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "decayDirection", "DOWN"));
            float minDecay = JsonUtils.getJsonObjectFloatFieldValueOrDefault(jsonObject, "minDecay", 0.0f);
            float maxDecay = JsonUtils.getJsonObjectFloatFieldValueOrDefault(jsonObject, "maxDecay", 0.9f);
            float decayChaos = JsonUtils.getJsonObjectFloatFieldValueOrDefault(jsonObject, "decayChaos", 0.3f);
            float decayValueDensity = JsonUtils.getJsonObjectFloatFieldValueOrDefault(jsonObject, "decayValueDensity", 0.04f);
            float blockErosion = JsonUtils.getJsonObjectFloatFieldValueOrDefault(jsonObject, "blockErosion", 0.0f);
            float vineGrowth = JsonUtils.getJsonObjectFloatFieldValueOrDefault(jsonObject, "vineGrowth", 0.0f);
            return new TransformerRuins(decayDirection, minDecay, maxDecay, decayChaos, decayValueDensity, blockErosion, vineGrowth);
        }

        public JsonElement serialize(TransformerRuins transformer, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("decayDirection", Directions.serialize((ForgeDirection)transformer.decayDirection));
            jsonobject.addProperty("minDecay", (Number)Float.valueOf(transformer.minDecay));
            jsonobject.addProperty("maxDecay", (Number)Float.valueOf(transformer.maxDecay));
            jsonobject.addProperty("decayChaos", (Number)Float.valueOf(transformer.decayChaos));
            jsonobject.addProperty("decayValueDensity", (Number)Float.valueOf(transformer.decayValueDensity));
            jsonobject.addProperty("blockErosion", (Number)Float.valueOf(transformer.blockErosion));
            jsonobject.addProperty("vineGrowth", (Number)Float.valueOf(transformer.vineGrowth));
            return jsonobject;
        }
    }

    public static class InstanceData
    implements NBTStorable {
        public BlurredValueField blurredValueField;

        public InstanceData() {
        }

        public InstanceData(NBTTagCompound compound) {
            this.blurredValueField = (BlurredValueField)NBTCompoundObjects.read((NBTTagCompound)compound.func_74775_l("field"), BlurredValueField.class);
        }

        @Override
        public NBTBase writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("field", (NBTBase)NBTCompoundObjects.write((NBTCompoundObject)this.blurredValueField));
            return compound;
        }
    }
}

