/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.schematics;

import ivorius.ivtoolkit.tools.IvFileHelper;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.structures.schematics.SchematicFile;
import ivorius.reccomplex.utils.RCAccessorNBT;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.zip.GZIPOutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class SchematicLoader {
    public static void initializeFolder() {
        SchematicLoader.getValidatedSchematicsFile();
    }

    public static SchematicFile loadSchematicByName(String name) throws SchematicFile.UnsupportedSchematicFormatException {
        if (FilenameUtils.getExtension((String)name).length() == 0) {
            name = name + ".schematic";
        }
        for (File file : SchematicLoader.currentSchematicFiles()) {
            if (!file.getPath().endsWith(name) || !name.endsWith(file.getName())) continue;
            return SchematicLoader.loadSchematicFromFile(file);
        }
        return null;
    }

    public static SchematicFile loadSchematicFromFile(File file) throws SchematicFile.UnsupportedSchematicFormatException {
        NBTTagCompound compound = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            compound = CompressedStreamTools.func_74796_a((InputStream)fileInputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (compound != null) {
            return new SchematicFile(compound);
        }
        return null;
    }

    public static void writeSchematicByName(SchematicFile schematic, String name) {
        SchematicLoader.writeSchematicToFile(schematic, new File(SchematicLoader.getValidatedSchematicsFile(), name + ".schematic"));
    }

    public static void writeSchematicToFile(SchematicFile schematic, File file) {
        NBTTagCompound compound = new NBTTagCompound();
        schematic.writeToNBT(compound);
        try (DataOutputStream dataOutputStream = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(file)));){
            RCAccessorNBT.writeEntry("Schematic", (NBTBase)compound, dataOutputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String[] currentSchematicFileNames() {
        Collection<File> files = SchematicLoader.currentSchematicFiles();
        String[] filenames = new String[files.size()];
        int i = 0;
        for (File file : files) {
            filenames[i++] = FilenameUtils.getBaseName((String)file.getName());
        }
        return filenames;
    }

    public static Collection<File> currentSchematicFiles() {
        File schematicsFile = SchematicLoader.getValidatedSchematicsFile();
        return schematicsFile != null ? FileUtils.listFiles((File)schematicsFile, (String[])new String[]{"schematic"}, (boolean)true) : Collections.emptyList();
    }

    public static String getLookupFolderName() {
        return "structures/schematics";
    }

    public static File getValidatedSchematicsFile() {
        File structuresFile = IvFileHelper.getValidatedFolder((File)RecurrentComplex.proxy.getBaseFolderFile("structures"));
        return structuresFile != null ? IvFileHelper.getValidatedFolder((File)structuresFile, (String)"schematics") : null;
    }
}

