/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen;

import cpw.mods.fml.common.eventhandler.Event;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.events.RCEventBus;
import ivorius.reccomplex.events.StructureGenerationEvent;
import ivorius.reccomplex.events.StructureGenerationEventLite;
import ivorius.reccomplex.structures.StructureInfo;
import ivorius.reccomplex.structures.StructureInfos;
import ivorius.reccomplex.structures.StructureLoadContext;
import ivorius.reccomplex.structures.StructurePrepareContext;
import ivorius.reccomplex.structures.StructureSpawnContext;
import ivorius.reccomplex.structures.YSelector;
import ivorius.reccomplex.utils.NBTStorable;
import ivorius.reccomplex.worldgen.StructureGenerationData;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.MinecraftForge;

public class StructureGenerator {
    public static final int MIN_DIST_TO_LIMIT = 1;

    public static <I extends NBTStorable> void partially(StructureInfo<I> structureInfo, World world, Random random, BlockCoord coord, AxisAlignedTransform2D transform, @Nullable StructureBoundingBox generationBB, int layer, String structureName, NBTTagCompound instanceData, boolean firstTime) {
        StructureBoundingBox structureBoundingBox = StructureInfos.structureBoundingBox(coord, StructureInfos.structureSize(structureInfo, transform));
        I loadedInstanceData = structureInfo.loadInstanceData(new StructureLoadContext(transform, structureBoundingBox, false), (NBTBase)instanceData);
        StructureSpawnContext structureSpawnContext = new StructureSpawnContext(world, random, structureBoundingBox, generationBB, layer, false, transform, firstTime);
        structureInfo.generate(structureSpawnContext, loadedInstanceData);
        if (firstTime) {
            RecurrentComplex.logger.trace(String.format("Generated structure '%s' in %s", StructureGenerator.name(structureName), structureSpawnContext.boundingBox));
        }
    }

    public static <I extends NBTStorable> void partially(StructureInfo<I> structureInfo, World world, Random random, BlockCoord coord, AxisAlignedTransform2D transform, @Nullable StructureBoundingBox generationBB, int layer, String structureName, I instanceData, boolean firstTime) {
        StructureBoundingBox structureBoundingBox = StructureInfos.structureBoundingBox(coord, StructureInfos.structureSize(structureInfo, transform));
        StructureSpawnContext structureSpawnContext = new StructureSpawnContext(world, random, structureBoundingBox, generationBB, layer, false, transform, firstTime);
        structureInfo.generate(structureSpawnContext, instanceData);
        if (firstTime) {
            RecurrentComplex.logger.trace(String.format("Generated structure '%s' in %s", StructureGenerator.name(structureName), structureSpawnContext.boundingBox));
        }
    }

    public static <I extends NBTStorable> void directly(StructureInfo<I> structureInfo, StructureSpawnContext context) {
        structureInfo.generate(context, structureInfo.prepareInstanceData(new StructurePrepareContext(context.random, context.transform, context.boundingBox, context.generateAsSource)));
    }

    public static int randomInstantly(World world, Random random, StructureInfo info, @Nullable YSelector ySelector, int x, int z, boolean suggest, String structureName) {
        AxisAlignedTransform2D transform = AxisAlignedTransform2D.transform((int)(info.isRotatable() ? random.nextInt(4) : 0), (info.isMirrorable() && random.nextBoolean() ? 1 : 0) != 0);
        int[] size = StructureInfos.structureSize(info, transform);
        int genX = x - size[0] / 2;
        int genZ = z - size[2] / 2;
        int genY = ySelector != null ? ySelector.selectY(world, random, StructureInfos.structureBoundingBox(new BlockCoord(genX, 0, genZ), size)) : world.func_72976_f(x, z);
        BlockCoord coord = new BlockCoord(genX, genY, genZ);
        StructureGenerator.instantly(info, world, random, coord, transform, 0, suggest, structureName, false);
        return genY;
    }

    public static <I extends NBTStorable> boolean instantly(StructureInfo<I> structureInfo, World world, Random random, BlockCoord coord, AxisAlignedTransform2D transform, int layer, boolean suggest, String structureID, boolean asSource) {
        int[] size = StructureInfos.structureSize(structureInfo, transform);
        int[] coordInts = new int[]{coord.x, coord.y, coord.z};
        StructureSpawnContext structureSpawnContext = new StructureSpawnContext(world, random, StructureInfos.structureBoundingBox(coord, size), layer, asSource, transform);
        if (!(suggest && (coord.y < 1 || coord.y + size[1] > world.func_72800_K() - 1 - 1 || RCConfig.avoidOverlappingGeneration && StructureGenerationData.get(world).getEntriesAt(structureSpawnContext.boundingBox).size() != 0 || RCEventBus.INSTANCE.post((Event)new StructureGenerationEvent.Suggest(structureInfo, structureSpawnContext)) || MinecraftForge.EVENT_BUS.post((Event)new StructureGenerationEventLite.Suggest(world, structureID, coordInts, size, layer))))) {
            RCEventBus.INSTANCE.post((Event)new StructureGenerationEvent.Pre(structureInfo, structureSpawnContext));
            MinecraftForge.EVENT_BUS.post((Event)new StructureGenerationEventLite.Pre(world, structureID, coordInts, size, layer));
            structureInfo.generate(structureSpawnContext, structureInfo.prepareInstanceData(new StructurePrepareContext(random, transform, structureSpawnContext.boundingBox, structureSpawnContext.generateAsSource)));
            RecurrentComplex.logger.trace(String.format("Generated structure '%s' in %s", StructureGenerator.name(structureID), structureSpawnContext.boundingBox));
            RCEventBus.INSTANCE.post((Event)new StructureGenerationEvent.Post(structureInfo, structureSpawnContext));
            MinecraftForge.EVENT_BUS.post((Event)new StructureGenerationEventLite.Post(world, structureID, coordInts, size, layer));
            if (structureID != null) {
                StructureGenerationData.get(world).addCompleteEntry(structureID, coord, transform);
            }
            return true;
        }
        RecurrentComplex.logger.trace(String.format("Canceled structure '%s' generation in %s", structureID, structureSpawnContext.boundingBox));
        return false;
    }

    private static String name(String structureName) {
        return structureName != null ? structureName : "Unknown";
    }
}

