/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.structures.StructureInfo;
import ivorius.reccomplex.structures.StructureInfos;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.generic.gentypes.NaturalGenerationInfo;
import ivorius.reccomplex.structures.generic.gentypes.StaticGenerationInfo;
import ivorius.reccomplex.worldgen.StructureGenerationData;
import ivorius.reccomplex.worldgen.StructureGenerator;
import ivorius.reccomplex.worldgen.StructureSelector;
import java.util.List;
import java.util.Random;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import org.apache.commons.lang3.tuple.Pair;

public class WorldGenStructures
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        boolean worldWantsStructures = world.func_72912_H().func_76089_r();
        StructureGenerationData data = StructureGenerationData.get(world);
        WorldGenStructures.generatePartialStructuresInChunk(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        if (worldWantsStructures) {
            BiomeGenBase biomeGen = world.func_72807_a(chunkX * 16, chunkZ * 16);
            ChunkCoordinates spawnPos = world.func_72861_E();
            for (Pair<StructureInfo, StaticGenerationInfo> pair : StructureRegistry.getStaticStructuresAt(chunkX, chunkZ, world, spawnPos)) {
                RecurrentComplex.logger.trace(String.format("Spawning static structure at x = %d, z = %d", chunkX << 4, chunkZ << 4));
                StaticGenerationInfo staticGenInfo = (StaticGenerationInfo)pair.getRight();
                StructureInfo structureInfo = (StructureInfo)pair.getLeft();
                String structureName = StructureRegistry.structureID(structureInfo);
                int strucX = staticGenInfo.getPositionX(spawnPos);
                int strucZ = staticGenInfo.getPositionZ(spawnPos);
                StructureGenerator.randomInstantly(world, random, structureInfo, staticGenInfo.ySelector, strucX, strucZ, false, structureName);
            }
            if (data.checkChunk(new ChunkCoordIntPair(chunkX, chunkZ))) {
                boolean mayGenerate;
                boolean bl = mayGenerate = RCConfig.isGenerationEnabled(biomeGen) && RCConfig.isGenerationEnabled(world.field_73011_w);
                if (world.field_73011_w.field_76574_g == 0) {
                    double distToSpawn = IvVecMathHelper.distanceSQ((double[])new double[]{chunkX * 16 + 8, chunkZ * 16 + 8}, (double[])new double[]{spawnPos.field_71574_a, spawnPos.field_71573_c});
                    mayGenerate &= distToSpawn >= (double)(RCConfig.minDistToSpawnForGeneration * RCConfig.minDistToSpawnForGeneration);
                }
                if (mayGenerate) {
                    StructureSelector structureSelector = StructureRegistry.getStructureSelector(biomeGen, world.field_73011_w);
                    List<Pair<StructureInfo, NaturalGenerationInfo>> generated = structureSelector.generatedStructures(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                    for (Pair<StructureInfo, NaturalGenerationInfo> pair : generated) {
                        StructureInfo structureInfo = (StructureInfo)pair.getLeft();
                        NaturalGenerationInfo naturalGenInfo = (NaturalGenerationInfo)pair.getRight();
                        String structureName = StructureRegistry.structureID(structureInfo);
                        int genX = chunkX * 16 + random.nextInt(16);
                        int genZ = chunkZ * 16 + random.nextInt(16);
                        if (naturalGenInfo.hasLimitations() && !naturalGenInfo.getLimitations().areResolved(world, structureName)) continue;
                        StructureGenerator.randomInstantly(world, random, structureInfo, naturalGenInfo.ySelector, genX, genZ, true, structureName);
                    }
                }
            }
        }
    }

    public static void generatePartialStructuresInChunk(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        StructureGenerationData data = StructureGenerationData.get(world);
        for (StructureGenerationData.Entry entry : data.getEntriesAt(new ChunkCoordIntPair(chunkX, chunkZ), true)) {
            StructureInfo structureInfo = StructureRegistry.getStructure(entry.getStructureID());
            if (structureInfo == null) continue;
            StructureGenerator.partially(structureInfo, world, random, entry.lowerCoord, entry.transform, StructureInfos.chunkBoundingBox(chunkX, chunkZ), 0, entry.getStructureID(), entry.instanceData, entry.firstTime);
            if (!entry.firstTime) continue;
            entry.firstTime = false;
            data.func_76185_a();
        }
    }
}

