/*
 * Decompiled with CFR 0.152.
 */
package glenn.gases;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import glenn.gases.common.CommonProxy;
import glenn.gases.common.DamageSourceElectricLightning;
import glenn.gases.common.GasesMainConfigurations;
import glenn.gases.common.block.BlockAsh;
import glenn.gases.common.block.BlockDiabaline;
import glenn.gases.common.block.BlockDiabalineOre;
import glenn.gases.common.block.BlockRustedIronOre;
import glenn.gases.common.block.BlockWarmStone;
import glenn.gases.common.entity.EntityBlueDust;
import glenn.gases.common.entity.EntityFlashFX;
import glenn.gases.common.entity.EntityFlashSparkFX;
import glenn.gases.common.entity.EntityGlowstoneShard;
import glenn.gases.common.entity.EntitySmallLightning;
import glenn.gases.common.entity.EntitySnapdragon;
import glenn.gases.common.entity.EntityTurquoiseDust;
import glenn.gases.common.gastype.GasTypeBlackDamp;
import glenn.gases.common.gastype.GasTypeChlorine;
import glenn.gases.common.gastype.GasTypeElectric;
import glenn.gases.common.gastype.GasTypeFinine;
import glenn.gases.common.gastype.GasTypeLightSensitive;
import glenn.gases.common.gastype.GasTypePoisonous;
import glenn.gases.common.gastype.GasTypeVoid;
import glenn.gases.common.gasworldgentype.GasWorldGenDiabalinePocket;
import glenn.gases.common.item.ItemAdvancedRespirator;
import glenn.gases.common.item.ItemDust;
import glenn.gases.common.item.ItemGasDetector;
import glenn.gases.common.item.ItemGlowstoneShard;
import glenn.gases.common.item.ItemPrimitiveRespirator;
import glenn.gases.common.item.ItemRefinedDiabaline;
import glenn.gases.common.item.ItemSnapdragon;
import glenn.gases.common.reaction.ReactionAcidVapour;
import glenn.gases.common.reaction.ReactionCorrosion;
import glenn.gases.common.reaction.ReactionDustDrop;
import glenn.gases.common.reaction.ReactionExtinguish;
import glenn.gases.common.reaction.ReactionRust;
import glenn.gases.common.worldgen.WorldGeneratorGases;
import glenn.gasesframework.api.Combustibility;
import glenn.gasesframework.api.ExtendedGasEffectsBase;
import glenn.gasesframework.api.GasesFrameworkAPI;
import glenn.gasesframework.api.ItemKey;
import glenn.gasesframework.api.gastype.GasType;
import glenn.gasesframework.api.gasworldgentype.GasWorldGenCloud;
import glenn.gasesframework.api.lanterntype.LanternType;
import glenn.gasesframework.api.reaction.ReactionUniqueIgnition;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCompressed;
import net.minecraft.block.material.MapColor;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.EnumHelper;

@Mod(modid="gases", name="Glenn's Gases", version="1.6.2", dependencies="required-after:gasesFramework; required-after:gasesCore", acceptedMinecraftVersions="[1.7.10]")
public class Gases {
    @Mod.Instance(value="gases")
    public static Gases instance;
    @SidedProxy(clientSide="glenn.gases.client.ClientProxy", serverSide="glenn.gases.server.ServerProxy")
    public static CommonProxy proxy;
    public static final String MODID = "gases";
    public static final String VERSION = "1.6.2";
    public static final String TARGETVERSION = "1.7.10";
    public static GasesMainConfigurations configurations;
    public static final DamageSource electricLightningDamageSource;
    public static Item glowstoneShard;
    public static Item gasDetector;
    public static Item gasSensitiveChip;
    public static Item turquoiseDust;
    public static Item blueDust;
    public static Item snapdragon;
    public static Item primitiveRespirator;
    public static Item advancedRespirator;
    public static ItemRefinedDiabaline refinedDiabaline;
    public static Item ironIngotRusted;
    public static Block rustedIronOre;
    public static Block rustedIronBlock;
    public static Block warmStone;
    public static Block diabalineOre;
    public static Block diabalineOreGlowing;
    public static Block diabalineBlock;
    public static Block diabalineBlockGlowing;
    public static Block ash;
    public static final LanternType lanternTypeTorch;
    public static final LanternType lanternTypeGlowstone;
    public static final GasType gasTypeSteam;
    public static final GasType gasTypeRisingFlammable;
    public static final GasType gasTypeFallingExplosive;
    public static final GasType gasTypeVoid;
    public static final GasType gasTypeElectric;
    public static final GasType gasTypeCorrosive;
    public static final GasType gasTypeNitrous;
    public static final GasType gasTypeAcidVapour;
    public static final GasType gasTypeCoalDust;
    public static final GasType gasTypeBlackDamp;
    public static final GasType gasTypeChlorine;
    public static final GasType gasTypeDust;
    public static final GasType gasTypeLightSensitive;
    public static final GasType gasTypeHelium;
    public static final GasType gasTypeFinine;
    public static ItemArmor.ArmorMaterial PRIMITIVE_RESPIRATOR;
    public static ItemArmor.ArmorMaterial ADVANCED_RESPIRATOR;

    private void initBlocksAndItems() {
        glowstoneShard = new ItemGlowstoneShard().func_77655_b("gg_glowstoneShard").func_111206_d("gases:glowstone_shard");
        GameRegistry.registerItem((Item)glowstoneShard, (String)"glowstoneShard");
        gasDetector = new ItemGasDetector().func_77655_b("gg_gasDetector").func_77637_a(GasesFrameworkAPI.creativeTab).func_111206_d("gases:detector");
        GameRegistry.registerItem((Item)gasDetector, (String)"gasDetector");
        gasSensitiveChip = new Item().func_77655_b("gg_gasSensitiveChip").func_77637_a(GasesFrameworkAPI.creativeTab).func_111206_d("gases:chip");
        GameRegistry.registerItem((Item)gasSensitiveChip, (String)"gasSensitiveChip");
        turquoiseDust = new ItemDust(EntityTurquoiseDust.class).func_77655_b("gg_turquoiseDust").func_77637_a(GasesFrameworkAPI.creativeTab).func_111206_d("gases:dust_turquoise");
        GameRegistry.registerItem((Item)turquoiseDust, (String)"turquoiseDust");
        blueDust = new ItemDust(EntityBlueDust.class).func_77655_b("gg_blueDust").func_77637_a(GasesFrameworkAPI.creativeTab).func_111206_d("gases:dust_blue");
        GameRegistry.registerItem((Item)blueDust, (String)"blueDust");
        snapdragon = new ItemSnapdragon().func_77655_b("gg_snapdragon").func_77637_a(GasesFrameworkAPI.creativeTab).func_111206_d("gases:snapdragon");
        GameRegistry.registerItem((Item)snapdragon, (String)"snapdragon");
        primitiveRespirator = new ItemPrimitiveRespirator().func_77655_b("gg_primitiveRespirator").func_77637_a(GasesFrameworkAPI.creativeTab).func_111206_d("gases:respirator_primitive");
        GameRegistry.registerItem((Item)primitiveRespirator, (String)"primitiveRespirator");
        advancedRespirator = new ItemAdvancedRespirator().func_77655_b("gg_advancedRespirator").func_77637_a(GasesFrameworkAPI.creativeTab).func_111206_d("gases:respirator_advanced");
        GameRegistry.registerItem((Item)advancedRespirator, (String)"advancedRespirator");
        refinedDiabaline = (ItemRefinedDiabaline)new ItemRefinedDiabaline().func_77655_b("gg_refinedDiabaline").func_77637_a(GasesFrameworkAPI.creativeTab).func_111206_d("gases:diabaline");
        GameRegistry.registerItem((Item)refinedDiabaline, (String)"refinedDiabaline");
        ironIngotRusted = new Item().func_77655_b("gg_ironIngotRusted").func_77637_a(GasesFrameworkAPI.creativeTab).func_111206_d("gases:iron_ingot_rusted");
        GameRegistry.registerItem((Item)ironIngotRusted, (String)"ironIngotRusted");
        rustedIronOre = new BlockRustedIronOre().func_149711_c(3.0f).func_149752_b(5.0f).func_149672_a(Block.field_149780_i).func_149663_c("gg_rustedIronOre").func_149647_a(GasesFrameworkAPI.creativeTab).func_149658_d("gases:iron_ore_rusted");
        GameRegistry.registerBlock((Block)rustedIronOre, (String)"rustedIronOre");
        rustedIronBlock = new BlockCompressed(MapColor.field_151650_B).func_149711_c(5.0f).func_149752_b(10.0f).func_149672_a(Block.field_149777_j).func_149663_c("gg_rustedIronBlock").func_149647_a(GasesFrameworkAPI.creativeTab).func_149658_d("gases:iron_block_rusted");
        GameRegistry.registerBlock((Block)rustedIronBlock, (String)"rustedIronBlock");
        warmStone = new BlockWarmStone().func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(Block.field_149780_i).func_149663_c("gg_warmStone").func_149658_d("gases:stone_warm");
        GameRegistry.registerBlock((Block)warmStone, (String)"warmStone");
        diabalineOre = new BlockDiabalineOre(false).func_149663_c("gg_diabalineOre").func_149647_a(GasesFrameworkAPI.creativeTab).func_149658_d("gases:diabaline_ore");
        GameRegistry.registerBlock((Block)diabalineOre, (String)"diabalineOre");
        diabalineOreGlowing = new BlockDiabalineOre(true).func_149663_c("gg_diabalineOreGlowing").func_149647_a(null).func_149658_d("gases:diabaline_ore_glowing");
        GameRegistry.registerBlock((Block)diabalineOreGlowing, (String)"diabalineOreGlowing");
        diabalineBlock = new BlockDiabaline(false).func_149663_c("gg_diabalineBlock").func_149647_a(GasesFrameworkAPI.creativeTab).func_149658_d("gases:diabaline_block");
        GameRegistry.registerBlock((Block)diabalineBlock, (String)"diabalineBlock");
        diabalineBlockGlowing = new BlockDiabaline(true).func_149663_c("gg_diabalineBlockGlowing").func_149658_d("gases:diabaline_block_glowing");
        GameRegistry.registerBlock((Block)diabalineBlockGlowing, (String)"diabalineBlockGlowing");
        ash = new BlockAsh().func_149711_c(0.5f).func_149663_c("gg_ash").func_149658_d("gases:ash");
        GameRegistry.registerBlock((Block)ash, (String)"ash");
        LanguageRegistry.addName((Object)ash, (String)(EnumChatFormatting.OBFUSCATED + "Ash"));
        GasesFrameworkAPI.registerLanternType(lanternTypeTorch);
        GasesFrameworkAPI.registerLanternType(lanternTypeGlowstone);
        GasesFrameworkAPI.registerGasType(gasTypeSteam, GasesFrameworkAPI.creativeTab);
        GasesFrameworkAPI.registerGasType(gasTypeRisingFlammable, GasesFrameworkAPI.creativeTab);
        GasesFrameworkAPI.registerGasType(gasTypeFallingExplosive, GasesFrameworkAPI.creativeTab);
        GasesFrameworkAPI.registerGasType(gasTypeVoid, GasesFrameworkAPI.creativeTab);
        GasesFrameworkAPI.registerGasType(gasTypeElectric, GasesFrameworkAPI.creativeTab);
        GasesFrameworkAPI.registerGasType(gasTypeCorrosive, GasesFrameworkAPI.creativeTab);
        GasesFrameworkAPI.registerGasType(gasTypeNitrous, GasesFrameworkAPI.creativeTab);
        GasesFrameworkAPI.registerGasType(gasTypeAcidVapour);
        GasesFrameworkAPI.registerGasType(gasTypeCoalDust, GasesFrameworkAPI.creativeTab);
        GasesFrameworkAPI.registerGasType(gasTypeBlackDamp);
        GasesFrameworkAPI.registerGasType(gasTypeChlorine, GasesFrameworkAPI.creativeTab);
        GasesFrameworkAPI.registerGasType(gasTypeDust);
        GasesFrameworkAPI.registerGasType(gasTypeLightSensitive, GasesFrameworkAPI.creativeTab);
        GasesFrameworkAPI.registerGasType(gasTypeHelium, GasesFrameworkAPI.creativeTab);
        GasesFrameworkAPI.registerGasType(gasTypeFinine, GasesFrameworkAPI.creativeTab);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PRIMITIVE_RESPIRATOR = EnumHelper.addArmorMaterial((String)"PRIMITIVE_RESPIRATOR", (int)125, (int[])new int[]{0, 0, 0, 0}, (int)0);
        ADVANCED_RESPIRATOR = EnumHelper.addArmorMaterial((String)"ADVANCED_RESPIRATOR", (int)600, (int[])new int[]{0, 0, 0, 0}, (int)0);
        this.initBlocksAndItems();
        configurations = new GasesMainConfigurations(event.getSuggestedConfigurationFile());
        proxy.registerEventHandlers();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        GasType[] allTypes;
        proxy.registerRenderers();
        GasesFrameworkAPI.registerGasWorldGenType(new GasWorldGenDiabalinePocket("overworld_greenGas", gasTypeRisingFlammable, Gases.configurations.worldGenGreenGas, 48.0f, 0.5f, 16, 48, Blocks.field_150348_b), "overworld");
        GasesFrameworkAPI.registerGasWorldGenType(new GasWorldGenDiabalinePocket("overworld_redGas", gasTypeFallingExplosive, Gases.configurations.worldGenRedGas, 48.0f, 0.5f, 4, 20, Blocks.field_150348_b), "overworld");
        GasesFrameworkAPI.registerGasWorldGenType(new GasWorldGenDiabalinePocket("overworld_nitrousGas", gasTypeNitrous, Gases.configurations.worldGenNitrousGas, 32.0f, 0.5f, 4, 20, Blocks.field_150348_b), "overworld");
        GasesFrameworkAPI.registerGasWorldGenType(new GasWorldGenDiabalinePocket("overworld_chlorineGas", gasTypeChlorine, Gases.configurations.worldGenChlorineGas, 32.0f, 0.5f, 32, 48, Blocks.field_150348_b), "overworld");
        GasesFrameworkAPI.registerGasWorldGenType(new GasWorldGenDiabalinePocket("overworld_lightSensitive", gasTypeLightSensitive, Gases.configurations.worldGenLightSensitiveGas, 24.0f, 0.5f, 4, 60, Blocks.field_150348_b), "overworld");
        GasesFrameworkAPI.registerGasWorldGenType(new GasWorldGenCloud("overworld_blackDamp", gasTypeBlackDamp, Gases.configurations.worldGenBlackDamp, 80.0f, 0.5f, 4, 48), "overworld");
        GasesFrameworkAPI.registerGasWorldGenType(new GasWorldGenDiabalinePocket("overworld_helium", gasTypeHelium, Gases.configurations.worldGenHelium, 24.0f, 0.5f, 64, 96, Blocks.field_150348_b), "overworld");
        GasesFrameworkAPI.registerGasWorldGenType(new GasWorldGenCloud("nether_electricGas", gasTypeElectric, Gases.configurations.worldGenElectricGas, 80.0f, 0.5f, 40, 128), "nether");
        GasesFrameworkAPI.registerGasWorldGenType(new GasWorldGenCloud("nether_corrosiveGas", gasTypeCorrosive, Gases.configurations.worldGenCorrosiveGas, 80.0f, 0.5f, 40, 128), "nether");
        GasesFrameworkAPI.registerGasWorldGenType(new GasWorldGenCloud("end_finine", gasTypeFinine, Gases.configurations.worldGenFinineGas, 80.0f, 0.5f, 40, 128), "the end");
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorGases(), (int)10);
        GameRegistry.addRecipe((ItemStack)new ItemStack(primitiveRespirator), (Object[])new Object[]{" W ", "SCS", " L ", Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('S'), Items.field_151007_F, Character.valueOf('C'), Items.field_151044_h, Character.valueOf('L'), Items.field_151116_aA});
        GameRegistry.addRecipe((ItemStack)new ItemStack(advancedRespirator), (Object[])new Object[]{" I ", " G ", "CLC", Character.valueOf('I'), Items.field_151028_Y, Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('C'), Items.field_151044_h, Character.valueOf('L'), Items.field_151116_aA});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(snapdragon, 4), (Object[])new Object[]{Items.field_151121_aF, Items.field_151016_H, turquoiseDust, blueDust});
        GameRegistry.addRecipe((ItemStack)new ItemStack(gasSensitiveChip), (Object[])new Object[]{"GRG", "RDR", "GRG", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('D'), diabalineBlock});
        GameRegistry.addRecipe((ItemStack)new ItemStack(rustedIronBlock), (Object[])new Object[]{"III", "III", "III", Character.valueOf('I'), ironIngotRusted});
        GameRegistry.addRecipe((ItemStack)new ItemStack(diabalineBlock), (Object[])new Object[]{"DDD", "DDD", "DDD", Character.valueOf('D'), refinedDiabaline});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)refinedDiabaline, 9), (Object[])new Object[]{"D", Character.valueOf('D'), diabalineBlock});
        for (GasType type : allTypes = GasType.getAllTypes()) {
            if (!type.isIndustrial) continue;
            GameRegistry.addRecipe((ItemStack)new ItemStack(gasDetector, 1, type.gasID), (Object[])new Object[]{" I ", "ICS", " I ", Character.valueOf('S'), new ItemStack(GasesFrameworkAPI.gasSamplerIncluder, 1, type.gasID), Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('C'), new ItemStack(gasSensitiveChip)});
        }
        GasesFrameworkAPI.addSpecialFurnaceRecipe(new ItemStack(diabalineOre), new ItemStack((Item)refinedDiabaline), 200, 200);
        GasesFrameworkAPI.addSpecialFurnaceRecipe(new ItemStack(rustedIronOre), new ItemStack(Items.field_151042_j), 200, 200);
        GasesFrameworkAPI.addSpecialFurnaceRecipe(new ItemStack(ironIngotRusted), new ItemStack(Items.field_151042_j), 200, 200);
        GasesFrameworkAPI.addSpecialFurnaceRecipe(new ItemStack(rustedIronBlock), new ItemStack(Blocks.field_150339_S), 200, 200);
        if (Gases.configurations.other_enableDiamondSmelt) {
            GasesFrameworkAPI.addSpecialFurnaceRecipe(new ItemStack(Items.field_151044_h, 64), new ItemStack(Items.field_151045_i), 25600, 800);
        }
        GasesFrameworkAPI.registerReaction(new ReactionUniqueIgnition(13, Gases.gasTypeFallingExplosive.block, Blocks.field_150355_j));
        GasesFrameworkAPI.registerReaction(new ReactionUniqueIgnition(13, Gases.gasTypeFallingExplosive.block, (Block)Blocks.field_150358_i));
        GasesFrameworkAPI.registerReaction(new ReactionDustDrop(Gases.gasTypeElectric.block, Gases.gasTypeCorrosive.block));
        GasesFrameworkAPI.registerReaction(new ReactionCorrosion(Gases.gasTypeCorrosive.block));
        GasesFrameworkAPI.registerReaction(new ReactionAcidVapour(11, Gases.gasTypeNitrous.block, Blocks.field_150355_j));
        GasesFrameworkAPI.registerReaction(new ReactionAcidVapour(12, Gases.gasTypeNitrous.block, (Block)Blocks.field_150358_i));
        GasesFrameworkAPI.registerReaction(new ReactionExtinguish(0, Gases.gasTypeBlackDamp.block, Blocks.field_150478_aa));
        GasesFrameworkAPI.registerReaction(new ReactionExtinguish(0, Gases.gasTypeBlackDamp.block, (Block)Blocks.field_150480_ab));
        GasesFrameworkAPI.registerReaction(new ReactionRust(Gases.gasTypeChlorine.block));
        GasTypeChlorine.blocksToRust.put(Blocks.field_150366_p, rustedIronOre);
        GasTypeChlorine.blocksToRust.put(Blocks.field_150339_S, rustedIronBlock);
        GasTypeChlorine.itemsToRust.put(Items.field_151042_j, ironIngotRusted);
        EntityRegistry.registerModEntity(EntitySmallLightning.class, (String)"smallLightning", (int)127, (Object)this, (int)20, (int)1, (boolean)false);
        EntityRegistry.registerModEntity(EntityGlowstoneShard.class, (String)"glowstoneShard", (int)126, (Object)this, (int)20, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityTurquoiseDust.class, (String)"dustParticleGreen", (int)125, (Object)this, (int)20, (int)1, (boolean)false);
        EntityRegistry.registerModEntity(EntityBlueDust.class, (String)"dustParticleBlue", (int)124, (Object)this, (int)20, (int)1, (boolean)false);
        EntityRegistry.registerModEntity(EntitySnapdragon.class, (String)"snapdragon", (int)123, (Object)this, (int)20, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityFlashFX.class, (String)"flashFX", (int)122, (Object)this, (int)20, (int)1, (boolean)false);
        EntityRegistry.registerModEntity(EntityFlashSparkFX.class, (String)"flashSparkFX", (int)121, (Object)this, (int)20, (int)1, (boolean)false);
    }

    static {
        electricLightningDamageSource = new DamageSourceElectricLightning("gg_lightning");
        lanternTypeTorch = new LanternType("torch", 0.75f, "gases:lantern_torch", new ItemKey(Item.func_150898_a((Block)Blocks.field_150478_aa)), null, 0).setInOut();
        lanternTypeGlowstone = new LanternType("glowstone", 1.0f, "gases:lantern_glowstone", new ItemKey(Items.field_151114_aO), null, 0).setInOut();
        gasTypeSteam = new GasType(true, 2, "steam", -193, 0, -32, Combustibility.NONE).setDamage(2.0f).setDissipationRate(8);
        gasTypeRisingFlammable = new GasType(true, 3, "greenGas", 0x6F7F6F7F, 1, -12, Combustibility.FLAMMABLE).setEffectRate(ExtendedGasEffectsBase.EffectType.BLINDNESS, 2).setEffectRate(ExtendedGasEffectsBase.EffectType.SUFFOCATION, 2).setEffectRate(ExtendedGasEffectsBase.EffectType.SLOWNESS, 8);
        gasTypeFallingExplosive = new GasType(true, 4, "redGas", 0x7F4F4F7F, 3, 4, Combustibility.EXPLOSIVE).setEffectRate(ExtendedGasEffectsBase.EffectType.BLINDNESS, 1).setEffectRate(ExtendedGasEffectsBase.EffectType.SUFFOCATION, 2).setEffectRate(ExtendedGasEffectsBase.EffectType.SLOWNESS, 8);
        gasTypeVoid = new GasTypeVoid(true, 5, "voidGas", 0x1F1F1F9F, 4, 8, Combustibility.NONE).setEffectRate(ExtendedGasEffectsBase.EffectType.BLINDNESS, 20).setEffectRate(ExtendedGasEffectsBase.EffectType.SUFFOCATION, 40).setDamage(1.0f);
        gasTypeElectric = new GasTypeElectric(true, 6, "electricGas", 0x1F7F7F7F, 0, 0, Combustibility.NONE).setEffectRate(ExtendedGasEffectsBase.EffectType.BLINDNESS, 4).setEffectRate(ExtendedGasEffectsBase.EffectType.SUFFOCATION, 2).setTextureName("gases:gas_special");
        gasTypeCorrosive = new GasType(true, 7, "corrosiveGas", 522182527, 0, 0, Combustibility.NONE).setEffectRate(ExtendedGasEffectsBase.EffectType.BLINDNESS, 4).setEffectRate(ExtendedGasEffectsBase.EffectType.SUFFOCATION, 2).setDamage(0.5f).setTextureName("gases:gas_special");
        gasTypeNitrous = new GasTypePoisonous(true, 8, "nitrousGas", 1866411903, 3, 4, Combustibility.NONE).setEffectRate(ExtendedGasEffectsBase.EffectType.BLINDNESS, 1).setEffectRate(ExtendedGasEffectsBase.EffectType.SUFFOCATION, 2).setEffectRate(ExtendedGasEffectsBase.EffectType.SLOWNESS, 16);
        gasTypeAcidVapour = new GasType(false, 9, "acidVapour", 1333772143, 0, -32, Combustibility.NONE).setEffectRate(ExtendedGasEffectsBase.EffectType.BLINDNESS, 20).setEffectRate(ExtendedGasEffectsBase.EffectType.SUFFOCATION, 1).setDamage(2.0f).setDissipationRate(1).setTextureName("gases:gas_special");
        gasTypeCoalDust = new GasType(false, 10, "coalDust", 0x2F2F2F6F, 0, 0, Combustibility.HIGHLY_EXPLOSIVE).setEffectRate(ExtendedGasEffectsBase.EffectType.SUFFOCATION, 6).setEffectRate(ExtendedGasEffectsBase.EffectType.SLOWNESS, 16).setDissipationRate(5);
        gasTypeBlackDamp = new GasTypeBlackDamp(false, 12, "blackDamp", 0, 0, 0, Combustibility.NONE).setOverlayImage(GasesFrameworkAPI.emptyOverlayImage).setEffectRate(ExtendedGasEffectsBase.EffectType.SUFFOCATION, 6).setEffectRate(ExtendedGasEffectsBase.EffectType.SLOWNESS, 24);
        gasTypeChlorine = new GasTypeChlorine(true, 13, "chlorineGas", -1024287585, 1, 8, Combustibility.NONE).setEffectRate(ExtendedGasEffectsBase.EffectType.BLINDNESS, 4).setEffectRate(ExtendedGasEffectsBase.EffectType.SUFFOCATION, 6);
        gasTypeDust = new GasType(false, 14, "stoneDust", 0x7F7F7F2F, 0, 16, Combustibility.NONE).setEffectRate(ExtendedGasEffectsBase.EffectType.SUFFOCATION, 8).setEffectRate(ExtendedGasEffectsBase.EffectType.SLOWNESS, 16).setDissipationRate(16);
        gasTypeLightSensitive = new GasTypeLightSensitive(true, 15, "lightSensitive", 1546352447, 0, -4, Combustibility.CONTROLLABLE);
        gasTypeHelium = new GasType(true, 16, "helium", 0xFFFF1F, 0, -12, Combustibility.NONE).setEffectRate(ExtendedGasEffectsBase.EffectType.SUFFOCATION, 14);
        gasTypeFinine = new GasTypeFinine(true, 17, "finine", -71489, 0, 0, Combustibility.NONE).setTextureName("gases:finine");
    }
}

