/*
 * Decompiled with CFR 0.152.
 */
package yuuto.enhancedinventories.client;

import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import yuuto.enhancedinventories.gui.ContainerDynamic;
import yuuto.enhancedinventories.proxy.ConfigHandler;

public class GuiContainerDynamic
extends GuiContainer {
    static ResourceLocation topTexture = new ResourceLocation("enhancedinventories", "textures/gui/dynamicTop.png");
    static ResourceLocation bottomTexture1 = new ResourceLocation("enhancedinventories", "textures/gui/dynamicBottom1.png");
    static ResourceLocation bottomTexture2 = new ResourceLocation("enhancedinventories", "textures/gui/dynamicBottom2.png");
    static int centerXSize = 162;
    static int bottomYSize = 97;
    static int minScroll = 18;
    static int scrollButtonWidth = 16;
    static int scrollButtonHeight = 19;
    int rows;
    int columns;
    boolean canScroll = false;
    int scroll = 18;
    int previousY = 0;
    boolean scrolling = false;
    int maxScroll = 105;
    ContainerDynamic container = (ContainerDynamic)this.field_147002_h;

    public GuiContainerDynamic(IInventory tile, EntityPlayer player) {
        super((Container)new ContainerDynamic(tile, player));
        if (tile.func_70302_i_() < ConfigHandler.MAX_SIZE) {
            if (tile.func_70302_i_() <= 9) {
                this.rows = 1;
                this.columns = tile.func_70302_i_();
            } else if (tile.func_70302_i_() <= 54) {
                this.columns = 9;
                this.rows = (int)Math.ceil((float)tile.func_70302_i_() / 9.0f);
            } else {
                this.columns = (int)Math.min(Math.ceil((float)tile.func_70302_i_() / 6.0f), (double)ConfigHandler.COLOMNS);
                this.rows = (int)Math.min(Math.ceil((float)tile.func_70302_i_() / (float)this.columns), (double)ConfigHandler.COLOMNS);
            }
        } else {
            this.rows = ConfigHandler.ROWS;
            this.columns = ConfigHandler.COLOMNS;
        }
        this.field_146999_f = 14 + 18 * this.columns;
        this.field_147000_g = 114 + 18 * this.rows;
        if (tile.func_70302_i_() > ConfigHandler.MAX_SIZE) {
            this.field_146999_f += 18;
            this.canScroll = true;
            this.maxScroll = this.field_147000_g - (bottomYSize + scrollButtonHeight + 1);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.canScroll) {
            this.updateSlots();
        }
    }

    protected void func_146979_b(int mX, int mY) {
    }

    protected void func_146976_a(float p_146976_1_, int mX, int mY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(topTexture);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        int x1 = 7 + 18 * Math.min(this.columns, 12);
        int y1 = 17 + 18 * Math.min(this.rows, 12);
        int x2 = 7 + 18 * Math.max(this.columns - 12, 0);
        int y2 = 18 * Math.max(this.rows - 12, 0);
        int bSX1 = (this.field_146999_f - centerXSize) / 2;
        int bSX2 = 0;
        if (bSX1 > 250) {
            bSX2 = bSX1 - 250;
            bSX1 = 250;
        }
        this.func_73729_b(x, y, 0, 0, x1, y1);
        this.func_73729_b(x + x1, y, 230 - x2, 0, x2, y1);
        if (this.canScroll) {
            this.func_73729_b(x + x1 + x2 - 7, y, 230, 0, 25, y1);
        }
        if (y2 > 0) {
            this.func_73729_b(x, y + y1, 0, 17, x1, y2);
            this.func_73729_b(x + x1, y + y1, 230 - x2, 17, x2, y2);
            if (this.canScroll) {
                this.func_73729_b(x + x1 + x2 - 7, y + y1, 230, 17, 25, y2);
            }
        }
        if (this.canScroll) {
            this.func_73729_b(x + x1 + x2 - 6, y + this.scroll, 0, 234, scrollButtonWidth, scrollButtonHeight);
        }
        this.field_146297_k.field_71446_o.func_110577_a(bottomTexture1);
        this.func_73729_b(x, y + y1 + y2, 0, 118, bSX1, 97);
        this.func_73729_b(x + bSX1, y + y1 + y2, 7, 118, bSX2, 97);
        this.func_73729_b(x + bSX1 + bSX2, y + y1 + y2, 0, 0, 162, 97);
        this.field_146297_k.field_71446_o.func_110577_a(bottomTexture2);
        this.func_73729_b(x + bSX1 + bSX2 + centerXSize, y + y1 + y2, 0, 0, bSX2, 97);
        this.func_73729_b(x + bSX1 + 2 * bSX2 + centerXSize, y + y1 + y2, 250 - bSX1, 0, bSX1, 97);
    }

    int getStartingRow() {
        int maxRows = (int)Math.ceil((float)this.container.playerInvStart / (float)this.columns);
        double precent = ((double)this.scroll - (double)minScroll) / ((double)this.maxScroll - (double)minScroll);
        int row = (int)Math.round((double)(maxRows -= this.rows) * precent);
        return row;
    }

    protected void func_73864_a(int mX, int mY, int button) {
        if (this.scrolling) {
            return;
        }
        if (button != 0 || !this.canScroll) {
            super.func_73864_a(mX, mY, button);
            return;
        }
        int adjMX = mX - this.field_147003_i;
        int adjMY = mY - this.field_147009_r;
        if (adjMX < this.field_146999_f - 25 || adjMX > this.field_146999_f - 7) {
            super.func_73864_a(mX, mY, button);
            return;
        }
        if (adjMY < this.scroll || adjMY > this.scroll + scrollButtonHeight) {
            super.func_73864_a(mX, mY, button);
            return;
        }
        this.previousY = adjMY;
        this.scrolling = true;
    }

    protected void func_146273_a(int mX, int mY, int button, long time) {
        if (button != 0 || !this.scrolling || !this.canScroll) {
            super.func_146273_a(mX, mY, button, time);
            return;
        }
        int adjMY = mY - this.field_147009_r;
        if (this.previousY <= minScroll && adjMY <= minScroll || this.previousY >= this.maxScroll && adjMY >= this.maxScroll + scrollButtonHeight) {
            return;
        }
        this.scroll = this.previousY < minScroll ? (this.scroll += adjMY - minScroll) : (this.previousY > this.maxScroll ? (this.scroll += adjMY - this.maxScroll) : (this.scroll += adjMY - this.previousY));
        if (this.scroll < minScroll) {
            this.scroll = minScroll;
        } else if (this.scroll > this.maxScroll) {
            this.scroll = this.maxScroll;
        }
        this.updateSlots();
        this.previousY = adjMY;
    }

    public void updateSlots() {
        int startSlot = this.getStartingRow() * this.columns;
        int endSlot = startSlot + ConfigHandler.MAX_SIZE;
        int x = 0;
        int y = 18;
        for (int i = 0; i < this.container.playerInvStart; ++i) {
            if (i < startSlot || i >= endSlot) {
                ((Slot)this.container.field_75151_b.get((int)i)).field_75221_f = -(this.field_146295_m * 2);
                continue;
            }
            ((Slot)this.container.field_75151_b.get((int)i)).field_75221_f = y;
            if (++x < this.columns) continue;
            x = 0;
            y += 18;
        }
    }

    protected void func_146286_b(int mX, int mY, int which) {
        if (which != 0 || !this.scrolling || !this.canScroll) {
            super.func_146286_b(mX, mY, which);
            return;
        }
        this.scrolling = false;
        this.previousY = this.scroll;
    }

    public void func_146274_d() {
        super.func_146274_d();
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (!this.canScroll) {
            return;
        }
        Slot s = this.getSlot(x, y);
        if (s != null && s.func_75216_d()) {
            return;
        }
        int i = Mouse.getEventDWheel();
        int maxRows = (int)Math.ceil((float)this.container.playerInvStart / (float)this.columns);
        int scrollSize = (int)Math.ceil((this.maxScroll - minScroll) / maxRows);
        if (i > 0) {
            this.scroll -= scrollSize;
        } else if (i < 0) {
            this.scroll += scrollSize;
        }
        if (this.scroll < minScroll) {
            this.scroll = minScroll;
        } else if (this.scroll > this.maxScroll) {
            this.scroll = this.maxScroll;
        }
        this.updateSlots();
    }

    protected Slot getSlot(int mouseX, int mouseY) {
        List slots = this.field_147002_h.field_75151_b;
        for (Slot slot : slots) {
            if (!this.func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY)) continue;
            return slot;
        }
        return null;
    }
}

