/*
 * Decompiled with CFR 0.152.
 */
package yuuto.enhancedinventories.client;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelChest;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import yuuto.enhancedinventories.ColorHelper;
import yuuto.enhancedinventories.EInventoryMaterial;
import yuuto.enhancedinventories.EnhancedInventories;
import yuuto.enhancedinventories.WoodTypes;

public class RendererImprovedChestItem
implements IItemRenderer {
    private static ModelChest modelChest = new ModelChest();
    static ResourceLocation singleChestFrame = new ResourceLocation("enhancedinventories", "textures/uvs/normalChestFrame.png");
    static ResourceLocation singleChestWool = new ResourceLocation("enhancedinventories", "textures/uvs/normalChestWool.png");
    static ResourceLocation singleRefinedLocation;
    static Minecraft mc;

    public RendererImprovedChestItem() {
        if (EnhancedInventories.refinedRelocation) {
            singleRefinedLocation = new ResourceLocation("enhancedinventories", "textures/uvs/refinedRelocation/normalChest.png");
        }
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        switch (type) {
            case ENTITY: {
                return helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION || helper == IItemRenderer.ItemRendererHelper.BLOCK_3D;
            }
            case EQUIPPED: {
                return helper == IItemRenderer.ItemRendererHelper.BLOCK_3D || helper == IItemRenderer.ItemRendererHelper.EQUIPPED_BLOCK;
            }
            case EQUIPPED_FIRST_PERSON: {
                return helper == IItemRenderer.ItemRendererHelper.EQUIPPED_BLOCK;
            }
            case INVENTORY: {
                return helper == IItemRenderer.ItemRendererHelper.INVENTORY_BLOCK;
            }
        }
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glEnable((int)3042);
        switch (type) {
            case ENTITY: {
                this.renderItem(item, 0.0f, 0.0f, 0.0f, 0);
                this.renderItem(item, 0.0f, 0.0f, 0.0f, 1);
                this.renderItem(item, 0.0f, 0.0f, 0.0f, 2);
                break;
            }
            case EQUIPPED: {
                this.renderItem(item, 0.0f, 0.0f, 0.0f, 0);
                this.renderItem(item, 0.0f, 0.0f, 0.0f, 1);
                this.renderItem(item, 0.0f, 0.0f, 0.0f, 2);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderItem(item, 0.0f, 0.0f, 0.0f, 0);
                this.renderItem(item, 0.0f, 0.0f, 0.0f, 1);
                this.renderItem(item, 0.0f, 0.0f, 0.0f, 2);
                break;
            }
            case INVENTORY: {
                this.renderItem(item, 0.0f, 0.0f, 0.0f, 0);
                this.renderItem(item, 0.0f, 0.0f, 0.0f, 1);
                this.renderItem(item, 0.0f, 0.0f, 0.0f, 2);
                break;
            }
        }
        GL11.glDisable((int)3042);
    }

    public void renderItem(ItemStack item, float x, float y, float z, int pass) {
        String wood = "wood:minecraft:planks:0";
        int wool = 0;
        EInventoryMaterial mat = EInventoryMaterial.values()[item.func_77960_j()];
        if (item.func_77942_o()) {
            if (item.func_77978_p().func_74764_b("woodType")) {
                wood = item.func_77978_p().func_74779_i("woodType");
            }
            wool = item.func_77978_p().func_74762_e("wool");
        }
        int i = 5;
        GL11.glPushMatrix();
        switch (pass) {
            case 0: {
                RendererImprovedChestItem.mc.field_71446_o.func_110577_a(WoodTypes.getWoodType(wood).getTexture(2));
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                break;
            }
            case 1: {
                Color c = ColorHelper.WOOL_COLORS[wool];
                GL11.glColor4f((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)1.0f);
                RendererImprovedChestItem.mc.field_71446_o.func_110577_a(singleChestWool);
                break;
            }
            case 2: {
                if (mat.hasTexture()) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RendererImprovedChestItem.mc.field_71446_o.func_110577_a(mat.getTexture(0));
                    break;
                }
                GL11.glColor4f((float)mat.r(), (float)mat.g(), (float)mat.b(), (float)1.0f);
                RendererImprovedChestItem.mc.field_71446_o.func_110577_a(singleChestFrame);
                break;
            }
            case 3: {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RendererImprovedChestItem.mc.field_71446_o.func_110577_a(singleRefinedLocation);
            }
        }
        GL11.glTranslatef((float)x, (float)(y + 1.0f), (float)(z + 1.0f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        int short1 = 0;
        if (i == 2) {
            short1 = 180;
        }
        if (i == 3) {
            short1 = 0;
        }
        if (i == 4) {
            short1 = 90;
        }
        if (i == 5) {
            short1 = -90;
        }
        GL11.glRotatef((float)short1, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        modelChest.func_78231_a();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        mc = Minecraft.func_71410_x();
    }
}

