/*
 * Decompiled with CFR 0.152.
 */
package yuuto.enhancedinventories.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import yuuto.enhancedinventories.EInventoryMaterial;
import yuuto.enhancedinventories.EnhancedInventories;
import yuuto.enhancedinventories.WoodTypes;
import yuuto.enhancedinventories.compat.refinedrelocation.SortingUpgradeHelper;
import yuuto.enhancedinventories.compat.refinedrelocation.TileSortingLocker;
import yuuto.enhancedinventories.tile.TileConnectiveInventory;
import yuuto.yuutolib.utill.InventoryWrapper;

public class TileLocker
extends TileConnectiveInventory {
    public static ArrayList<ForgeDirection> conDirs = new ArrayList();
    static ArrayList<ForgeDirection> topDirs = new ArrayList();
    public String woodType = "wood:minecraft:planks:0";
    public boolean hopper;
    public boolean alt;
    public boolean reversed;
    public boolean sortingChest;
    int timer = 20;

    public TileLocker() {
    }

    public TileLocker(EInventoryMaterial type) {
        super(type);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("wood")) {
            int w = nbttagcompound.func_74762_e("wood");
            ItemStack stack = new ItemStack(Blocks.field_150344_f, 1, w);
            this.woodType = WoodTypes.getId(stack);
        } else {
            this.woodType = nbttagcompound.func_74779_i("woodType");
        }
        this.hopper = nbttagcompound.func_74767_n("hopper");
        this.alt = nbttagcompound.func_74767_n("alt");
        this.reversed = nbttagcompound.func_74767_n("reversed");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74778_a("woodType", this.woodType);
        nbttagcompound.func_74757_a("hopper", this.hopper);
        nbttagcompound.func_74757_a("alt", this.alt);
        nbttagcompound.func_74757_a("reversed", this.reversed);
    }

    @Override
    public boolean isValidForConnection(ItemStack itemBlock) {
        if (!this.sortingChest && itemBlock.func_77973_b() != Item.func_150898_a((Block)EnhancedInventories.locker)) {
            return false;
        }
        if (this.sortingChest && itemBlock.func_77973_b() != Item.func_150898_a((Block)EnhancedInventories.sortingLocker)) {
            return false;
        }
        if (itemBlock.func_77960_j() != this.getType().ordinal()) {
            return false;
        }
        if (!this.woodType.matches(itemBlock.func_77978_p().func_74779_i("woodType"))) {
            return false;
        }
        if (this.hopper != itemBlock.func_77978_p().func_74767_n("hopper")) {
            return false;
        }
        if (this.alt != itemBlock.func_77978_p().func_74767_n("alt")) {
            return false;
        }
        return this.redstone == itemBlock.func_77978_p().func_74767_n("redstone");
    }

    @Override
    public boolean isValidForConnection(TileConnectiveInventory tile) {
        if (!(tile instanceof TileLocker)) {
            return false;
        }
        TileLocker chest = (TileLocker)tile;
        if (chest.getType() != this.getType()) {
            return false;
        }
        if (!this.woodType.matches(chest.woodType)) {
            return false;
        }
        if (this.hopper != chest.hopper) {
            return false;
        }
        if (this.alt != chest.alt) {
            return false;
        }
        if (this.redstone != chest.redstone) {
            return false;
        }
        if (this.reversed != chest.reversed) {
            return false;
        }
        return this.sortingChest == chest.sortingChest;
    }

    @Override
    public List<ForgeDirection> getValidConnectionSides() {
        return conDirs;
    }

    @Override
    public List<ForgeDirection> getTopSides() {
        return topDirs;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.timer;
        if (this.timer > 0) {
            return;
        }
        this.timer = 20;
        if (this.hopper) {
            ForgeDirection target = this.orientation.getRotation(ForgeDirection.UP);
            if (this.reversed) {
                target = target.getOpposite();
            }
            this.suckItems(target);
            this.pushItems(target.getOpposite());
        }
    }

    public void suckItems(ForgeDirection target) {
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + target.offsetX, this.field_145848_d + target.offsetY, this.field_145849_e + target.offsetZ);
        if (tile == null || !(tile instanceof IInventory)) {
            return;
        }
        ISidedInventory inv = InventoryWrapper.getWrapper((IInventory)tile);
        ISidedInventory tar = InventoryWrapper.getWrapper(this);
        int[] slots = inv.func_94128_d(target.getOpposite().ordinal());
        for (int i = 0; i < slots.length; ++i) {
            if (inv.func_70301_a(slots[i]) == null || inv.func_70301_a((int)slots[i]).field_77994_a < 1 || !inv.func_102008_b(slots[i], inv.func_70301_a(slots[i]), target.getOpposite().ordinal()) || !this.mergeStack(inv, slots[i], tar, target)) continue;
            inv.func_70296_d();
            tar.func_70296_d();
            break;
        }
    }

    public void pushItems(ForgeDirection target) {
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + target.offsetX, this.field_145848_d + target.offsetY, this.field_145849_e + target.offsetZ);
        if (tile == null || !(tile instanceof IInventory)) {
            return;
        }
        ISidedInventory tar = InventoryWrapper.getWrapper((IInventory)tile);
        ISidedInventory inv = InventoryWrapper.getWrapper(this);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null || inv.func_70301_a((int)i).field_77994_a < 1 || !this.mergeStack(inv, i, tar, target.getOpposite())) continue;
            inv.func_70296_d();
            tar.func_70296_d();
            break;
        }
    }

    public boolean mergeStack(ISidedInventory src, int srcSlot, ISidedInventory target, ForgeDirection dir) {
        ItemStack stack = src.func_70301_a(srcSlot);
        int[] slots = target.func_94128_d(dir.ordinal());
        for (int i = 0; i < slots.length; ++i) {
            ItemStack tStack;
            if (!target.func_102007_a(slots[i], stack, dir.ordinal()) || (tStack = target.func_70301_a(slots[i])) != null && (tStack.field_77994_a == tStack.func_77976_d() || tStack.field_77994_a == target.func_70297_j_())) continue;
            if (tStack == null) {
                target.func_70299_a(slots[i], src.func_70298_a(srcSlot, stack.field_77994_a));
                return true;
            }
            if (tStack.func_77973_b() != stack.func_77973_b() || tStack.func_77960_j() != stack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)tStack)) continue;
            int max = stack.func_77976_d();
            if (target.func_70297_j_() < max) {
                max = target.func_70297_j_();
            }
            if (stack.field_77994_a < (max -= tStack.field_77994_a)) {
                max = stack.field_77994_a;
            }
            if (max == 0) continue;
            tStack.field_77994_a += src.func_70298_a((int)srcSlot, (int)max).field_77994_a;
            return true;
        }
        return false;
    }

    @Override
    public TileLocker getUpgradeTile(ItemStack stack) {
        if (stack.func_77973_b() == EnhancedInventories.sizeUpgrade) {
            TileLocker ret = new TileLocker(EInventoryMaterial.values()[stack.func_77960_j() + 1]);
            ret.woodType = this.woodType;
            ret.alt = this.alt;
            ret.hopper = this.hopper;
            ret.redstone = this.redstone;
            ret.reversed = this.reversed;
            ret.setOrientation(this.orientation);
            if (ret.getType() == this.getType()) {
                return this;
            }
            return ret;
        }
        if (stack.func_77973_b() == EnhancedInventories.functionUpgrade) {
            TileLocker ret = new TileLocker(this.getType());
            ret.woodType = this.woodType;
            ret.alt = this.alt;
            ret.hopper = this.hopper;
            ret.redstone = this.redstone;
            ret.reversed = this.reversed;
            ret.setOrientation(this.orientation);
            switch (stack.func_77960_j()) {
                case 1: {
                    if (ret.hopper) {
                        return this;
                    }
                    ret.hopper = true;
                    break;
                }
                case 2: {
                    if (ret.redstone) {
                        return this;
                    }
                    ret.redstone = true;
                    break;
                }
                default: {
                    return this;
                }
            }
            return ret;
        }
        if (EnhancedInventories.refinedRelocation && stack.func_77973_b() == SortingUpgradeHelper.getUpgradeItem()) {
            TileSortingLocker retChest = new TileSortingLocker(this.getType());
            retChest.woodType = this.woodType;
            retChest.alt = this.alt;
            retChest.hopper = this.hopper;
            retChest.redstone = this.redstone;
            retChest.reversed = this.reversed;
            retChest.setOrientation(this.orientation);
            return retChest;
        }
        return this;
    }

    @Override
    public boolean canUpgrade(ItemStack stack) {
        if (stack.func_77973_b() == EnhancedInventories.functionUpgrade && stack.func_77960_j() == 1 && !this.hopper) {
            return true;
        }
        if (EnhancedInventories.refinedRelocation && stack.func_77973_b() == SortingUpgradeHelper.getUpgradeItem()) {
            return true;
        }
        return super.canUpgrade(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
    }

    static {
        conDirs.add(ForgeDirection.UP);
        conDirs.add(ForgeDirection.DOWN);
        topDirs.add(ForgeDirection.DOWN);
    }
}

