/*
 * Decompiled with CFR 0.152.
 */
package yuuto.yuutolib.block.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import yuuto.yuutolib.block.IBlockMulti;
import yuuto.yuutolib.block.ModBlockContainer;
import yuuto.yuutolib.block.tile.IRotatable;
import yuuto.yuutolib.block.tile.TileMachine;

public abstract class ModBlockMachineMulti2
extends ModBlockContainer
implements IBlockMulti {
    protected String[] subNames;
    protected IIcon[][] icons;

    public ModBlockMachineMulti2(Material mat, CreativeTabs tab, String mod, String unlocName, String ... subNames) {
        super(mat, tab, mod, unlocName);
        this.subNames = subNames;
        this.icons = new IIcon[subNames.length][3];
    }

    @Override
    public String getUnlocalizedName(int meta) {
        return this.func_149739_a() + this.subNames[meta];
    }

    @Override
    public String[] getUnlocalizedNames() {
        String[] ret = new String[this.subNames.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getUnlocalizedName(i);
        }
        return ret;
    }

    @Override
    public String[] getSubNames() {
        return this.subNames;
    }

    @Override
    public String getTextureName(int meta) {
        return this.func_149641_N() + this.subNames[meta];
    }

    @Override
    public String[] getTextureNames() {
        String[] ret = new String[this.subNames.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getTextureName(i);
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a(this.func_149641_N());
        for (int i = 0; i < this.subNames.length; ++i) {
            this.icons[i][0] = reg.func_94245_a(this.getTextureName(i));
            this.icons[i][1] = reg.func_94245_a(this.getTextureName(i) + "FrontInactive");
            this.icons[i][2] = reg.func_94245_a(this.getTextureName(i) + "FrontActive");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess bAcess, int x, int y, int z, int side) {
        TileEntity tile = bAcess.func_147438_o(x, y, z);
        if (tile instanceof TileMachine) {
            TileMachine m = (TileMachine)tile;
            if (m.getOrientation().ordinal() != side) {
                return this.getPlacedIcon(0, bAcess.func_72805_g(x, y, z));
            }
            if (m.isActive()) {
                return this.getPlacedIcon(2, bAcess.func_72805_g(x, y, z));
            }
            return this.getPlacedIcon(1, bAcess.func_72805_g(x, y, z));
        }
        return this.func_149691_a(side, bAcess.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta < 0 || meta >= this.icons.length) {
            return this.field_149761_L;
        }
        if (side == 4) {
            return this.icons[meta][1];
        }
        return this.icons[meta][0];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getPlacedIcon(int side, int meta) {
        if (meta < 0 || meta >= this.icons.length) {
            return this.field_149761_L;
        }
        if (side < 0 || side >= this.icons[meta].length) {
            return this.field_149761_L;
        }
        return this.icons[meta][side];
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = worldObj.func_147438_o(x, y, z);
        if (!(tile instanceof IRotatable)) {
            return false;
        }
        if (axis != ForgeDirection.UP && axis != ForgeDirection.DOWN) {
            return false;
        }
        ((IRotatable)tile).rotateAround(axis);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List subItems) {
        for (int ix = 0; ix < this.subNames.length; ++ix) {
            subItems.add(new ItemStack((Block)this, 1, ix));
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase p_149689_5_, ItemStack p_149689_6_) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof IRotatable)) {
            return;
        }
        int l = MathHelper.func_76128_c((double)((double)(p_149689_5_.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            ((IRotatable)tile).setOrientation(ForgeDirection.getOrientation((int)2));
        } else if (l == 1) {
            ((IRotatable)tile).setOrientation(ForgeDirection.getOrientation((int)5));
        } else if (l == 2) {
            ((IRotatable)tile).setOrientation(ForgeDirection.getOrientation((int)3));
        } else if (l == 3) {
            ((IRotatable)tile).setOrientation(ForgeDirection.getOrientation((int)4));
        }
    }
}

