/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.componentguis;

import com.brandon3055.draconicevolution.client.gui.componentguis.GUIToolInventory;
import com.brandon3055.draconicevolution.client.gui.guicomponents.ComponentBase;
import com.brandon3055.draconicevolution.client.gui.guicomponents.ComponentButton;
import com.brandon3055.draconicevolution.client.gui.guicomponents.ComponentCollection;
import com.brandon3055.draconicevolution.client.gui.guicomponents.ComponentConfigItemButton;
import com.brandon3055.draconicevolution.client.gui.guicomponents.ComponentFieldAdjuster;
import com.brandon3055.draconicevolution.client.gui.guicomponents.ComponentFieldButton;
import com.brandon3055.draconicevolution.client.gui.guicomponents.ComponentItemRenderer;
import com.brandon3055.draconicevolution.client.gui.guicomponents.ComponentTexturedRect;
import com.brandon3055.draconicevolution.client.gui.guicomponents.GUIBase;
import com.brandon3055.draconicevolution.common.container.ContainerAdvTool;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.utills.IConfigurableItem;
import com.brandon3055.draconicevolution.common.utills.IInventoryTool;
import com.brandon3055.draconicevolution.common.utills.ItemConfigField;
import com.brandon3055.draconicevolution.common.utills.LogHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class GUIToolConfig
extends GUIBase {
    public EntityPlayer player;
    private static final ResourceLocation inventoryTexture = new ResourceLocation(References.RESOURCESPREFIX + "textures/gui/ToolConfig.png");
    private int screenLevel = 0;
    private ItemStack editingItem;
    private ContainerAdvTool container;
    private boolean draggingHud = false;

    public GUIToolConfig(EntityPlayer player, ContainerAdvTool container) {
        super(container, 198, 89);
        this.container = container;
        this.player = player;
        container.setSlotsActive(false);
        this.addDependentComponents();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
    }

    @Override
    protected ComponentCollection assembleComponents() {
        ComponentCollection c = new ComponentCollection(0, 0, this.field_146999_f, this.field_147000_g, this);
        c.addComponent(new ComponentTexturedRect(0, 0, 198, 89, inventoryTexture)).setGroup("BACKGROUND");
        c.addComponent(new ComponentButton(3, 26, 20, 12, 0, this, "<=", "Back")).setGroup("BUTTONS").setName("BACK_BUTTON");
        c.addComponent(new ComponentButton(3, 39, 20, 12, 1, this, "Inv", "Item Inventory")).setGroup("BUTTONS").setName("INVENTORY_BUTTON");
        c.addComponent(new ComponentFieldAdjuster(4, 34, null, this)).setGroup("FIELD_BUTTONS").setName("FIELD_CONFIG_BUTTON_ARRAY");
        return c;
    }

    @Override
    protected void addDependentComponents() {
        int y;
        for (int x = 0; x < 9; ++x) {
            this.collection.addComponent(new ComponentConfigItemButton(29 + 18 * x, 64, x, this.player)).setGroup("INV_SCREEN");
        }
        for (y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.collection.addComponent(new ComponentConfigItemButton(29 + 18 * x, 7 + y * 18, x + y * 9 + 9, this.player)).setGroup("INV_SCREEN");
            }
        }
        for (y = 0; y < 4; ++y) {
            this.collection.addComponent(new ComponentConfigItemButton(6, 7 + y * 19, 39 - y, this.player)).setGroup("INV_SCREEN");
        }
        this.setLevel(0);
    }

    public void updateItemButtons() {
        LogHelper.info("Update Buttons");
        for (ComponentBase component : this.collection.getComponents()) {
            if (!(component instanceof ComponentConfigItemButton)) continue;
            ((ComponentConfigItemButton)component).refreshState();
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        if (!this.collection.isMouseOver(x - this.field_147003_i, y - this.field_147009_r)) {
            this.draggingHud = true;
            int x1 = (int)((float)x / (float)this.field_146294_l * 1000.0f);
            int y1 = (int)((float)y / (float)this.field_146295_m * 1000.0f);
            ConfigHandler.hudX = x1;
            ConfigHandler.hudY = y1;
        }
        if (this.buttonPressed) {
            return;
        }
        int fieldOffsetX = 24;
        int fieldOffsetY = 5;
        for (ComponentBase component : this.collection.getComponents()) {
            if (!component.isEnabled() || !(component instanceof ComponentConfigItemButton) || !component.isMouseOver(x - this.field_147003_i, y - this.field_147009_r) || !((ComponentConfigItemButton)component).hasValidItem) continue;
            ItemStack stack = this.player.field_71071_by.func_70301_a(((ComponentConfigItemButton)component).slot);
            if (stack == null || !(stack.func_77973_b() instanceof IConfigurableItem)) {
                return;
            }
            this.buttonPressed = true;
            IConfigurableItem item = (IConfigurableItem)stack.func_77973_b();
            this.setEditingItem(stack, ((ComponentConfigItemButton)component).slot);
            this.setLevel(1);
            for (ItemConfigField field : item.getFields(stack, ((ComponentConfigItemButton)component).slot)) {
                this.collection.addComponent(new ComponentFieldButton(fieldOffsetX, fieldOffsetY, this.player, field, this)).setGroup("LIST_SCREEN");
                fieldOffsetY += 12;
            }
            this.collection.addComponent(new ComponentItemRenderer(3, 5, stack)).setGroup("LIST_SCREEN");
            break;
        }
    }

    @Override
    protected void func_146273_a(int x, int y, int button, long time) {
        super.func_146273_a(x, y, button, time);
        if (this.draggingHud) {
            int x1 = (int)((float)x / (float)this.field_146294_l * 1000.0f);
            int y1 = (int)((float)y / (float)this.field_146295_m * 1000.0f);
            ConfigHandler.hudX = x1;
            ConfigHandler.hudY = y1;
        }
    }

    @Override
    protected void func_146286_b(int x, int y, int button) {
        super.func_146286_b(x, y, button);
        if (this.draggingHud) {
            this.draggingHud = false;
            ConfigHandler.config.get("general", "Hud Display X pos", 7).set(ConfigHandler.hudX);
            ConfigHandler.config.get("general", "Hud Display Y pos", 874).set(ConfigHandler.hudY);
            ConfigHandler.config.save();
        }
    }

    @Override
    public void buttonClicked(int id, int button) {
        super.buttonClicked(id, button);
        if (id == 0 && this.screenLevel > 0) {
            this.setLevel(this.screenLevel - 1);
        } else if (id == 1 && this.editingItem != null) {
            this.setLevel(3);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GUIToolInventory(this.player, this.container, this));
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"info.de.hudDisplayConfigInfo1.txt") + " " + StatCollector.func_74838_a((String)"info.de.hudDisplayConfigInfo2.txt"), 0, 91, 0xFFFFFF);
    }

    public void setLevel(int level) {
        this.screenLevel = level;
        if (level == 0) {
            this.collection.schedulRemoval("LIST_SCREEN");
            this.collection.setOnlyGroupEnabled("INV_SCREEN");
            this.collection.setGroupEnabled("BACKGROUND", true);
            this.collection.setComponentEnabled("BACK_BUTTON", false);
        } else if (level == 1) {
            this.collection.setOnlyGroupEnabled("LIST_SCREEN");
            this.collection.setGroupEnabled("BACKGROUND", true);
            this.collection.setComponentEnabled("BACK_BUTTON", true);
            if (this.editingItem != null && this.editingItem.func_77973_b() instanceof IInventoryTool) {
                this.collection.setComponentEnabled("INVENTORY_BUTTON", true);
            }
            if (this.collection.getComponent("BACK_BUTTON") != null) {
                this.collection.getComponent("BACK_BUTTON").setY(26);
            }
        } else if (level == 2) {
            this.collection.setOnlyGroupEnabled("FIELD_BUTTONS");
            this.collection.setGroupEnabled("BACKGROUND", true);
            this.collection.setComponentEnabled("BACK_BUTTON", true);
            if (this.collection.getComponent("BACK_BUTTON") != null) {
                this.collection.getComponent("BACK_BUTTON").setY(3);
            }
        } else if (level == 3) {
            // empty if block
        }
    }

    public void setFieldBeingEdited(ItemConfigField field) {
        ((ComponentFieldAdjuster)this.collection.getComponent((String)"FIELD_CONFIG_BUTTON_ARRAY")).field = field;
        this.setLevel(2);
    }

    public void setEditingItem(ItemStack stack, int slot) {
        this.editingItem = stack;
        this.container.updateInventoryStack(slot);
    }
}

