/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.handler;

import com.brandon3055.draconicevolution.client.gui.componentguis.GUIManual;
import com.brandon3055.draconicevolution.client.utill.CustomResourceLocation;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.utills.LogHelper;
import com.google.common.io.ByteStreams;
import com.google.gson.stream.JsonWriter;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.util.ResourceLocation;

public class ResourceHandler {
    public static ResourceHandler instance = new ResourceHandler();
    private static ResourceLocation defaultParticles;
    private static ResourceLocation particles;
    private static Map<String, ResourceLocation> cachedResources;
    public static Map<String, CustomResourceLocation> downloadedImages;
    private static String savePath;
    private static File saveFolder;
    private static File imagesFolder;
    private static DownloadThread downloadThread;
    public static int downloadStatus;

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (downloadThread != null && downloadThread.isFinished) {
            if (downloadThread.isReloadRequired()) {
                LogHelper.info("Image Download Finished");
            }
            downloadStatus = downloadThread.wasSuccessful ? 1 : 2;
            FMLCommonHandler.instance().bus().unregister((Object)this);
            ResourceHandler.addRSPack(event != null);
            downloadThread = null;
        }
    }

    public static void init(FMLPreInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)instance);
        if (event != null) {
            savePath = event.getModConfigurationDirectory().getParentFile().getAbsolutePath() + "/config/draconicevolution";
        }
        GUIManual.loadPages();
        downloadThread = new DownloadThread(GUIManual.imageURLs);
        downloadThread.start();
    }

    private static void addRSPack(boolean refreash) {
        File rspack = new File(ResourceHandler.getConfigFolder(), "/resources");
        if (!rspack.exists()) {
            return;
        }
        if (!Arrays.asList(rspack.list()).contains("pack.mcmeta")) {
            try {
                JsonWriter writer = new JsonWriter((Writer)new FileWriter(new File(rspack, "pack.mcmeta")));
                writer.beginObject();
                writer.name("pack");
                writer.beginObject();
                writer.name("pack_format").value(1L);
                writer.name("description").value("Draconic Evolution GUI Images");
                writer.endObject();
                writer.endObject();
                writer.close();
            }
            catch (IOException e) {
                LogHelper.error("Error creating pack.mcmeta");
                e.printStackTrace();
            }
        }
        Field f = ReflectionHelper.findField(Minecraft.class, (String[])new String[]{"defaultResourcePacks", "field_110449_ao"});
        f.setAccessible(true);
        try {
            List defaultResourcePacks = (List)f.get(Minecraft.func_71410_x());
            defaultResourcePacks.add(new FolderResourcePack(rspack));
            f.set(Minecraft.func_71410_x(), defaultResourcePacks);
            LogHelper.info("RS Added");
            if (refreash) {
                Minecraft.func_71410_x().func_110436_a();
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static File getConfigFolder() {
        if (saveFolder == null) {
            saveFolder = new File(savePath);
        }
        if (!saveFolder.exists()) {
            saveFolder.mkdir();
        }
        return saveFolder;
    }

    public static File getImagesFolder() {
        if (imagesFolder == null) {
            imagesFolder = new File(ResourceHandler.getConfigFolder(), "/resources/assets/draconicevolution/textures/gui/manualimages");
        }
        if (!imagesFolder.exists()) {
            imagesFolder.mkdirs();
        }
        return imagesFolder;
    }

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public static void bindDefaultParticles() {
        if (defaultParticles == null) {
            try {
                defaultParticles = (ResourceLocation)ReflectionHelper.getPrivateValue(EffectRenderer.class, null, (String[])new String[]{"particleTextures", "field_110737_b"});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (defaultParticles != null) {
            ResourceHandler.bindTexture(defaultParticles);
        }
    }

    public static void bindParticles() {
        ResourceHandler.bindTexture(particles);
    }

    public static ResourceLocation getResource(String rs) {
        if (!cachedResources.containsKey(rs)) {
            cachedResources.put(rs, new ResourceLocation(References.RESOURCESPREFIX + rs));
        }
        return cachedResources.get(rs);
    }

    public static void bindResource(String rs) {
        ResourceHandler.bindTexture(ResourceHandler.getResource(rs));
    }

    static {
        particles = new ResourceLocation(References.RESOURCESPREFIX + "textures/particle/particles.png");
        cachedResources = new HashMap<String, ResourceLocation>();
        downloadedImages = new HashMap<String, CustomResourceLocation>();
        downloadStatus = 0;
    }

    public static class DownloadThread
    extends Thread {
        private List<String> imageURLs;
        private boolean isFinished = false;
        private boolean wasSuccessful = true;
        private boolean reloadRequired = false;

        public DownloadThread(List<String> imageURLs) {
            this.imageURLs = new ArrayList<String>(imageURLs);
        }

        @Override
        public void run() {
            for (String s : this.imageURLs) {
                LogHelper.info("Checking Image: " + s);
                if (!DownloadThread.checkExistence(s) && DownloadThread.downloadImage(s)) {
                    this.reloadRequired = true;
                }
                if (!DownloadThread.checkExistence(s)) continue;
                try {
                    URL url = new URL(s);
                    String fileName = url.getFile();
                    BufferedImage bi = ImageIO.read(new File(ResourceHandler.getImagesFolder(), fileName));
                    downloadedImages.put(s, new CustomResourceLocation(fileName.substring(fileName.indexOf("/") + 1), bi.getWidth(), bi.getHeight()));
                }
                catch (MalformedURLException e) {
                    LogHelper.error("Image Read Failed");
                    e.printStackTrace();
                }
                catch (IOException e) {
                    LogHelper.error("Image Read Failed");
                    e.printStackTrace();
                }
            }
            this.isFinished = true;
        }

        private static boolean downloadImage(String urlString) {
            try {
                URL url = new URL(urlString);
                String fileName = url.getFile();
                LogHelper.info("Downloading Image " + fileName);
                File dll = new File(ResourceHandler.getImagesFolder(), fileName);
                InputStream is = url.openStream();
                FileOutputStream os = new FileOutputStream(dll);
                ByteStreams.copy((InputStream)is, (OutputStream)os);
                is.close();
                ((OutputStream)os).close();
            }
            catch (IOException e) {
                LogHelper.error("Download Failed");
                e.printStackTrace();
                return false;
            }
            return true;
        }

        private static boolean checkExistence(String urlS) {
            try {
                URL url = new URL(urlS);
                String fileName = url.getFile();
                return Arrays.asList(ResourceHandler.getImagesFolder().list()).contains(fileName.substring(fileName.indexOf("/") + 1));
            }
            catch (MalformedURLException e) {
                LogHelper.error("Unable to check files existence. Invalid URL: " + urlS);
                e.printStackTrace();
                return false;
            }
        }

        public boolean isFinished() {
            return this.isFinished;
        }

        public boolean wasSuccessful() {
            return this.wasSuccessful;
        }

        public boolean isReloadRequired() {
            return this.reloadRequired;
        }
    }
}

