/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.tools;

import cofh.api.energy.IEnergyContainerItem;
import com.brandon3055.brandonscore.common.utills.InfoHelper;
import com.brandon3055.brandonscore.common.utills.ItemNBTHelper;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.common.lib.References;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;

public class DraconicHoe
extends ItemHoe
implements IEnergyContainerItem {
    protected int capacity = 10000000;
    protected int maxReceive = 50000;
    protected int maxExtract = 50000;

    public DraconicHoe() {
        super(ModItems.DRACONIUM_T1);
        this.func_77655_b("draconicHoe");
        this.func_77637_a(DraconicEvolution.tabToolsWeapons);
        if (ModItems.isEnabled((Item)this)) {
            GameRegistry.registerItem((Item)this, (String)"draconicHoe");
        }
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(ItemNBTHelper.setInteger((ItemStack)new ItemStack(item, 1, 0), (String)"Energy", (int)0));
        list.add(ItemNBTHelper.setInteger((ItemStack)new ItemStack(item, 1, 0), (String)"Energy", (int)this.capacity));
    }

    public String func_77658_a() {
        return String.format("item.%s%s", "DraconicEvolution".toLowerCase() + ":", super.func_77658_a().substring(super.func_77658_a().indexOf(".") + 1));
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconic_hoe");
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        boolean successfull = false;
        Block clicked = world.func_147439_a(x, y, z);
        if (!player.func_70093_af() && player.func_82247_a(x, y, z, par7, stack) && (clicked == Blocks.field_150346_d || clicked == Blocks.field_150349_c || clicked == Blocks.field_150458_ak) && par7 == 1) {
            int size = 4;
            for (int x1 = -size; x1 <= size; ++x1) {
                for (int z1 = -size; z1 <= size; ++z1) {
                    Block block;
                    Block topBlock2;
                    if (!(stack.func_77973_b() instanceof IEnergyContainerItem && ((IEnergyContainerItem)stack.func_77973_b()).getEnergyStored(stack) >= 80 || player.field_71075_bZ.field_75098_d)) {
                        return false;
                    }
                    Block topBlock = world.func_147439_a(x + x1, y + 1, z + z1);
                    if (topBlock.isReplaceable((IBlockAccess)world, x + x1, y + 1, z + z1)) {
                        world.func_147468_f(x + x1, y + 1, z + z1);
                    }
                    if ((topBlock2 = world.func_147439_a(x + x1, y + 2, z + z1)).isReplaceable((IBlockAccess)world, x + x1, y + 2, z + z1)) {
                        world.func_147468_f(x + x1, y + 2, z + z1);
                    }
                    if ((block = world.func_147439_a(x + x1, y, z + z1)).isReplaceable((IBlockAccess)world, x + x1, y, z + z1) && !block.func_149688_o().equals(Material.field_151586_h)) {
                        world.func_147468_f(x + x1, y, z + z1);
                    }
                    if (world.func_147439_a(x + x1, y, z + z1) == Blocks.field_150350_a && world.func_147439_a(x + x1, y - 1, z + z1).func_149747_d((IBlockAccess)world, x, y, z, 1) && (player.field_71071_by.func_146028_b(Item.func_150898_a((Block)Blocks.field_150346_d)) || player.field_71075_bZ.field_75098_d)) {
                        world.func_147449_b(x + x1, y, z + z1, Blocks.field_150346_d);
                        player.field_71071_by.func_146026_a(Item.func_150898_a((Block)Blocks.field_150346_d));
                    }
                    if ((world.func_147439_a(x + x1, y + 1, z + z1) == Blocks.field_150346_d || world.func_147439_a(x + x1, y + 1, z + z1) == Blocks.field_150349_c || world.func_147439_a(x + x1, y + 1, z + z1) == Blocks.field_150458_ak) && world.func_147439_a(x + x1, y + 2, z + z1) == Blocks.field_150350_a) {
                        if (!world.field_72995_K) {
                            world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(Item.func_150898_a((Block)Blocks.field_150346_d))));
                        }
                        world.func_147449_b(x + x1, y + 1, z + z1, Blocks.field_150350_a);
                    }
                    if (!this.hoe(stack, player, world, x + x1, y, z + z1, par7)) continue;
                    successfull = true;
                }
            }
        } else {
            successfull = this.hoe(stack, player, world, x, y, z, par7);
        }
        Block block1 = Blocks.field_150458_ak;
        if (successfull) {
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), block1.field_149762_H.func_150498_e(), (block1.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block1.field_149762_H.func_150494_d() * 0.8f);
        }
        return successfull;
    }

    private boolean hoe(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int par7) {
        if (!(stack.func_77973_b() instanceof IEnergyContainerItem) || ((IEnergyContainerItem)stack.func_77973_b()).getEnergyStored(stack) < 80) {
            if (!player.field_71075_bZ.field_75098_d) {
                return false;
            }
        } else if (!player.field_71075_bZ.field_75098_d) {
            ((IEnergyContainerItem)stack.func_77973_b()).extractEnergy(stack, 80, false);
        }
        if (!player.func_82247_a(x, y, z, par7, stack)) {
            return false;
        }
        UseHoeEvent event = new UseHoeEvent(player, stack, world, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            stack.func_77972_a(1, (EntityLivingBase)player);
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        if (par7 != 0 && world.func_147439_a(x, y + 1, z).isAir((IBlockAccess)world, x, y + 1, z) && (block == Blocks.field_150349_c || block == Blocks.field_150346_d)) {
            Block block1 = Blocks.field_150458_ak;
            if (world.field_72995_K) {
                return true;
            }
            world.func_147449_b(x, y, z, block1);
            stack.func_77972_a(1, (EntityLivingBase)player);
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean extraInformation) {
        InfoHelper.addEnergyAndLore((ItemStack)stack, (List)list);
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) != this.getMaxEnergyStored(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityPersistentItem(world, location, itemstack);
    }
}

