/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.network;

import com.brandon3055.brandonscore.common.utills.DataUtills;
import com.brandon3055.draconicevolution.common.utills.IConfigurableItem;
import com.brandon3055.draconicevolution.common.utills.ItemConfigField;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;

public class ItemConfigPacket
implements IMessage {
    public byte datatype;
    public int slot;
    public Object value;
    public String name;

    public ItemConfigPacket() {
    }

    public ItemConfigPacket(ItemConfigField field) {
        this.datatype = (byte)field.datatype;
        this.slot = field.slot;
        this.value = field.value;
        this.name = field.name;
    }

    public void fromBytes(ByteBuf bytes) {
        this.datatype = bytes.readByte();
        this.slot = bytes.readInt();
        this.name = ByteBufUtils.readUTF8String((ByteBuf)bytes);
        this.value = DataUtills.instance.readObjectFromBytes(bytes, (int)this.datatype);
    }

    public void toBytes(ByteBuf bytes) {
        bytes.writeByte((int)this.datatype);
        bytes.writeInt(this.slot);
        ByteBufUtils.writeUTF8String((ByteBuf)bytes, (String)this.name);
        DataUtills.instance.writeObjectToBytes(bytes, (int)this.datatype, this.value);
    }

    public static class Handler
    implements IMessageHandler<ItemConfigPacket, IMessage> {
        public IMessage onMessage(ItemConfigPacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (message.slot >= player.field_71071_by.func_70302_i_() || message.slot < 0) {
                return null;
            }
            ItemStack stack = player.field_71071_by.func_70301_a(message.slot);
            if (stack != null && stack.func_77973_b() instanceof IConfigurableItem) {
                DataUtills.writeObjectToItem((ItemStack)stack, (Object)message.value, (int)message.datatype, (String)message.name);
            }
            return null;
        }
    }
}

