/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities.multiblocktiles;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import com.brandon3055.draconicevolution.api.IExtendedRFStorage;
import com.brandon3055.draconicevolution.client.handler.ParticleHandler;
import com.brandon3055.draconicevolution.client.render.particle.Particles;
import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.blocks.multiblock.MultiblockHelper;
import com.brandon3055.draconicevolution.common.tileentities.TileObjectSync;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnergyStorageCore;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnergyPylon
extends TileObjectSync
implements IEnergyHandler,
IExtendedRFStorage {
    public boolean active = false;
    public boolean lastTickActive = false;
    public boolean reciveEnergy = false;
    public boolean lastTickReciveEnergy = false;
    public float modelRotation = 0.0f;
    public float modelScale = 0.0f;
    private List<MultiblockHelper.TileLocation> coreLocatios = new ArrayList<MultiblockHelper.TileLocation>();
    private int selectedCore = 0;
    private byte particleRate = 0;
    private byte lastTickParticleRate = 0;
    private int lastCheckCompOverride = 0;
    private int tick = 0;

    public void func_145845_h() {
        int cOut;
        if (this.active && this.field_145850_b.field_72995_K) {
            this.modelRotation = (float)((double)this.modelRotation + 1.5);
            this.modelScale += !this.reciveEnergy ? -0.01f : 0.01f;
            if (this.modelScale < 0.0f && !this.reciveEnergy) {
                this.modelScale = 10000.0f;
            }
            if (this.modelScale < 0.0f && this.reciveEnergy) {
                this.modelScale = 0.0f;
            }
            this.spawnParticles();
        } else if (this.field_145850_b.field_72995_K) {
            this.modelScale = 0.5f;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.tick;
        if (this.tick % 20 == 0 && (cOut = (int)(this.getEnergyStored() / this.getMaxEnergyStored() * 15.0)) != this.lastCheckCompOverride) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.field_145850_b.func_147459_d(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.field_145850_b.func_147459_d(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.lastCheckCompOverride = cOut;
        }
        if (this.active && !this.reciveEnergy) {
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + d.offsetX, this.field_145848_d + d.offsetY, this.field_145849_e + d.offsetZ);
                if (tile == null || !(tile instanceof IEnergyReceiver)) continue;
                this.extractEnergy(d, ((IEnergyReceiver)tile).receiveEnergy(d.getOpposite(), this.extractEnergy(d, Integer.MAX_VALUE, true), false), false);
            }
        }
        this.detectAndSendChanges();
        if (this.particleRate > 0) {
            this.particleRate = (byte)(this.particleRate - 1);
        }
    }

    public void onActivated() {
        if (!this.active) {
            this.active = this.isValidStructure();
        }
        this.findCores();
    }

    private TileEnergyStorageCore getMaster() {
        MultiblockHelper.TileLocation core;
        if (this.coreLocatios.isEmpty()) {
            return null;
        }
        if (this.selectedCore >= this.coreLocatios.size()) {
            this.selectedCore = this.coreLocatios.size() - 1;
        }
        if ((core = this.coreLocatios.get(this.selectedCore)) == null || !(this.field_145850_b.func_147438_o(core.getXCoord(), core.getYCoord(), core.getZCoord()) instanceof TileEnergyStorageCore)) {
            return null;
        }
        return (TileEnergyStorageCore)this.field_145850_b.func_147438_o(core.getXCoord(), core.getYCoord(), core.getZCoord());
    }

    private void findCores() {
        int yMod = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1 ? 15 : -15;
        int range = 15;
        ArrayList<MultiblockHelper.TileLocation> locations = new ArrayList<MultiblockHelper.TileLocation>();
        for (int x = this.field_145851_c - range; x <= this.field_145851_c + range; ++x) {
            for (int y = this.field_145848_d + yMod - range; y <= this.field_145848_d + yMod + range; ++y) {
                for (int z = this.field_145849_e - range; z <= this.field_145849_e + range; ++z) {
                    if (this.field_145850_b.func_147439_a(x, y, z) != ModBlocks.energyStorageCore) continue;
                    locations.add(new MultiblockHelper.TileLocation(x, y, z));
                }
            }
        }
        if (locations != this.coreLocatios) {
            this.coreLocatios.clear();
            this.coreLocatios.addAll(locations);
            this.selectedCore = this.selectedCore >= this.coreLocatios.size() ? 0 : this.selectedCore;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void nextCore() {
        this.findCores();
        ++this.selectedCore;
        if (this.selectedCore >= this.coreLocatios.size()) {
            this.selectedCore = 0;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        float disMod;
        int cYCoord;
        Random rand = this.field_145850_b.field_73012_v;
        if (this.getMaster() == null || !this.getMaster().isOnline()) {
            return;
        }
        int x = this.getMaster().field_145851_c;
        int y = this.getMaster().field_145848_d;
        int z = this.getMaster().field_145849_e;
        int n = cYCoord = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1 ? this.field_145848_d + 1 : this.field_145848_d - 1;
        float f = this.getMaster().getTier() == 0 ? 0.5f : (this.getMaster().getTier() == 1 ? 1.0f : (this.getMaster().getTier() == 2 ? 1.0f : (this.getMaster().getTier() == 3 ? 2.0f : (this.getMaster().getTier() == 4 ? 2.0f : (disMod = this.getMaster().getTier() == 5 ? 3.0f : 4.0f)))));
        if (this.particleRate > 20) {
            this.particleRate = (byte)20;
        }
        if (!this.reciveEnergy) {
            Particles.EnergyTransferParticle passiveParticle;
            double spawnX = (double)x + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
            double spawnY = (double)y + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
            double spawnZ = (double)z + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
            double targetX = (double)this.field_145851_c + 0.5;
            double targetY = (double)cYCoord + 0.5;
            double targetZ = (double)this.field_145849_e + 0.5;
            if (rand.nextFloat() < 0.05f) {
                passiveParticle = new Particles.EnergyTransferParticle(this.field_145850_b, spawnX, spawnY, spawnZ, targetX, targetY, targetZ, true);
                ParticleHandler.spawnCustomParticle(passiveParticle, 35.0);
            }
            if (this.particleRate > 0) {
                if (this.particleRate > 10) {
                    for (int i = 0; i <= this.particleRate / 10; ++i) {
                        spawnX = (double)x + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                        spawnY = (double)y + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                        spawnZ = (double)z + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                        Particles.EnergyTransferParticle passiveParticle2 = new Particles.EnergyTransferParticle(this.field_145850_b, spawnX, spawnY, spawnZ, targetX, targetY, targetZ, false);
                        ParticleHandler.spawnCustomParticle(passiveParticle2, 35.0);
                    }
                } else if (rand.nextInt(Math.max(1, 10 - this.particleRate)) == 0) {
                    spawnX = (double)x + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                    spawnY = (double)y + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                    spawnZ = (double)z + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                    passiveParticle = new Particles.EnergyTransferParticle(this.field_145850_b, spawnX, spawnY, spawnZ, targetX, targetY, targetZ, false);
                    ParticleHandler.spawnCustomParticle(passiveParticle, 35.0);
                }
            }
        } else {
            Particles.EnergyTransferParticle passiveParticle;
            double targetX = (double)x + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
            double targetY = (double)y + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
            double targetZ = (double)z + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
            double spawnX = (double)this.field_145851_c + 0.5;
            double spawnY = (double)cYCoord + 0.5;
            double spawnZ = (double)this.field_145849_e + 0.5;
            if (rand.nextFloat() < 0.05f) {
                passiveParticle = new Particles.EnergyTransferParticle(this.field_145850_b, spawnX, spawnY, spawnZ, targetX, targetY, targetZ, true);
                ParticleHandler.spawnCustomParticle(passiveParticle, 35.0);
            }
            if (this.particleRate > 0) {
                if (this.particleRate > 10) {
                    for (int i = 0; i <= this.particleRate / 10; ++i) {
                        targetX = (double)x + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                        targetY = (double)y + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                        targetZ = (double)z + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                        Particles.EnergyTransferParticle passiveParticle3 = new Particles.EnergyTransferParticle(this.field_145850_b, spawnX, spawnY, spawnZ, targetX, targetY, targetZ, false);
                        ParticleHandler.spawnCustomParticle(passiveParticle3, 35.0);
                    }
                } else if (rand.nextInt(Math.max(1, 10 - this.particleRate)) == 0) {
                    targetX = (double)x + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                    targetY = (double)y + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                    targetZ = (double)z + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                    passiveParticle = new Particles.EnergyTransferParticle(this.field_145850_b, spawnX, spawnY, spawnZ, targetX, targetY, targetZ, false);
                    ParticleHandler.spawnCustomParticle(passiveParticle, 35.0);
                }
            }
        }
    }

    private boolean isValidStructure() {
        return !(!this.isGlass(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) && !this.isGlass(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) || this.isGlass(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) && this.isGlass(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e));
    }

    private boolean isGlass(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z) == ModBlocks.invisibleMultiblock && this.field_145850_b.func_72805_g(x, y, z) == 2;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.active = compound.func_74767_n("Active");
        this.reciveEnergy = compound.func_74767_n("Input");
        int i = compound.func_74762_e("Cores");
        ArrayList<MultiblockHelper.TileLocation> list = new ArrayList<MultiblockHelper.TileLocation>();
        for (int j = 0; j < i; ++j) {
            MultiblockHelper.TileLocation l = new MultiblockHelper.TileLocation();
            l.readFromNBT(compound, "Core" + j);
            list.add(l);
        }
        this.coreLocatios = list;
        this.selectedCore = compound.func_74762_e("SelectedCore");
        this.particleRate = compound.func_74771_c("ParticleRate");
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74757_a("Active", this.active);
        compound.func_74757_a("Input", this.reciveEnergy);
        int i = this.coreLocatios.size();
        compound.func_74768_a("Cores", i);
        for (int j = 0; j < i; ++j) {
            this.coreLocatios.get(j).writeToNBT(compound, "Core" + j);
        }
        compound.func_74768_a("SelectedCore", this.selectedCore);
        compound.func_74774_a("ParticleRate", this.particleRate);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int received;
        if (this.getMaster() == null) {
            return 0;
        }
        int n = received = this.reciveEnergy ? this.getMaster().receiveEnergy(maxReceive, simulate) : 0;
        if (!simulate && received > 0) {
            this.particleRate = (byte)Math.min(20, received < 500 && received > 0 ? 1 : received / 500);
        }
        return received;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        int extracted;
        if (this.getMaster() == null || !this.getMaster().isOnline()) {
            return 0;
        }
        int n = extracted = this.reciveEnergy ? 0 : this.getMaster().extractEnergy(maxExtract, simulate);
        if (!simulate && extracted > 0) {
            this.particleRate = (byte)Math.min(20, extracted < 500 && extracted > 0 ? 1 : extracted / 500);
        }
        return extracted;
    }

    public int getEnergyStored(ForgeDirection from) {
        if (this.getMaster() == null) {
            return 0;
        }
        return (int)Math.min(Integer.MAX_VALUE, this.getMaster().getEnergyStored());
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.getMaster() == null) {
            return 0;
        }
        return (int)Math.min(Integer.MAX_VALUE, this.getMaster().getMaxEnergyStored());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    private void detectAndSendChanges() {
        if (this.lastTickActive != this.active) {
            this.lastTickActive = (Boolean)this.sendObjectToClient((byte)6, 0, this.active, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 256.0));
        }
        if (this.lastTickReciveEnergy != this.reciveEnergy) {
            this.lastTickReciveEnergy = (Boolean)this.sendObjectToClient((byte)6, 1, this.reciveEnergy, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 256.0));
        }
        if (this.lastTickParticleRate != this.particleRate) {
            this.lastTickParticleRate = (Byte)this.sendObjectToClient((byte)0, 2, this.particleRate);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void receiveObjectFromServer(int index, Object object) {
        switch (index) {
            case 0: {
                this.active = (Boolean)object;
                break;
            }
            case 1: {
                this.reciveEnergy = (Boolean)object;
                break;
            }
            case 2: {
                this.particleRate = (Byte)object;
            }
        }
    }

    @Override
    public double getEnergyStored() {
        return this.getMaster() != null ? (double)this.getMaster().getEnergyStored() : 0.0;
    }

    @Override
    public double getMaxEnergyStored() {
        return this.getMaster() != null ? (double)this.getMaster().getMaxEnergyStored() : 0.0;
    }

    @Override
    public long getExtendedStorage() {
        return this.getMaster() != null ? this.getMaster().getEnergyStored() : 0L;
    }

    @Override
    public long getExtendedCapacity() {
        return this.getMaster() != null ? this.getMaster().getMaxEnergyStored() : 0L;
    }
}

