/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.common.handlers.IProcess;
import com.brandon3055.brandonscore.common.handlers.ProcessHandler;
import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.render.particle.Particles;
import com.brandon3055.draconicevolution.common.blocks.multiblock.IIsSlave;
import com.brandon3055.draconicevolution.common.blocks.multiblock.MultiblockHelper;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.tileentities.TileObjectSync;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.ReactorExplosion;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorStabilizer;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileReactorCore
extends TileObjectSync {
    public static final int MAX_SLAVE_RANGE = 10;
    public static final int STATE_OFFLINE = 0;
    public static final int STATE_START = 1;
    public static final int STATE_ONLINE = 2;
    public static final int STATE_STOP = 3;
    public static final int STATE_INVALID = 4;
    public int reactorState = 0;
    public float renderRotation = 0.0f;
    public float renderSpeed = 0.0f;
    public boolean isStructureValid = false;
    public float stabilizerRender = 0.0f;
    private boolean startupInitialized = false;
    public int tick = 0;
    public int reactorFuel = 0;
    public int convertedFuel = 0;
    public double conversionUnit = 0.0;
    public double reactionTemperature = 20.0;
    public double maxReactTemperature = 10000.0;
    public double fieldCharge = 0.0;
    public double maxFieldCharge = 0.0;
    public int energySaturation = 0;
    public int maxEnergySaturation = 0;
    public List<MultiblockHelper.TileLocation> stabilizerLocations = new ArrayList<MultiblockHelper.TileLocation>();
    private boolean hasExploded = false;
    private boolean isStructureValidCach = false;
    private boolean startupInitializedCach = false;
    private int reactorStateCach = -1;
    private int reactorFuelCach = -1;
    private int convertedFuelCach = -1;
    private int energySaturationCach = -1;
    private int maxEnergySaturationCach = -1;
    private double reactionTemperatureCach = -1.0;
    private double maxReactTemperatureCach = -1.0;
    private double fieldChargeCach = -1.0;
    private double maxFieldChargeCach = -1.0;

    public void func_145845_h() {
        ++this.tick;
        if (this.field_145850_b.field_72995_K) {
            this.renderSpeed = (float)Math.min((this.reactionTemperature - 20.0) / 2000.0, 1.0);
            this.stabilizerRender = (float)Math.min(this.fieldCharge / (this.maxFieldCharge * 0.1), 1.0);
            this.renderRotation += this.renderSpeed;
            this.checkPlayerCollision();
            return;
        }
        switch (this.reactorState) {
            case 0: {
                this.offlineTick();
                break;
            }
            case 1: {
                this.startingTick();
                break;
            }
            case 2: {
                this.runTick();
                break;
            }
            case 3: {
                this.runTick();
            }
        }
        this.detectAndSendChanges();
    }

    private void checkPlayerCollision() {
        EntityPlayer player = BrandonsCore.proxy.getClientPlayer();
        double distance = Utills.getDistanceAtoB((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5));
        if (distance < this.getCoreDiameter() / 2.0 + 0.5) {
            double dMod = 1.0 - distance / Math.max(0.1, this.getCoreDiameter() / 2.0 + 0.5);
            double offsetX = player.field_70165_t - (double)this.field_145851_c;
            double offsetY = player.field_70163_u - (double)this.field_145848_d;
            double offsetZ = player.field_70161_v - (double)this.field_145849_e;
            double m = 1.0 * dMod;
            player.func_70024_g(offsetX * m, offsetY * m, offsetZ * m);
        }
    }

    private void offlineTick() {
        if (this.reactionTemperature > 20.0) {
            this.reactionTemperature -= 0.5;
        }
        if (this.fieldCharge > 0.0) {
            this.fieldCharge -= this.maxFieldCharge * 5.0E-4;
        } else if (this.fieldCharge < 0.0) {
            this.fieldCharge = 0.0;
        }
        if (this.energySaturation > 0) {
            this.energySaturation = (int)((double)this.energySaturation - (double)this.maxEnergySaturation * 1.0E-6);
        } else if (this.energySaturation < 0) {
            this.energySaturation = 0;
        }
    }

    private void startingTick() {
        if (!this.startupInitialized) {
            int totalFuel = this.reactorFuel + this.convertedFuel;
            this.maxFieldCharge = (double)totalFuel * 96.45061728395062 * 100.0;
            this.maxEnergySaturation = (int)((double)totalFuel * 96.45061728395062 * 1000.0);
            this.startupInitialized = true;
        }
    }

    private void runTick() {
        double saturation = (double)this.energySaturation / (double)this.maxEnergySaturation;
        double saturationI = (1.0 - (double)this.energySaturation / (double)this.maxEnergySaturation) * 99.0;
        double temp = this.reactionTemperature / this.maxReactTemperature * 50.0;
        double conversion = ((double)this.convertedFuel + this.conversionUnit) / ((double)(this.convertedFuel + this.reactorFuel) - this.conversionUnit) * 1.3 - 0.3;
        double tempOffset = 444.7;
        double tempRiseExpo = saturationI * saturationI * saturationI / (100.0 - saturationI) + tempOffset;
        double tempRiseResist = temp * temp * temp * temp / (100.0 - temp);
        double riseAmount = (tempRiseExpo - tempRiseResist * (1.0 - conversion) + conversion * 1000.0) / 10000.0;
        if (this.reactorState == 3) {
            if (this.reactionTemperature <= 2001.0) {
                this.reactorState = 0;
                this.startupInitialized = false;
                return;
            }
            this.reactionTemperature = (double)this.energySaturation >= (double)this.maxEnergySaturation * 0.99 && this.reactorFuel > 0 ? (this.reactionTemperature -= 1.0 - conversion) : (this.reactionTemperature += riseAmount * 10.0);
        } else {
            this.reactionTemperature += riseAmount * 10.0;
        }
        int baseMaxRFt = (int)((double)this.maxEnergySaturation / 1000.0 * ConfigHandler.reactorOutputMultiplier);
        int maxRFt = (int)((double)baseMaxRFt * (1.0 + conversion * 2.0));
        this.energySaturation = (int)((double)this.energySaturation + (1.0 - saturation) * (double)maxRFt);
        double tempDrainFactor = this.reactionTemperature > 8000.0 ? 1.0 + (this.reactionTemperature - 8000.0) * (this.reactionTemperature - 8000.0) * 2.5E-6 : (this.reactionTemperature > 2000.0 ? 1.0 : (this.reactionTemperature > 1000.0 ? (this.reactionTemperature - 1000.0) / 1000.0 : 0.0));
        int fieldDrain = (int)Math.min(tempDrainFactor * (1.0 - saturation) * ((double)baseMaxRFt / 10.923556), 2.147483647E9);
        this.fieldCharge -= (double)fieldDrain;
        double useRate = tempDrainFactor * (1.0 - saturation) * (0.001 * ConfigHandler.reactorFuelUsageMultiplier);
        this.conversionUnit += useRate;
        if (this.conversionUnit >= 1.0 && this.reactorFuel > 0) {
            this.conversionUnit -= 1.0;
            --this.reactorFuel;
            ++this.convertedFuel;
        }
        if (this.fieldCharge <= 0.0 && !this.hasExploded) {
            this.hasExploded = true;
            this.goBoom();
        }
    }

    private void goBoom() {
        if (!ConfigHandler.enableReactorBigBoom) {
            this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 5.0f, true);
        } else {
            float power = 2.0f + (float)(this.convertedFuel + this.reactorFuel) / 10369.0f * 18.0f;
            ProcessHandler.addProcess((IProcess)new ReactorExplosion(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, power));
            this.sendObjectToClient((byte)2, 100, (int)(power * 10.0f), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 512.0));
        }
    }

    public void validateStructure() {
        boolean updateRequired = false;
        Iterator<MultiblockHelper.TileLocation> i = this.stabilizerLocations.iterator();
        ArrayList<TileReactorStabilizer> stabilizers = new ArrayList<TileReactorStabilizer>();
        while (i.hasNext()) {
            MultiblockHelper.TileLocation location = i.next();
            if (!(location.getTileEntity(this.field_145850_b) instanceof TileReactorStabilizer) || !((TileReactorStabilizer)location.getTileEntity((World)this.field_145850_b)).masterLocation.isThisLocation(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                i.remove();
                updateRequired = true;
                continue;
            }
            stabilizers.add((TileReactorStabilizer)location.getTileEntity(this.field_145850_b));
        }
        this.isStructureValid = false;
        ArrayList<TileReactorStabilizer> checkList = new ArrayList<TileReactorStabilizer>();
        block1: for (TileReactorStabilizer stabilizer : stabilizers) {
            if (checkList.contains(stabilizer)) continue;
            for (TileReactorStabilizer comp : stabilizers) {
                if (comp == stabilizer || checkList.contains(comp) || ForgeDirection.getOrientation((int)comp.facingDirection) != ForgeDirection.getOrientation((int)stabilizer.facingDirection).getOpposite()) continue;
                checkList.add(comp);
                checkList.add(stabilizer);
                if (checkList.size() != 4) continue;
                this.isStructureValid = true;
                if (this.reactorState != 4) continue block1;
                this.reactorState = 0;
                continue block1;
            }
        }
        for (TileReactorStabilizer stabilizer : stabilizers) {
            if (!(Utills.getDistanceAtoB((double)stabilizer.field_145851_c, (double)stabilizer.field_145848_d, (double)stabilizer.field_145849_e, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) < this.getMaxCoreDiameter() / 2.0 + 1.0)) continue;
            this.isStructureValid = false;
            break;
        }
        if (!this.isStructureValid) {
            this.reactorState = 4;
            if (this.reactionTemperature >= 2000.0) {
                this.goBoom();
            }
        }
        if (updateRequired) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void onPlaced() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            boolean flag = false;
            for (int i = 1; i < 10 && !flag; ++i) {
                MultiblockHelper.TileLocation location = new MultiblockHelper.TileLocation(this.field_145851_c + direction.offsetX * i, this.field_145848_d + direction.offsetY * i, this.field_145849_e + direction.offsetZ * i);
                if (location.getTileEntity(this.field_145850_b) == null) continue;
                if (location.getTileEntity(this.field_145850_b) instanceof IIsSlave && !((IIsSlave)location.getTileEntity((World)this.field_145850_b)).getMaster().initialized) {
                    ((IIsSlave)location.getTileEntity(this.field_145850_b)).checkForMaster();
                }
                flag = true;
            }
        }
        this.validateStructure();
    }

    public void onBroken() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            for (int i = 1; i < 10; ++i) {
                MultiblockHelper.TileLocation location = new MultiblockHelper.TileLocation(this.field_145851_c + direction.offsetX * i, this.field_145848_d + direction.offsetY * i, this.field_145849_e + direction.offsetZ * i);
                if (!(location.getTileEntity(this.field_145850_b) instanceof IIsSlave) || ((IIsSlave)location.getTileEntity(this.field_145850_b)).getMaster().compareTo(new MultiblockHelper.TileLocation(this.field_145851_c, this.field_145848_d, this.field_145849_e)) != 0) continue;
                ((IIsSlave)location.getTileEntity(this.field_145850_b)).shutDown();
            }
        }
        if (this.reactionTemperature >= 2000.0) {
            this.goBoom();
        }
    }

    public boolean onStructureRightClicked(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            player.openGui((Object)DraconicEvolution.instance, 14, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    public int injectEnergy(int RF) {
        int received = 0;
        if (this.reactorState == 1) {
            if (!this.startupInitialized) {
                return 0;
            }
            if (this.fieldCharge < this.maxFieldCharge / 2.0) {
                received = Math.min(RF, (int)(this.maxFieldCharge / 2.0) - (int)this.fieldCharge + 1);
                this.fieldCharge += (double)received;
                if (this.fieldCharge > this.maxFieldCharge / 2.0) {
                    this.fieldCharge = this.maxFieldCharge / 2.0;
                }
            } else if (this.energySaturation < this.maxEnergySaturation / 2) {
                received = Math.min(RF, this.maxEnergySaturation / 2 - this.energySaturation);
                this.energySaturation += received;
            } else if (this.reactionTemperature < 2000.0) {
                received = RF;
                this.reactionTemperature += (double)received / (1000.0 + (double)(this.reactorFuel * 10));
                if (this.reactionTemperature > 2000.0) {
                    this.reactionTemperature = 2000.0;
                }
            }
        } else if (this.reactorState == 2 || this.reactorState == 3) {
            this.fieldCharge += (double)RF * (1.0 - this.fieldCharge / this.maxFieldCharge);
            if (this.fieldCharge > this.maxFieldCharge) {
                this.fieldCharge = this.maxFieldCharge;
            }
            return RF;
        }
        return received;
    }

    public boolean canStart() {
        this.validateStructure();
        return this.reactionTemperature >= 2000.0 && this.fieldCharge >= this.maxFieldCharge / 2.0 && this.energySaturation >= this.maxEnergySaturation / 2 && this.isStructureValid;
    }

    public void processButtonPress(int button) {
        this.validateStructure();
        if (button == 0 && this.reactorState != 2 && this.isStructureValid) {
            this.reactorState = 1;
        } else if (button == 1 && this.isStructureValid) {
            this.reactorState = 2;
        } else if (button == 2 && this.reactorState != 0) {
            this.reactorState = 3;
        }
    }

    public double getCoreDiameter() {
        double volume = (double)(this.reactorFuel + this.convertedFuel) / 1296.0;
        return Math.cbrt((volume *= 1.0 + this.reactionTemperature / this.maxReactTemperature * 10.0) / Math.PI) * 2.0;
    }

    public double getMaxCoreDiameter() {
        double volume = (double)(this.reactorFuel + this.convertedFuel) / 1296.0;
        return Math.cbrt((volume *= 11.0) / Math.PI) * 2.0;
    }

    private void detectAndSendChanges() {
        NetworkRegistry.TargetPoint tp = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 128.0);
        if (this.reactionTemperatureCach != this.reactionTemperature) {
            this.reactionTemperatureCach = (Double)this.sendObjectToClient((byte)5, 8, this.reactionTemperature, tp);
        }
        if (this.tick % 10 != 0) {
            return;
        }
        if (this.isStructureValidCach != this.isStructureValid) {
            this.isStructureValidCach = (Boolean)this.sendObjectToClient((byte)6, 0, this.isStructureValid, tp);
        }
        if (this.startupInitializedCach != this.startupInitialized) {
            this.startupInitializedCach = (Boolean)this.sendObjectToClient((byte)6, 2, this.startupInitialized, tp);
        }
        if (this.reactorStateCach != this.reactorState) {
            this.reactorStateCach = (Integer)this.sendObjectToClient((byte)2, 3, this.reactorState, tp);
        }
        if (this.reactorFuelCach != this.reactorFuel) {
            this.reactorFuelCach = (Integer)this.sendObjectToClient((byte)2, 4, this.reactorFuel, tp);
        }
        if (this.convertedFuelCach != this.convertedFuel) {
            this.convertedFuelCach = (Integer)this.sendObjectToClient((byte)2, 5, this.convertedFuel, tp);
        }
        if (this.energySaturationCach != this.energySaturation) {
            this.energySaturationCach = (Integer)this.sendObjectToClient((byte)2, 6, this.energySaturation, tp);
        }
        if (this.maxEnergySaturationCach != this.maxEnergySaturation) {
            this.maxEnergySaturationCach = (Integer)this.sendObjectToClient((byte)2, 7, this.maxEnergySaturation, tp);
        }
        if (this.maxReactTemperatureCach != this.maxReactTemperature) {
            this.maxReactTemperatureCach = (Double)this.sendObjectToClient((byte)5, 9, this.maxReactTemperature, tp);
        }
        if (this.fieldChargeCach != this.fieldCharge) {
            this.fieldChargeCach = (Double)this.sendObjectToClient((byte)5, 10, this.fieldCharge, tp);
        }
        if (this.maxFieldChargeCach != this.maxFieldCharge) {
            this.maxFieldChargeCach = (Double)this.sendObjectToClient((byte)5, 11, this.maxFieldCharge, tp);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void receiveObjectFromServer(int index, Object object) {
        switch (index) {
            case 0: {
                this.isStructureValid = (Boolean)object;
                break;
            }
            case 2: {
                this.startupInitialized = (Boolean)object;
                break;
            }
            case 3: {
                this.reactorState = (Integer)object;
                break;
            }
            case 4: {
                this.reactorFuel = (Integer)object;
                break;
            }
            case 5: {
                this.convertedFuel = (Integer)object;
                break;
            }
            case 6: {
                this.energySaturation = (Integer)object;
                break;
            }
            case 7: {
                this.maxEnergySaturation = (Integer)object;
                break;
            }
            case 8: {
                this.reactionTemperature = (Double)object;
                break;
            }
            case 9: {
                this.maxReactTemperature = (Double)object;
                break;
            }
            case 10: {
                this.fieldCharge = (Double)object;
                break;
            }
            case 11: {
                this.maxFieldCharge = (Double)object;
                break;
            }
            case 100: {
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new Particles.ReactorExplosionParticle(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ((Integer)object).intValue()));
            }
        }
        super.receiveObjectFromServer(index, object);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public double func_145833_n() {
        return 40960.0;
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagList stabilizerList = new NBTTagList();
        for (MultiblockHelper.TileLocation offset : this.stabilizerLocations) {
            NBTTagCompound compound1 = new NBTTagCompound();
            offset.writeToNBT(compound1, "tag");
            stabilizerList.func_74742_a((NBTBase)compound1);
        }
        if (stabilizerList.func_74745_c() > 0) {
            compound.func_74782_a("Stabilizers", (NBTBase)stabilizerList);
        }
        compound.func_74774_a("State", (byte)this.reactorState);
        compound.func_74757_a("isStructureValid", this.isStructureValid);
        compound.func_74757_a("startupInitialized", this.startupInitialized);
        compound.func_74768_a("energySaturation", this.energySaturation);
        compound.func_74768_a("maxEnergySaturation", this.maxEnergySaturation);
        compound.func_74768_a("reactorFuel", this.reactorFuel);
        compound.func_74768_a("convertedFuel", this.convertedFuel);
        compound.func_74780_a("reactionTemperature", this.reactionTemperature);
        compound.func_74780_a("maxReactTemperature", this.maxReactTemperature);
        compound.func_74780_a("fieldCharge", this.fieldCharge);
        compound.func_74780_a("maxFieldCharge", this.maxFieldCharge);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.stabilizerLocations = new ArrayList<MultiblockHelper.TileLocation>();
        if (compound.func_74764_b("Stabilizers")) {
            NBTTagList stabilizerList = compound.func_150295_c("Stabilizers", 10);
            for (int i = 0; i < stabilizerList.func_74745_c(); ++i) {
                MultiblockHelper.TileLocation offset = new MultiblockHelper.TileLocation();
                offset.readFromNBT(stabilizerList.func_150305_b(i), "tag");
                this.stabilizerLocations.add(offset);
            }
        }
        this.reactorState = compound.func_74771_c("State");
        this.isStructureValid = compound.func_74767_n("isStructureValid");
        this.startupInitialized = compound.func_74767_n("startupInitialized");
        this.energySaturation = compound.func_74762_e("energySaturation");
        this.maxEnergySaturation = compound.func_74762_e("maxEnergySaturation");
        this.reactorFuel = compound.func_74762_e("reactorFuel");
        this.convertedFuel = compound.func_74762_e("convertedFuel");
        this.reactionTemperature = compound.func_74769_h("reactionTemperature");
        this.maxReactTemperature = compound.func_74769_h("maxReactTemperature");
        this.fieldCharge = compound.func_74769_h("fieldCharge");
        this.maxFieldCharge = compound.func_74769_h("maxFieldCharge");
    }
}

