/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import codechicken.lib.colour.ColourRGBA;
import java.util.HashMap;

public class ColourTemperature
extends ColourRGBA {
    public static HashMap<Integer, ColourTemperature> cache = new HashMap();
    public double temp;

    public ColourTemperature(double r, double g, double b, double a, double t) {
        super(r, g, b, a);
        this.temp = t;
    }

    public static ColourTemperature fromTemperature(double temperature, ColourRGBA baseColour) {
        double blue;
        double green;
        double tmpCalc;
        double red;
        if (temperature < 0.0) {
            double alphaBlend = -temperature / 300.0;
            if (alphaBlend < 0.0) {
                alphaBlend = 0.0;
            }
            if (alphaBlend > 1.0) {
                alphaBlend = 1.0;
            }
            return new ColourTemperature(1.0, 1.0, 1.0, alphaBlend, temperature).blendOnto(baseColour);
        }
        double absTemp = temperature + 300.0;
        if (cache.containsKey((int)(absTemp /= 100.0))) {
            return cache.get((int)absTemp).blendOnto(baseColour);
        }
        double effectiveTemp = absTemp;
        if (effectiveTemp < 10.0) {
            effectiveTemp = 10.0;
        }
        if (effectiveTemp > 400.0) {
            effectiveTemp = 400.0;
        }
        if (effectiveTemp <= 66.0) {
            red = 1.0;
        } else {
            tmpCalc = effectiveTemp - 60.0;
            tmpCalc = 329.698727446 * Math.pow(tmpCalc, -0.1332047592);
            red = tmpCalc / 255.0;
        }
        if (effectiveTemp <= 66.0) {
            tmpCalc = effectiveTemp;
            tmpCalc = 99.4708025861 * Math.log(tmpCalc) - 161.1195681661;
            green = tmpCalc / 255.0;
        } else {
            tmpCalc = effectiveTemp - 60.0;
            tmpCalc = 288.1221695283 * Math.pow(tmpCalc, -0.0755148492);
            green = tmpCalc / 255.0;
        }
        if (effectiveTemp >= 66.0) {
            blue = 1.0;
        } else if (effectiveTemp <= 19.0) {
            blue = 0.0;
        } else {
            tmpCalc = effectiveTemp - 10.0;
            tmpCalc = 138.5177312231 * Math.log(tmpCalc) - 305.0447927307;
            blue = tmpCalc / 255.0;
        }
        double alpha = temperature / 1000.0;
        if (red < 0.0) {
            red = 0.0;
        }
        if (red > 1.0) {
            red = 1.0;
        }
        if (green < 0.0) {
            green = 0.0;
        }
        if (green > 1.0) {
            green = 1.0;
        }
        if (blue < 0.0) {
            blue = 0.0;
        }
        if (blue > 1.0) {
            blue = 1.0;
        }
        if (alpha < 0.0) {
            alpha = 0.0;
        }
        if (alpha > 1.0) {
            alpha = 1.0;
        }
        ColourTemperature colourTemperature = new ColourTemperature(red, green, blue, alpha, temperature);
        cache.put((int)absTemp, colourTemperature);
        return colourTemperature.blendOnto(baseColour);
    }

    public ColourTemperature blendOnto(ColourRGBA baseColour) {
        double sR = (double)(this.r & 0xFF) / 255.0;
        double sG = (double)(this.g & 0xFF) / 255.0;
        double sB = (double)(this.b & 0xFF) / 255.0;
        double sA = (double)(this.a & 0xFF) / 255.0;
        double dR = (double)(baseColour.r & 0xFF) / 255.0;
        double dG = (double)(baseColour.g & 0xFF) / 255.0;
        double dB = (double)(baseColour.b & 0xFF) / 255.0;
        double dA = (double)(baseColour.a & 0xFF) / 255.0;
        double rR = sR * sA + dR * (1.0 - sA);
        double rG = sG * sA + dG * (1.0 - sA);
        double rB = sB * sA + dB * (1.0 - sA);
        double rA = dA * 1.0 + sA * (1.0 - dA);
        return new ColourTemperature(rR, rG, rB, rA, this.temp);
    }
}

