/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.ColourMultiplier;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.render.uv.IconTransformation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.Map;
import mekanism.api.EnumColor;
import mekanism.common.multipart.PartGlowPanel;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;

public class RenderGlowPanel
implements TextureUtils.IIconSelfRegister {
    public static RenderGlowPanel INSTANCE;
    public static CCModel[] frameModels;
    public static CCModel[] lightModels;
    public static IIcon icon;

    public static RenderGlowPanel getInstance() {
        return INSTANCE;
    }

    public static void init() {
        INSTANCE = new RenderGlowPanel();
        TextureUtils.addIconRegistrar((TextureUtils.IIconSelfRegister)INSTANCE);
        Map models = CCModel.parseObjModels((ResourceLocation)MekanismUtils.getResource(MekanismUtils.ResourceType.MODEL, "glow_panel.obj"), (int)7, null);
        frameModels = new CCModel[6];
        RenderGlowPanel.frameModels[0] = ((CCModel)models.get("frame")).backfacedCopy().apply((Transformation)Vector3.center.translation()).shrinkUVs(5.0E-4);
        CCModel.generateSidedModels((CCModel[])frameModels, (int)0, (Vector3)Vector3.center);
        lightModels = new CCModel[6];
        RenderGlowPanel.lightModels[0] = ((CCModel)models.get("light")).backfacedCopy().apply((Transformation)Vector3.center.translation()).shrinkUVs(5.0E-4);
        CCModel.generateSidedModels((CCModel[])lightModels, (int)0, (Vector3)Vector3.center);
        for (CCModel c : frameModels) {
            c.computeLighting(LightModel.standardLightModel);
        }
    }

    public void renderStatic(PartGlowPanel panel) {
        CCRenderState.reset();
        CCRenderState.setBrightness((IBlockAccess)panel.world(), (int)panel.x(), (int)panel.y(), (int)panel.z());
        ColourRGBA colour = new ColourRGBA((double)panel.colour.getColor(0), (double)panel.colour.getColor(1), (double)panel.colour.getColor(2), 1.0);
        int side = panel.side.ordinal();
        frameModels[side].render(new CCRenderState.IVertexOperation[]{new Translation((double)panel.x(), (double)panel.y(), (double)panel.z()), new IconTransformation(icon)});
        lightModels[side].render(new CCRenderState.IVertexOperation[]{new Translation((double)panel.x(), (double)panel.y(), (double)panel.z()), new IconTransformation(icon), new ColourMultiplier(colour.rgba())});
    }

    public void renderItem(int metadata) {
        TextureUtils.bindAtlas((int)0);
        CCRenderState.reset();
        CCRenderState.startDrawing();
        CCRenderState.hasColour = true;
        EnumColor c = EnumColor.DYES[metadata];
        ColourRGBA colour = new ColourRGBA((double)c.getColor(0), (double)c.getColor(1), (double)c.getColor(2), 1.0);
        ColourRGBA white = new ColourRGBA(1.0, 1.0, 1.0, 1.0);
        for (int i = 4; i < 5; ++i) {
            frameModels[i].render(new CCRenderState.IVertexOperation[]{new IconTransformation(icon), new ColourMultiplier(white.rgba())});
            lightModels[i].render(new CCRenderState.IVertexOperation[]{new IconTransformation(icon), new ColourMultiplier(colour.rgba())});
        }
        CCRenderState.draw();
    }

    public void registerIcons(IIconRegister register) {
        icon = register.func_94245_a("mekanism:models/GlowPanel");
    }

    public int atlasIndex() {
        return 0;
    }
}

