/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.Pos3D;
import mekanism.api.lasers.ILaserReceptor;
import mekanism.common.Mekanism;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;

public class LaserManager {
    public static LaserInfo fireLaser(TileEntity from, ForgeDirection direction, double energy, World world) {
        return LaserManager.fireLaser(new Pos3D(from).centre().translate(direction, 0.501), direction, energy, world);
    }

    public static LaserInfo fireLaser(Pos3D from, ForgeDirection direction, double energy, World world) {
        Pos3D to = from.clone().translate(direction, (double)MekanismConfig.general.laserRange - 0.002);
        MovingObjectPosition mop = world.func_72933_a(Vec3.func_72443_a((double)from.xPos, (double)from.yPos, (double)from.zPos), Vec3.func_72443_a((double)to.xPos, (double)to.yPos, (double)to.zPos));
        if (mop != null) {
            to = new Pos3D(mop.field_72307_f);
            Coord4D toCoord = new Coord4D(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            TileEntity tile = toCoord.getTileEntity((IBlockAccess)world);
            if (tile instanceof ILaserReceptor && !((ILaserReceptor)tile).canLasersDig()) {
                ((ILaserReceptor)tile).receiveLaserEnergy(energy, ForgeDirection.getOrientation((int)mop.field_72310_e));
            }
        }
        from.translateExcludingSide(direction, -0.1);
        to.translateExcludingSide(direction, 0.1);
        boolean foundEntity = false;
        for (Entity e : world.func_72872_a(Entity.class, Pos3D.getAABB(from, to))) {
            foundEntity = true;
            if (!e.func_70045_F()) {
                e.func_70015_d((int)(energy / 1000.0));
            }
            if (!(energy > 256.0)) continue;
            e.func_70097_a(DamageSource.field_76377_j, (float)energy / 1000.0f);
        }
        return new LaserInfo(mop, foundEntity);
    }

    public static List<ItemStack> breakBlock(Coord4D blockCoord, boolean dropAtBlock, World world) {
        if (!MekanismConfig.general.aestheticWorldDamage) {
            return null;
        }
        ArrayList ret = null;
        Block blockHit = blockCoord.getBlock((IBlockAccess)world);
        int meta = blockCoord.getMetadata((IBlockAccess)world);
        EntityPlayer dummy = (EntityPlayer)Mekanism.proxy.getDummyPlayer((WorldServer)world, blockCoord.xCoord, blockCoord.yCoord, blockCoord.zCoord).get();
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(blockCoord.xCoord, blockCoord.yCoord, blockCoord.zCoord, world, blockHit, meta, dummy);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return null;
        }
        if (dropAtBlock) {
            blockHit.func_149697_b(world, blockCoord.xCoord, blockCoord.yCoord, blockCoord.zCoord, blockCoord.getMetadata((IBlockAccess)world), 0);
        } else {
            ret = blockHit.getDrops(world, blockCoord.xCoord, blockCoord.yCoord, blockCoord.zCoord, blockCoord.getMetadata((IBlockAccess)world), 0);
        }
        blockHit.func_149749_a(world, blockCoord.xCoord, blockCoord.yCoord, blockCoord.zCoord, blockHit, blockCoord.getMetadata((IBlockAccess)world));
        world.func_147468_f(blockCoord.xCoord, blockCoord.yCoord, blockCoord.zCoord);
        world.func_72926_e(2001, blockCoord.xCoord, blockCoord.yCoord, blockCoord.zCoord, Block.func_149682_b((Block)blockHit));
        return ret;
    }

    public static MovingObjectPosition fireLaserClient(TileEntity from, ForgeDirection direction, double energy, World world) {
        return LaserManager.fireLaserClient(new Pos3D(from).centre().translate(direction, 0.501), direction, energy, world);
    }

    public static MovingObjectPosition fireLaserClient(Pos3D from, ForgeDirection direction, double energy, World world) {
        Pos3D to = from.clone().translate(direction, (double)MekanismConfig.general.laserRange - 0.002);
        MovingObjectPosition mop = world.func_72933_a(Vec3.func_72443_a((double)from.xPos, (double)from.yPos, (double)from.zPos), Vec3.func_72443_a((double)to.xPos, (double)to.yPos, (double)to.zPos));
        if (mop != null) {
            to = new Pos3D(mop.field_72307_f);
        }
        from.translate(direction, -0.501);
        Mekanism.proxy.renderLaser(world, from, to, direction, energy);
        return mop;
    }

    public static class LaserInfo {
        public MovingObjectPosition movingPos;
        public boolean foundEntity;

        public LaserInfo(MovingObjectPosition mop, boolean b) {
            this.movingPos = mop;
            this.foundEntity = b;
        }
    }
}

