/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.boiler;

import mekanism.api.Coord4D;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.tile.TileEntityBoiler;
import mekanism.common.util.MekanismUtils;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public abstract class BoilerTank
implements IFluidTank {
    public TileEntityBoiler steamBoiler;

    public BoilerTank(TileEntityBoiler tileEntity) {
        this.steamBoiler = tileEntity;
    }

    public abstract void setFluid(FluidStack var1);

    public int getCapacity() {
        return this.steamBoiler.structure != null ? ((SynchronizedBoilerData)this.steamBoiler.structure).volume * 16000 : 0;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.steamBoiler.structure != null && !this.steamBoiler.func_145831_w().field_72995_K) {
            if (resource == null || resource.getFluidID() <= 0) {
                return 0;
            }
            if (this.getFluid() == null || this.getFluid().getFluidID() <= 0) {
                if (resource.amount <= this.getCapacity()) {
                    if (doFill) {
                        this.setFluid(resource.copy());
                    }
                    if (resource.amount > 0 && doFill) {
                        MekanismUtils.saveChunk(this.steamBoiler);
                        this.updateValveData(true);
                        this.steamBoiler.sendPacketToRenderer();
                        this.updateValveData(false);
                    }
                    return resource.amount;
                }
                if (doFill) {
                    this.setFluid(resource.copy());
                    this.getFluid().amount = this.getCapacity();
                }
                if (this.getCapacity() > 0 && doFill) {
                    MekanismUtils.saveChunk(this.steamBoiler);
                    this.updateValveData(true);
                    this.steamBoiler.sendPacketToRenderer();
                    this.updateValveData(false);
                }
                return this.getCapacity();
            }
            if (!this.getFluid().isFluidEqual(resource)) {
                return 0;
            }
            int space = this.getCapacity() - this.getFluid().amount;
            if (resource.amount <= space) {
                if (doFill) {
                    this.getFluid().amount += resource.amount;
                }
                if (resource.amount > 0 && doFill) {
                    MekanismUtils.saveChunk(this.steamBoiler);
                    this.updateValveData(true);
                    this.steamBoiler.sendPacketToRenderer();
                    this.updateValveData(false);
                }
                return resource.amount;
            }
            if (doFill) {
                this.getFluid().amount = this.getCapacity();
            }
            if (space > 0 && doFill) {
                MekanismUtils.saveChunk(this.steamBoiler);
                this.updateValveData(true);
                this.steamBoiler.sendPacketToRenderer();
                this.updateValveData(false);
            }
            return space;
        }
        return 0;
    }

    public void updateValveData(boolean value) {
        if (this.steamBoiler.structure != null) {
            for (SynchronizedBoilerData.ValveData data : ((SynchronizedBoilerData)this.steamBoiler.structure).valves) {
                if (!data.location.equals(Coord4D.get(this.steamBoiler))) continue;
                data.serverFluid = value;
            }
        }
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.steamBoiler.structure != null && !this.steamBoiler.func_145831_w().field_72995_K) {
            if (this.getFluid() == null || this.getFluid().getFluidID() <= 0) {
                return null;
            }
            if (this.getFluid().amount <= 0) {
                return null;
            }
            int used = maxDrain;
            if (this.getFluid().amount < used) {
                used = this.getFluid().amount;
            }
            if (doDrain) {
                this.getFluid().amount -= used;
            }
            FluidStack drained = new FluidStack(this.getFluid().getFluidID(), used);
            if (this.getFluid().amount <= 0) {
                this.setFluid(null);
            }
            if (drained.amount > 0 && doDrain) {
                MekanismUtils.saveChunk(this.steamBoiler);
                this.steamBoiler.sendPacketToRenderer();
            }
            return drained;
        }
        return null;
    }

    public int getFluidAmount() {
        if (this.steamBoiler.structure != null) {
            return this.getFluid().amount;
        }
        return 0;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }
}

