/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration;

import java.util.Arrays;
import java.util.Locale;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.DriverTileEntity;
import li.cil.oc.api.prefab.ManagedEnvironment;
import mekanism.common.integration.IComputerIntegration;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class OCDriver
extends DriverTileEntity {
    public Class<?> getTileEntityClass() {
        return IComputerIntegration.class;
    }

    public ManagedEnvironment createEnvironment(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IComputerIntegration) {
            return new OCManagedEnvironment((IComputerIntegration)tile);
        }
        return null;
    }

    public class OCManagedEnvironment
    extends ManagedEnvironment
    implements NamedBlock,
    ManagedPeripheral {
        public IComputerIntegration computerTile;
        public String name;

        public OCManagedEnvironment(IComputerIntegration tile) {
            this.computerTile = tile;
            this.name = tile.func_145825_b().toLowerCase(Locale.ENGLISH).replace(" ", "_");
            this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.name, Visibility.Network).create());
        }

        public String[] methods() {
            return this.computerTile.getMethods();
        }

        public Object[] invoke(String method, Context context, Arguments args) throws Exception {
            return this.computerTile.invoke(Arrays.asList(this.methods()).indexOf(method), args.toArray());
        }

        public int priority() {
            return 4;
        }

        public String preferredName() {
            return this.name;
        }
    }
}

