/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.util.LangUtils;
import net.minecraft.block.Block;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemBlockGasTank
extends ItemBlock
implements IGasItem,
ISustainedInventory {
    public Block metaBlock;
    public int MAX_GAS = 96000;
    public static final int TRANSFER_RATE = 256;

    public ItemBlockGasTank(Block block) {
        super(block);
        this.metaBlock = block;
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
        this.func_77637_a(Mekanism.tabMekanism);
    }

    public int func_77647_b(int i) {
        return i;
    }

    public IIcon func_77617_a(int i) {
        return this.metaBlock.func_149691_a(2, i);
    }

    public String func_77667_c(ItemStack itemstack) {
        return this.func_77658_a() + "." + "GasTank";
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean place = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (place) {
            TileEntityGasTank tileEntity = (TileEntityGasTank)world.func_147438_o(x, y, z);
            tileEntity.gasTank.setGas(this.getGas(stack));
            tileEntity.setInventory(this.getInventory(stack), new Object[0]);
        }
        return place;
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        GasStack gasStack = this.getGas(itemstack);
        if (gasStack == null) {
            list.add(LangUtils.localize("tooltip.noGas") + ".");
        } else {
            list.add(LangUtils.localize("tooltip.stored") + " " + gasStack.getGas().getLocalizedName() + ": " + gasStack.amount);
        }
        if (!MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.sneakKey)) {
            list.add(LangUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.AQUA) + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.forDetails") + ".");
        } else {
            list.add((Object)((Object)EnumColor.AQUA) + LangUtils.localize("tooltip.inventory") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.transYesNo(this.getInventory(itemstack) != null && this.getInventory(itemstack).func_74745_c() != 0));
        }
    }

    public void func_77622_d(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        itemstack = this.getEmptyItem();
    }

    @Override
    public GasStack getGas(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return null;
        }
        GasStack stored = GasStack.readFromNBT(itemstack.field_77990_d.func_74775_l("stored"));
        if (stored == null) {
            itemstack.func_77964_b(100);
        } else {
            itemstack.func_77964_b((int)Math.max(1.0f, Math.abs((float)stored.amount / (float)this.getMaxGas(itemstack) * 100.0f - 100.0f)));
        }
        return stored;
    }

    @Override
    public void setGas(ItemStack itemstack, GasStack stack) {
        if (itemstack.field_77990_d == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        if (stack == null || stack.amount == 0) {
            itemstack.func_77964_b(100);
            itemstack.field_77990_d.func_82580_o("stored");
        } else {
            int amount = Math.max(0, Math.min(stack.amount, this.getMaxGas(itemstack)));
            GasStack gasStack = new GasStack(stack.getGas(), amount);
            itemstack.func_77964_b((int)Math.max(1.0f, Math.abs((float)amount / (float)this.getMaxGas(itemstack) * 100.0f - 100.0f)));
            itemstack.field_77990_d.func_74782_a("stored", (NBTBase)gasStack.write(new NBTTagCompound()));
        }
    }

    public ItemStack getEmptyItem() {
        ItemStack empty = new ItemStack((Item)this);
        this.setGas(empty, null);
        empty.func_77964_b(100);
        return empty;
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        ItemStack empty = new ItemStack((Item)this);
        this.setGas(empty, null);
        empty.func_77964_b(100);
        list.add(empty);
        for (Gas type : GasRegistry.getRegisteredGasses()) {
            if (!type.isVisible()) continue;
            ItemStack filled = new ItemStack((Item)this);
            this.setGas(filled, new GasStack(type, ((IGasItem)filled.func_77973_b()).getMaxGas(filled)));
            list.add(filled);
        }
    }

    @Override
    public int getMaxGas(ItemStack itemstack) {
        return this.MAX_GAS;
    }

    @Override
    public int getRate(ItemStack itemstack) {
        return 256;
    }

    @Override
    public int addGas(ItemStack itemstack, GasStack stack) {
        if (this.getGas(itemstack) != null && this.getGas(itemstack).getGas() != stack.getGas()) {
            return 0;
        }
        int toUse = Math.min(this.getMaxGas(itemstack) - this.getStored(itemstack), Math.min(this.getRate(itemstack), stack.amount));
        this.setGas(itemstack, new GasStack(stack.getGas(), this.getStored(itemstack) + toUse));
        return toUse;
    }

    @Override
    public GasStack removeGas(ItemStack itemstack, int amount) {
        if (this.getGas(itemstack) == null) {
            return null;
        }
        Gas type = this.getGas(itemstack).getGas();
        int gasToUse = Math.min(this.getStored(itemstack), Math.min(this.getRate(itemstack), amount));
        this.setGas(itemstack, new GasStack(type, this.getStored(itemstack) - gasToUse));
        return new GasStack(type, gasToUse);
    }

    private int getStored(ItemStack itemstack) {
        return this.getGas(itemstack) != null ? this.getGas((ItemStack)itemstack).amount : 0;
    }

    @Override
    public boolean canReceiveGas(ItemStack itemstack, Gas type) {
        return this.getGas(itemstack) == null || this.getGas(itemstack).getGas() == type;
    }

    @Override
    public boolean canProvideGas(ItemStack itemstack, Gas type) {
        return this.getGas(itemstack) != null && (type == null || this.getGas(itemstack).getGas() == type);
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74782_a("Items", (NBTBase)nbtTags);
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            return itemStack.field_77990_d.func_150295_c("Items", 10);
        }
        return null;
    }

    @Override
    public boolean isMetadataSpecific(ItemStack itemStack) {
        return false;
    }
}

