/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.ITransmitterTile;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.base.ITileNetwork;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityDynamicTank;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;

public class PacketDataRequest
implements IMessageHandler<DataRequestMessage, IMessage> {
    public IMessage onMessage(DataRequestMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        WorldServer worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.coord4D.dimensionId);
        if (worldServer != null && message.coord4D.getTileEntity((IBlockAccess)worldServer) instanceof ITileNetwork) {
            IGridTransmitter transmitter;
            TileEntity tileEntity = message.coord4D.getTileEntity((IBlockAccess)worldServer);
            if (tileEntity instanceof TileEntityDynamicTank) {
                ((TileEntityDynamicTank)tileEntity).sendStructure = true;
            }
            if (tileEntity instanceof ITransmitterTile && (transmitter = ((ITransmitterTile)tileEntity).getTransmitter()).hasTransmitterNetwork()) {
                ((DynamicNetwork)transmitter.getTransmitterNetwork()).addUpdate(player);
            }
            Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), ((ITileNetwork)tileEntity).getNetworkedData(new ArrayList())), (EntityPlayerMP)player);
        }
        return null;
    }

    public static class DataRequestMessage
    implements IMessage {
        public Coord4D coord4D;

        public DataRequestMessage() {
        }

        public DataRequestMessage(Coord4D coord) {
            this.coord4D = coord;
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.coord4D.xCoord);
            dataStream.writeInt(this.coord4D.yCoord);
            dataStream.writeInt(this.coord4D.zCoord);
            dataStream.writeInt(this.coord4D.dimensionId);
        }

        public void fromBytes(ByteBuf dataStream) {
            this.coord4D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
        }
    }
}

