/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.gas.GasStack;
import mekanism.api.infuse.InfuseType;
import mekanism.api.util.StackUtils;
import mekanism.common.block.BlockMachine;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.inputs.ChemicalPairInput;
import mekanism.common.recipe.inputs.FluidInput;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.inputs.IntegerInput;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.recipe.machines.AdvancedMachineRecipe;
import mekanism.common.recipe.machines.AmbientGasRecipe;
import mekanism.common.recipe.machines.BasicMachineRecipe;
import mekanism.common.recipe.machines.ChanceMachineRecipe;
import mekanism.common.recipe.machines.ChemicalInfuserRecipe;
import mekanism.common.recipe.machines.CombinerRecipe;
import mekanism.common.recipe.machines.CrusherRecipe;
import mekanism.common.recipe.machines.CrystallizerRecipe;
import mekanism.common.recipe.machines.DissolutionRecipe;
import mekanism.common.recipe.machines.EnrichmentRecipe;
import mekanism.common.recipe.machines.InjectionRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.machines.OsmiumCompressorRecipe;
import mekanism.common.recipe.machines.OxidationRecipe;
import mekanism.common.recipe.machines.PressurizedRecipe;
import mekanism.common.recipe.machines.PurificationRecipe;
import mekanism.common.recipe.machines.SawmillRecipe;
import mekanism.common.recipe.machines.SeparatorRecipe;
import mekanism.common.recipe.machines.SmeltingRecipe;
import mekanism.common.recipe.machines.SolarEvaporationRecipe;
import mekanism.common.recipe.machines.SolarNeutronRecipe;
import mekanism.common.recipe.machines.WasherRecipe;
import mekanism.common.recipe.outputs.ChanceOutput;
import mekanism.common.recipe.outputs.ChemicalPairOutput;
import mekanism.common.recipe.outputs.FluidOutput;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.recipe.outputs.MachineOutput;
import mekanism.common.recipe.outputs.PressurizedOutput;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public final class RecipeHandler {
    public static void addRecipe(Recipe recipeMap, MachineRecipe recipe) {
        recipeMap.put(recipe);
    }

    public static void removeRecipe(Recipe recipeMap, MachineRecipe recipe) {
        recipeMap.remove(recipe);
    }

    public static void addEnrichmentChamberRecipe(ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.ENRICHMENT_CHAMBER, new EnrichmentRecipe(input, output));
    }

    public static void addOsmiumCompressorRecipe(ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.OSMIUM_COMPRESSOR, new OsmiumCompressorRecipe(input, output));
    }

    public static void addCombinerRecipe(ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.COMBINER, new CombinerRecipe(input, output));
    }

    public static void addCrusherRecipe(ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.CRUSHER, new CrusherRecipe(input, output));
    }

    public static void addPurificationChamberRecipe(ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.PURIFICATION_CHAMBER, new PurificationRecipe(input, output));
    }

    public static void addMetallurgicInfuserRecipe(InfuseType infuse, int amount, ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.METALLURGIC_INFUSER, new MetallurgicInfuserRecipe(new InfusionInput(infuse, amount, input), output));
    }

    public static void addChemicalInfuserRecipe(GasStack leftInput, GasStack rightInput, GasStack output) {
        RecipeHandler.addRecipe(Recipe.CHEMICAL_INFUSER, new ChemicalInfuserRecipe(leftInput, rightInput, output));
    }

    public static void addChemicalOxidizerRecipe(ItemStack input, GasStack output) {
        RecipeHandler.addRecipe(Recipe.CHEMICAL_OXIDIZER, new OxidationRecipe(input, output));
    }

    public static void addChemicalInjectionChamberRecipe(ItemStack input, String gasName, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.CHEMICAL_INJECTION_CHAMBER, new InjectionRecipe(input, gasName, output));
    }

    public static void addElectrolyticSeparatorRecipe(FluidStack fluid, double energy, GasStack leftOutput, GasStack rightOutput) {
        RecipeHandler.addRecipe(Recipe.ELECTROLYTIC_SEPARATOR, new SeparatorRecipe(fluid, energy, leftOutput, rightOutput));
    }

    public static void addPrecisionSawmillRecipe(ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, double chance) {
        RecipeHandler.addRecipe(Recipe.PRECISION_SAWMILL, new SawmillRecipe(input, primaryOutput, secondaryOutput, chance));
    }

    public static void addPrecisionSawmillRecipe(ItemStack input, ItemStack primaryOutput) {
        RecipeHandler.addRecipe(Recipe.PRECISION_SAWMILL, new SawmillRecipe(input, primaryOutput));
    }

    public static void addChemicalDissolutionChamberRecipe(ItemStack input, GasStack output) {
        RecipeHandler.addRecipe(Recipe.CHEMICAL_DISSOLUTION_CHAMBER, new DissolutionRecipe(input, output));
    }

    public static void addChemicalWasherRecipe(GasStack input, GasStack output) {
        RecipeHandler.addRecipe(Recipe.CHEMICAL_WASHER, new WasherRecipe(input, output));
    }

    public static void addChemicalCrystallizerRecipe(GasStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.CHEMICAL_CRYSTALLIZER, new CrystallizerRecipe(input, output));
    }

    public static void addPRCRecipe(ItemStack inputSolid, FluidStack inputFluid, GasStack inputGas, ItemStack outputSolid, GasStack outputGas, double extraEnergy, int ticks) {
        RecipeHandler.addRecipe(Recipe.PRESSURIZED_REACTION_CHAMBER, new PressurizedRecipe(inputSolid, inputFluid, inputGas, outputSolid, outputGas, extraEnergy, ticks));
    }

    public static void addSolarEvaporationRecipe(FluidStack inputFluid, FluidStack outputFluid) {
        RecipeHandler.addRecipe(Recipe.SOLAR_EVAPORATION_PLANT, new SolarEvaporationRecipe(inputFluid, outputFluid));
    }

    public static void addSolarNeutronRecipe(GasStack inputGas, GasStack outputGas) {
        RecipeHandler.addRecipe(Recipe.SOLAR_NEUTRON_ACTIVATOR, new SolarNeutronRecipe(inputGas, outputGas));
    }

    public static void addAmbientGas(int dimensionID, String ambientGasName) {
        RecipeHandler.addRecipe(Recipe.AMBIENT_ACCUMULATOR, new AmbientGasRecipe(dimensionID, ambientGasName));
    }

    public static MetallurgicInfuserRecipe getMetallurgicInfuserRecipe(InfusionInput input) {
        if (input.isValid()) {
            HashMap recipes = Recipe.METALLURGIC_INFUSER.get();
            MetallurgicInfuserRecipe recipe = (MetallurgicInfuserRecipe)recipes.get(input);
            return recipe == null ? null : recipe.copy();
        }
        return null;
    }

    public static ChemicalInfuserRecipe getChemicalInfuserRecipe(ChemicalPairInput input) {
        if (input.isValid()) {
            HashMap recipes = Recipe.CHEMICAL_INFUSER.get();
            ChemicalInfuserRecipe recipe = (ChemicalInfuserRecipe)recipes.get(input);
            return recipe == null ? null : recipe.copy();
        }
        return null;
    }

    public static CrystallizerRecipe getChemicalCrystallizerRecipe(GasInput input) {
        if (input.isValid()) {
            HashMap recipes = Recipe.CHEMICAL_CRYSTALLIZER.get();
            CrystallizerRecipe recipe = (CrystallizerRecipe)recipes.get(input);
            return recipe == null ? null : recipe.copy();
        }
        return null;
    }

    public static WasherRecipe getChemicalWasherRecipe(GasInput input) {
        if (input.isValid()) {
            HashMap recipes = Recipe.CHEMICAL_WASHER.get();
            WasherRecipe recipe = (WasherRecipe)recipes.get(input);
            return recipe == null ? null : recipe.copy();
        }
        return null;
    }

    public static DissolutionRecipe getDissolutionRecipe(ItemStackInput input) {
        if (input.isValid()) {
            HashMap recipes = Recipe.CHEMICAL_DISSOLUTION_CHAMBER.get();
            DissolutionRecipe recipe = (DissolutionRecipe)RecipeHandler.getRecipeTryWildcard(input, recipes);
            return recipe == null ? null : recipe.copy();
        }
        return null;
    }

    public static OxidationRecipe getOxidizerRecipe(ItemStackInput input) {
        if (input.isValid()) {
            HashMap recipes = Recipe.CHEMICAL_OXIDIZER.get();
            OxidationRecipe recipe = (OxidationRecipe)RecipeHandler.getRecipeTryWildcard(input, recipes);
            return recipe == null ? null : recipe.copy();
        }
        return null;
    }

    public static <RECIPE extends ChanceMachineRecipe<RECIPE>> RECIPE getChanceRecipe(ItemStackInput input, Map<ItemStackInput, RECIPE> recipes) {
        if (input.isValid()) {
            ChanceMachineRecipe recipe = (ChanceMachineRecipe)RecipeHandler.getRecipeTryWildcard(input, recipes);
            return (RECIPE)(recipe == null ? null : (ChanceMachineRecipe)recipe.copy());
        }
        return null;
    }

    public static <RECIPE extends BasicMachineRecipe<RECIPE>> RECIPE getRecipe(ItemStackInput input, Map<ItemStackInput, RECIPE> recipes) {
        if (input.isValid()) {
            BasicMachineRecipe recipe = (BasicMachineRecipe)RecipeHandler.getRecipeTryWildcard(input, recipes);
            return (RECIPE)(recipe == null ? null : (BasicMachineRecipe)recipe.copy());
        }
        return null;
    }

    public static <RECIPE extends AdvancedMachineRecipe<RECIPE>> RECIPE getRecipe(AdvancedMachineInput input, Map<AdvancedMachineInput, RECIPE> recipes) {
        if (input.isValid()) {
            AdvancedMachineRecipe recipe = (AdvancedMachineRecipe)recipes.get(input);
            return (RECIPE)(recipe == null ? null : (AdvancedMachineRecipe)recipe.copy());
        }
        return null;
    }

    public static SeparatorRecipe getElectrolyticSeparatorRecipe(FluidInput input) {
        if (input.isValid()) {
            HashMap recipes = Recipe.ELECTROLYTIC_SEPARATOR.get();
            SeparatorRecipe recipe = (SeparatorRecipe)recipes.get(input);
            return recipe == null ? null : recipe.copy();
        }
        return null;
    }

    public static SolarEvaporationRecipe getSolarEvaporationRecipe(FluidInput input) {
        if (input.isValid()) {
            HashMap recipes = Recipe.SOLAR_EVAPORATION_PLANT.get();
            SolarEvaporationRecipe recipe = (SolarEvaporationRecipe)recipes.get(input);
            return recipe == null ? null : recipe.copy();
        }
        return null;
    }

    public static SolarNeutronRecipe getSolarNeutronRecipe(GasInput input) {
        if (input.isValid()) {
            HashMap recipes = Recipe.SOLAR_NEUTRON_ACTIVATOR.get();
            SolarNeutronRecipe recipe = (SolarNeutronRecipe)recipes.get(input);
            return recipe == null ? null : recipe.copy();
        }
        return null;
    }

    public static PressurizedRecipe getPRCRecipe(PressurizedInput input) {
        if (input.isValid()) {
            HashMap recipes = Recipe.PRESSURIZED_REACTION_CHAMBER.get();
            PressurizedRecipe recipe = (PressurizedRecipe)recipes.get(input);
            return recipe == null ? null : recipe.copy();
        }
        return null;
    }

    public static AmbientGasRecipe getDimensionGas(IntegerInput input) {
        HashMap recipes = Recipe.AMBIENT_ACCUMULATOR.get();
        AmbientGasRecipe recipe = (AmbientGasRecipe)recipes.get(input);
        return recipe == null ? null : recipe.copy();
    }

    public static <RECIPE extends MachineRecipe<ItemStackInput, ?, RECIPE>> boolean isInRecipe(ItemStack itemstack, Map<ItemStackInput, RECIPE> recipes) {
        if (itemstack != null) {
            for (MachineRecipe recipe : recipes.values()) {
                ItemStackInput required = (ItemStackInput)recipe.getInput();
                if (!required.useItemStackFromInventory(new ItemStack[]{itemstack}, 0, false)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInPressurizedRecipe(ItemStack stack) {
        if (stack != null) {
            for (PressurizedInput key : Recipe.PRESSURIZED_REACTION_CHAMBER.get().keySet()) {
                if (!key.containsType(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static <RECIPE extends MachineRecipe<ItemStackInput, ?, RECIPE>> RECIPE getRecipeTryWildcard(ItemStack stack, Map<ItemStackInput, RECIPE> recipes) {
        return RecipeHandler.getRecipeTryWildcard(new ItemStackInput(stack), recipes);
    }

    public static <RECIPE extends MachineRecipe<ItemStackInput, ?, RECIPE>> RECIPE getRecipeTryWildcard(ItemStackInput input, Map<ItemStackInput, RECIPE> recipes) {
        MachineRecipe recipe = (MachineRecipe)recipes.get(input);
        if (recipe == null) {
            recipe = (MachineRecipe)recipes.get(input.wildCopy());
        }
        return (RECIPE)recipe;
    }

    public static enum Recipe {
        ENERGIZED_SMELTER(BlockMachine.MachineType.ENERGIZED_SMELTER.name, ItemStackInput.class, ItemStackOutput.class, SmeltingRecipe.class),
        ENRICHMENT_CHAMBER(BlockMachine.MachineType.ENRICHMENT_CHAMBER.name, ItemStackInput.class, ItemStackOutput.class, EnrichmentRecipe.class),
        OSMIUM_COMPRESSOR(BlockMachine.MachineType.OSMIUM_COMPRESSOR.name, AdvancedMachineInput.class, ItemStackOutput.class, OsmiumCompressorRecipe.class),
        COMBINER(BlockMachine.MachineType.COMBINER.name, AdvancedMachineInput.class, ItemStackOutput.class, CombinerRecipe.class),
        CRUSHER(BlockMachine.MachineType.CRUSHER.name, ItemStackInput.class, ItemStackOutput.class, CrusherRecipe.class),
        PURIFICATION_CHAMBER(BlockMachine.MachineType.PURIFICATION_CHAMBER.name, AdvancedMachineInput.class, ItemStackOutput.class, PurificationRecipe.class),
        METALLURGIC_INFUSER(BlockMachine.MachineType.METALLURGIC_INFUSER.name, InfusionInput.class, ItemStackOutput.class, MetallurgicInfuserRecipe.class),
        CHEMICAL_INFUSER(BlockMachine.MachineType.CHEMICAL_INFUSER.name, ChemicalPairInput.class, GasOutput.class, ChemicalInfuserRecipe.class),
        CHEMICAL_OXIDIZER(BlockMachine.MachineType.CHEMICAL_OXIDIZER.name, ItemStackInput.class, GasOutput.class, OxidationRecipe.class),
        CHEMICAL_INJECTION_CHAMBER(BlockMachine.MachineType.CHEMICAL_INJECTION_CHAMBER.name, AdvancedMachineInput.class, ItemStackOutput.class, InjectionRecipe.class),
        ELECTROLYTIC_SEPARATOR(BlockMachine.MachineType.ELECTROLYTIC_SEPARATOR.name, FluidInput.class, ChemicalPairOutput.class, SeparatorRecipe.class),
        PRECISION_SAWMILL(BlockMachine.MachineType.PRECISION_SAWMILL.name, ItemStackInput.class, ChanceOutput.class, SawmillRecipe.class),
        CHEMICAL_DISSOLUTION_CHAMBER(BlockMachine.MachineType.CHEMICAL_DISSOLUTION_CHAMBER.name, ItemStackInput.class, GasOutput.class, DissolutionRecipe.class),
        CHEMICAL_WASHER(BlockMachine.MachineType.CHEMICAL_WASHER.name, GasInput.class, GasOutput.class, WasherRecipe.class),
        CHEMICAL_CRYSTALLIZER(BlockMachine.MachineType.CHEMICAL_CRYSTALLIZER.name, GasInput.class, ItemStackOutput.class, CrystallizerRecipe.class),
        PRESSURIZED_REACTION_CHAMBER(BlockMachine.MachineType.PRESSURIZED_REACTION_CHAMBER.name, PressurizedInput.class, PressurizedOutput.class, PressurizedRecipe.class),
        AMBIENT_ACCUMULATOR(BlockMachine.MachineType.AMBIENT_ACCUMULATOR.name, IntegerInput.class, GasOutput.class, AmbientGasRecipe.class),
        SOLAR_EVAPORATION_PLANT("SolarEvaporationPlant", FluidInput.class, FluidOutput.class, SolarEvaporationRecipe.class),
        SOLAR_NEUTRON_ACTIVATOR(BlockMachine.MachineType.SOLAR_NEUTRON_ACTIVATOR.name, GasInput.class, GasOutput.class, SolarNeutronRecipe.class);

        private HashMap recipes;
        private String recipeName;
        private Class<? extends MachineInput> inputClass;
        private Class<? extends MachineOutput> outputClass;
        private Class<? extends MachineRecipe> recipeClass;

        private <INPUT extends MachineInput<INPUT>, OUTPUT extends MachineOutput<OUTPUT>, RECIPE extends MachineRecipe<INPUT, ?, RECIPE>> Recipe(String name, Class<INPUT> input, Class<OUTPUT> output, Class<RECIPE> recipe) {
            this.recipeName = name;
            this.inputClass = input;
            this.outputClass = output;
            this.recipeClass = recipe;
            this.recipes = new HashMap();
        }

        public <RECIPE extends MachineRecipe<?, ?, RECIPE>> void put(RECIPE recipe) {
            this.recipes.put(recipe.getInput(), recipe);
        }

        public <RECIPE extends MachineRecipe<?, ?, RECIPE>> void remove(RECIPE recipe) {
            this.recipes.remove(recipe.getInput());
        }

        public String getRecipeName() {
            return this.recipeName;
        }

        public <INPUT> INPUT createInput(NBTTagCompound nbtTags) {
            try {
                MachineInput input = this.inputClass.newInstance();
                input.load(nbtTags);
                return (INPUT)input;
            }
            catch (Exception e) {
                return null;
            }
        }

        public <RECIPE, INPUT> RECIPE createRecipe(INPUT input, NBTTagCompound nbtTags) {
            try {
                MachineOutput output = this.outputClass.newInstance();
                output.load(nbtTags);
                Constructor<? extends MachineRecipe> construct = this.recipeClass.getDeclaredConstructor(this.inputClass, this.outputClass);
                return (RECIPE)construct.newInstance(input, output);
            }
            catch (Exception e) {
                return null;
            }
        }

        public boolean containsRecipe(ItemStack input) {
            for (Map.Entry obj : this.get().entrySet()) {
                ItemStack stack;
                Map.Entry entry;
                if (!(obj instanceof Map.Entry) || !((entry = obj).getKey() instanceof ItemStackInput ? StackUtils.equalsWildcard(stack = ((ItemStackInput)entry.getKey()).ingredient, input) : (entry.getKey() instanceof FluidInput ? ((FluidInput)entry.getKey()).ingredient.isFluidEqual(input) : entry.getKey() instanceof AdvancedMachineInput && StackUtils.equalsWildcard(stack = ((AdvancedMachineInput)entry.getKey()).itemStack, input)))) continue;
                return true;
            }
            return false;
        }

        public boolean containsRecipe(Fluid input) {
            for (Map.Entry obj : this.get().entrySet()) {
                Map.Entry entry;
                if (!(obj instanceof Map.Entry) || !((entry = obj).getKey() instanceof FluidInput) || ((FluidInput)entry.getKey()).ingredient.getFluid() != input) continue;
                return true;
            }
            return false;
        }

        public HashMap get() {
            return this.recipes;
        }
    }
}

