/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.inputs;

import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.api.util.StackUtils;
import mekanism.common.InfuseStorage;
import mekanism.common.recipe.inputs.MachineInput;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class InfusionInput
extends MachineInput<InfusionInput> {
    public InfuseStorage infuse;
    public ItemStack inputStack;

    public InfusionInput(InfuseStorage storage, ItemStack itemStack) {
        this.infuse = new InfuseStorage(storage.type, storage.amount);
        this.inputStack = itemStack;
    }

    public InfusionInput(InfuseType infusionType, int required, ItemStack itemStack) {
        this.infuse = new InfuseStorage(infusionType, required);
        this.inputStack = itemStack;
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.inputStack = ItemStack.func_77949_a((NBTTagCompound)nbtTags.func_74775_l("input"));
        InfuseType type = InfuseRegistry.get(nbtTags.func_74779_i("infuseType"));
        int amount = nbtTags.func_74762_e("infuseAmount");
        this.infuse = new InfuseStorage(type, amount);
    }

    public InfusionInput() {
    }

    @Override
    public InfusionInput copy() {
        return new InfusionInput(this.infuse.type, this.infuse.amount, this.inputStack.func_77946_l());
    }

    @Override
    public boolean isValid() {
        return this.infuse.type != null && this.inputStack != null;
    }

    public boolean use(ItemStack[] inventory, int index, InfuseStorage infuseStorage, boolean deplete) {
        if (StackUtils.contains(inventory[index], this.inputStack) && infuseStorage.contains(this.infuse)) {
            if (deplete) {
                inventory[index] = StackUtils.subtract(inventory[index], this.inputStack);
                infuseStorage.subtract(this.infuse);
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashIngredients() {
        return this.infuse.type.unlocalizedName.hashCode() << 8 | StackUtils.hashItemStack(this.inputStack);
    }

    @Override
    public boolean testEquality(InfusionInput other) {
        if (!this.isValid()) {
            return !other.isValid();
        }
        return this.infuse.type == other.infuse.type && StackUtils.equalsWildcardWithNBT(this.inputStack, other.inputStack);
    }

    @Override
    public boolean isInstance(Object other) {
        return other instanceof InfusionInput;
    }
}

