/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.inputs;

import mekanism.api.util.StackUtils;
import mekanism.common.recipe.inputs.MachineInput;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemStackInput
extends MachineInput<ItemStackInput> {
    public ItemStack ingredient;

    public ItemStackInput(ItemStack stack) {
        this.ingredient = stack;
    }

    public ItemStackInput() {
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.ingredient = ItemStack.func_77949_a((NBTTagCompound)nbtTags.func_74775_l("input"));
    }

    @Override
    public ItemStackInput copy() {
        return new ItemStackInput(this.ingredient.func_77946_l());
    }

    @Override
    public boolean isValid() {
        return this.ingredient != null;
    }

    public ItemStackInput wildCopy() {
        return new ItemStackInput(new ItemStack(this.ingredient.func_77973_b(), this.ingredient.field_77994_a, Short.MAX_VALUE));
    }

    public boolean useItemStackFromInventory(ItemStack[] inventory, int index, boolean deplete) {
        if (StackUtils.contains(inventory[index], this.ingredient)) {
            if (deplete) {
                inventory[index] = StackUtils.subtract(inventory[index], this.ingredient);
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashIngredients() {
        return StackUtils.hashItemStack(this.ingredient);
    }

    @Override
    public boolean testEquality(ItemStackInput other) {
        return StackUtils.equalsWildcardWithNBT(this.ingredient, other.ingredient);
    }

    @Override
    public boolean isInstance(Object other) {
        return other instanceof ItemStackInput;
    }
}

