/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import mekanism.common.util.LangUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidContainerItem;

public final class FluidContainerUtils {
    public static FluidStack extractFluid(FluidTank tileTank, ItemStack container) {
        return FluidContainerUtils.extractFluid(tileTank, container, tileTank.getFluid() != null ? tileTank.getFluid().getFluid() : null);
    }

    public static FluidStack extractFluid(FluidTank tileTank, ItemStack container, Fluid fluid) {
        return FluidContainerUtils.extractFluid(tileTank.getCapacity() - tileTank.getFluidAmount(), container, fluid);
    }

    public static FluidStack extractFluid(int needed, ItemStack container, Fluid fluid) {
        IFluidContainerItem item = (IFluidContainerItem)container.func_77973_b();
        if (item.getFluid(container) == null) {
            return null;
        }
        if (fluid != null && item.getFluid(container).getFluid() != fluid) {
            return null;
        }
        return item.drain(container, needed, true);
    }

    public static int insertFluid(FluidTank tileTank, ItemStack container) {
        return FluidContainerUtils.insertFluid(tileTank.getFluid(), container);
    }

    public static int insertFluid(FluidStack fluid, ItemStack container) {
        IFluidContainerItem item = (IFluidContainerItem)container.func_77973_b();
        if (fluid == null) {
            return 0;
        }
        return item.fill(container, fluid, true);
    }

    public static enum ContainerEditMode {
        BOTH("fluidedit.both"),
        FILL("fluidedit.fill"),
        EMPTY("fluidedit.empty");

        private String display;

        public String getDisplay() {
            return LangUtils.localize(this.display);
        }

        private ContainerEditMode(String s) {
            this.display = s;
        }
    }
}

